/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.actions.AbstractObjectEditor;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AddObject;
import com.metamatrix.common.actions.BasicModificationActionQueue;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.DestroyObject;
import com.metamatrix.common.actions.ExchangeBoolean;
import com.metamatrix.common.actions.ExchangeInt;
import com.metamatrix.common.actions.ExchangeLong;
import com.metamatrix.common.actions.ExchangeObject;
import com.metamatrix.common.actions.RemoveObject;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeDefnID;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.PropDefnAllowedValue;
import com.metamatrix.common.config.api.PropDefnAllowedValueID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.InvalidComponentException;
import com.metamatrix.common.config.model.BasicAuthenticationProvider;
import com.metamatrix.common.config.model.BasicComponentDefn;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.model.BasicComponentTypeDefn;
import com.metamatrix.common.config.model.BasicConfiguration;
import com.metamatrix.common.config.model.BasicConfigurationInfo;
import com.metamatrix.common.config.model.BasicConnectorBinding;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.config.model.BasicProductServiceConfig;
import com.metamatrix.common.config.model.BasicProductType;
import com.metamatrix.common.config.model.BasicPropDefnAllowedValue;
import com.metamatrix.common.config.model.BasicResourceDescriptor;
import com.metamatrix.common.config.model.BasicServiceComponentDefn;
import com.metamatrix.common.config.model.BasicSharedResource;
import com.metamatrix.common.config.model.BasicUtil;
import com.metamatrix.common.config.model.BasicVMComponentDefn;
import com.metamatrix.common.config.model.ConfigurationModel;
import com.metamatrix.common.config.model.ConfigurationObjectEditorHelper;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.common.log.config.LogConfigurationException;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BaseObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.id.UUIDFactory;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BasicConfigurationObjectEditor
extends AbstractObjectEditor
implements ConfigurationObjectEditor {
    private static final long serialVersionUID = -51562836234358446L;
    private ObjectIDFactory factory = null;

    private ObjectIDFactory getObjectIDFactory() {
        if (this.factory == null) {
            this.factory = new UUIDFactory();
        }
        return this.factory;
    }

    public BasicConfigurationObjectEditor(boolean createActions) {
        super(createActions);
        if (this.doCreateActions()) {
            this.setDestination(new BasicModificationActionQueue());
        }
    }

    public BasicConfigurationObjectEditor() {
        this(false);
    }

    public ComponentObject undoAction(ActionDefinition action, ComponentObject target) {
        if (action == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0088"));
        }
        ComponentDefn result = null;
        if (action instanceof CreateObject) {
            return result;
        }
        if (action instanceof DestroyObject) {
            Object[] args = action.getArguments();
            result = (ComponentDefn)args[0];
        } else {
            result = (ComponentDefn)target;
        }
        return result;
    }

    DeployedComponent undoAction(ActionDefinition action, DeployedComponent target) {
        if (action == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0088"));
        }
        DeployedComponent result = null;
        if (action instanceof CreateObject) {
            return result;
        }
        if (action instanceof DestroyObject) {
            // empty if block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Configuration undoAction(ActionDefinition action, BaseObject target) {
        if (action == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0088"));
        }
        Configuration result = null;
        if (action instanceof CreateObject) {
            return result;
        }
        if (action instanceof DestroyObject) {
            Object[] args = action.getArguments();
            return (Configuration)args[0];
        }
        result = (Configuration)target;
        if (action instanceof ExchangeObject) {
            ExchangeObject anAction = (ExchangeObject)action;
            if (target instanceof BasicConfiguration) {
                return result;
            }
            if (target instanceof BasicServiceComponentDefn) {
                BasicServiceComponentDefn bc = (BasicServiceComponentDefn)target;
                if (anAction.getAttributeCode().intValue() != ConfigurationModel.Attribute.PROPERTIES.getCode()) return result;
                bc.setProperties((Properties)anAction.getPreviousValue());
                return result;
            }
            if (target instanceof BasicVMComponentDefn) {
                BasicVMComponentDefn dg = (BasicVMComponentDefn)target;
                if (anAction.getAttributeCode().intValue() != ConfigurationModel.Attribute.PROPERTIES.getCode()) return result;
                dg.setProperties((Properties)anAction.getPreviousValue());
                return result;
            }
            if (target instanceof BasicDeployedComponent) {
                return result;
            }
            if (target instanceof BasicHost) {
                return result;
            }
            if (!(target instanceof BasicConfigurationInfo)) return result;
            return result;
        } else {
            if (action instanceof AddObject) {
                return result;
            }
            if (action instanceof RemoveObject) {
                if (target instanceof BasicConfiguration) {
                    return result;
                }
                if (target instanceof BasicServiceComponentDefn) {
                    return result;
                }
                if (target instanceof BasicVMComponentDefn) {
                    return result;
                }
                if (target instanceof BasicDeployedComponent) {
                    return result;
                }
                if (target instanceof BasicHost) {
                    return result;
                }
                if (!(target instanceof BasicConfigurationInfo)) return result;
                return result;
            }
            if (action instanceof ExchangeInt) {
                return result;
            }
            if (action instanceof ExchangeLong) {
                return result;
            }
            if (!(action instanceof ExchangeBoolean)) return result;
            ExchangeBoolean anAction = (ExchangeBoolean)action;
            if (!(target instanceof BasicConfiguration)) return result;
            BasicConfiguration config = (BasicConfiguration)target;
            if (anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.IS_RELEASED.getCode()) {
                config.setIsRelease(anAction.getPreviousValue());
                return result;
            }
            if (anAction.getAttributeCode().intValue() != ConfigurationModel.Attribute.IS_DEPLOYED.getCode()) return result;
            config.setIsDeployed(anAction.getPreviousValue());
        }
        return result;
    }

    @Override
    public Host createHost(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, Configuration.NEXT_STARTUP_ID, Host.HOST_COMPONENT_TYPE_ID, hostName);
        this.createCreationAction(bh.getID(), bh);
        Host newHost = (Host)((Object)bh).clone();
        return newHost;
    }

    @Override
    public Host createHost(ConfigurationID configurationID, String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, configurationID, Host.HOST_COMPONENT_TYPE_ID, hostName);
        this.createCreationAction(bh.getID(), bh);
        Host newHost = (Host)((Object)bh).clone();
        return newHost;
    }

    @Override
    public Host createHost(Configuration configuration, String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, (ConfigurationID)configuration.getID(), Host.HOST_COMPONENT_TYPE_ID, hostName);
        this.createCreationAction(bh.getID(), bh);
        Host newHost = (Host)((Object)bh).clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addHost(newHost);
        return newHost;
    }

    public Host createHost(Configuration configuration, Host original, String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0080", new Object[]{newName}));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, (ConfigurationID)configuration.getID(), Host.HOST_COMPONENT_TYPE_ID, newName);
        this.createCreationAction(bh.getID(), bh);
        this.modifyProperties(bh, original.getProperties(), 1);
        Host newHost = (Host)((Object)bh).clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addHost(newHost);
        return newHost;
    }

    @Override
    public Configuration createConfiguration(String configurationName) {
        if (configurationName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0081"));
        }
        ConfigurationID id = null;
        id = new ConfigurationID(configurationName);
        BasicConfigurationInfo info = new BasicConfigurationInfo(id);
        BasicConfiguration config = new BasicConfiguration(info, Configuration.CONFIG_COMPONENT_TYPE_ID);
        this.createCreationAction(id, config);
        Configuration newConfig = (Configuration)config.clone();
        return newConfig;
    }

    @Override
    public Configuration createConfiguration(String configurationName, Date creationDate, Date lastChangedDate) {
        if (configurationName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0081"));
        }
        ConfigurationID id = null;
        id = new ConfigurationID(configurationName);
        BasicConfigurationInfo info = new BasicConfigurationInfo(id);
        info.setCreationDate(creationDate);
        info.setLastChangedDate(lastChangedDate);
        BasicConfiguration config = new BasicConfiguration(info, Configuration.CONFIG_COMPONENT_TYPE_ID);
        this.createCreationAction(id, config);
        Configuration newConfig = (Configuration)config.clone();
        return newConfig;
    }

    @Override
    public void createConfiguration(ConfigurationID configID, Collection configObjects) {
        if (configID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0082"));
        }
        if (configObjects == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0083"));
        }
        if (configObjects.isEmpty()) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0083"));
        }
        this.createCreationAction(configID, configObjects);
    }

    @Override
    public Configuration createConfiguration(Configuration original, String newName) {
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0081"));
        }
        if (original.getName().equals(newName)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0084", new Object[]{newName}));
        }
        BasicConfiguration config = (BasicConfiguration)this.createConfiguration(newName);
        this.modifyProperties(config, original.getProperties(), 1);
        if (original.getHosts() != null) {
            for (Host h : original.getHosts()) {
                this.createHost(config, h, h.getName());
            }
        }
        for (ServiceComponentDefn sDefn : original.getServiceComponentDefns()) {
            this.createServiceComponentDefn((Configuration)config, sDefn, sDefn.getName());
        }
        for (VMComponentDefn vDefn : original.getVMComponentDefns()) {
            this.createVMComponentDefn(config, vDefn, vDefn.getName());
        }
        for (ConnectorBinding cc : original.getConnectorBindings()) {
            this.createConnectorComponent(config, cc, cc.getName());
        }
        for (AuthenticationProvider provider : original.getAuthenticationProviders()) {
            this.createAuthenticationProviderComponent(config, provider, provider.getName());
        }
        for (ProductServiceConfig psc : original.getPSCs()) {
            this.createProductServiceConfig((Configuration)config, psc, psc.getName());
        }
        ConfigurationID configID = (ConfigurationID)config.getID();
        VMComponentDefnID vmID = null;
        ProductServiceConfigID pscID = null;
        DeployedComponent originalDeployed2 = null;
        ServiceComponentDefn service = null;
        for (DeployedComponent originalDeployed2 : original.getDeployedComponents()) {
            ServiceComponentDefnID serviceID;
            if (originalDeployed2.isDeployedConnector()) {
                serviceID = new ConnectorBindingID(configID, originalDeployed2.getServiceComponentDefnID().getName());
                pscID = new ProductServiceConfigID(configID, originalDeployed2.getProductServiceConfigID().getName());
                vmID = new VMComponentDefnID(configID, originalDeployed2.getHostID(), originalDeployed2.getVMComponentDefnID().getName());
                service = config.getConnectorBinding(serviceID);
                if (service == null) {
                    throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0086", new Object[]{serviceID, originalDeployed2.getName()}));
                }
                this.createDeployedServiceComponent(originalDeployed2.getName(), config, originalDeployed2.getHostID(), vmID, service, pscID);
                continue;
            }
            if (!originalDeployed2.isDeployedService()) continue;
            serviceID = new ServiceComponentDefnID(configID, originalDeployed2.getServiceComponentDefnID().getName());
            pscID = new ProductServiceConfigID(configID, originalDeployed2.getProductServiceConfigID().getName());
            vmID = new VMComponentDefnID(configID, originalDeployed2.getHostID(), originalDeployed2.getVMComponentDefnID().getName());
            service = config.getServiceComponentDefn(serviceID);
            if (service == null) {
                throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0085", new Object[]{serviceID, originalDeployed2.getName()}));
            }
            this.createDeployedServiceComponent(originalDeployed2.getName(), config, originalDeployed2.getHostID(), vmID, service, pscID);
        }
        Configuration newConfig = (Configuration)config.clone();
        return newConfig;
    }

    @Override
    public ComponentType createComponentType(int classTypeCode, String name, ComponentTypeID parentID, ComponentTypeID superID, boolean deployable, boolean monitored) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType type = BasicUtil.createComponentType(classTypeCode, name, parentID, superID, deployable, monitored);
        this.createCreationAction(type.getID(), type);
        ComponentType newType = (ComponentType)type.clone();
        return newType;
    }

    @Override
    public ComponentType createComponentType(ComponentType componentType, String name) {
        if (componentType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        if (name == null) {
            name = componentType.getFullName();
        }
        BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(componentType, BasicComponentType.class);
        BasicComponentType newType = BasicUtil.createComponentType(basicType.getComponentTypeCode(), name, basicType.getParentComponentTypeID(), basicType.getSuperComponentTypeID(), basicType.isDeployable(), basicType.isMonitored());
        newType.setComponentTypeDefinitions(basicType.getComponentTypeDefinitions());
        this.createCreationAction(newType.getID(), newType);
        ComponentType nType = (ComponentType)newType.clone();
        return nType;
    }

    @Override
    public ProductType createProductType(String name, Collection serviceComponentTypes, boolean deployable, boolean monitored) {
        BasicProductType productType = (BasicProductType)this.createProductType(name, deployable, monitored);
        ComponentType serviceComponentType2 = null;
        for (ComponentType serviceComponentType2 : serviceComponentTypes) {
            productType.addServiceTypeID((ComponentTypeID)serviceComponentType2.getID());
        }
        return productType;
    }

    @Override
    public ProductType createProductType(String name, boolean deployable, boolean monitored) {
        BasicProductType productType = (BasicProductType)BasicUtil.createComponentType(3, name, null, ProductType.PRODUCT_SUPER_TYPE_ID, deployable, monitored);
        return productType;
    }

    public BasicComponentDefn createComponentDefn(int defnTypeCode, ConfigurationID configID, ComponentTypeID typeID, String defnName) {
        if (defnName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentDefn defn = BasicUtil.createComponentDefn(defnTypeCode, configID, typeID, defnName);
        return defn;
    }

    @Override
    public ComponentTypeDefn createComponentTypeDefn(ComponentType type, PropertyDefinition propertyDefinition, boolean isEffectiveImmediately) {
        if (type == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        if (propertyDefinition == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ComponentTypeDefn.class.getName()}));
        }
        ComponentTypeDefnID defnID = new ComponentTypeDefnID(propertyDefinition.getName());
        BasicComponentTypeDefn defn = new BasicComponentTypeDefn(defnID, (ComponentTypeID)type.getID(), propertyDefinition, false, isEffectiveImmediately);
        this.createCreationAction(defnID, defn);
        ComponentTypeDefn newDefn = (ComponentTypeDefn)defn.clone();
        BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(type, BasicComponentType.class);
        basicType.addComponentTypeDefinition(newDefn);
        return newDefn;
    }

    @Override
    public ComponentTypeDefn createComponentTypeDefn(ComponentType type, PropertyDefinition propertyDefinition) {
        return this.createComponentTypeDefn(type, propertyDefinition, false);
    }

    @Override
    public ComponentTypeDefn createComponentTypeDefn(ComponentTypeID typeID, PropertyDefinition propertyDefinition, boolean isEffectiveImmediately) {
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (propertyDefinition == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{PropertyDefinition.class.getName()}));
        }
        ComponentTypeDefnID defnID = new ComponentTypeDefnID(propertyDefinition.getName());
        BasicComponentTypeDefn defn = new BasicComponentTypeDefn(defnID, typeID, propertyDefinition, false, isEffectiveImmediately);
        this.createCreationAction(defnID, defn);
        ComponentTypeDefn newDefn = (ComponentTypeDefn)defn.clone();
        return newDefn;
    }

    @Override
    public ComponentTypeDefn createComponentTypeDefn(ComponentTypeID typeID, PropertyDefinition propertyDefinition) {
        return this.createComponentTypeDefn(typeID, propertyDefinition, false);
    }

    @Override
    public PropDefnAllowedValue createPropDefnAllowedValue(ComponentTypeDefn typeDefn, PropertyDefinition propDefn, String value) throws InvalidComponentException {
        int maxCode = Integer.MIN_VALUE;
        for (Object obj : typeDefn.getAllowedValues()) {
            BasicPropDefnAllowedValue defnValue = (BasicPropDefnAllowedValue)obj;
            int allowedCode = defnValue.getAllowedCode();
            if (allowedCode <= maxCode) continue;
            maxCode = allowedCode;
        }
        maxCode = maxCode == Integer.MIN_VALUE ? 1 : ++maxCode;
        StringBuffer sb = new StringBuffer(typeDefn.getFullName());
        sb.append(".");
        sb.append(new Integer(maxCode).toString());
        PropDefnAllowedValueID id = new PropDefnAllowedValueID(sb.toString());
        BasicPropDefnAllowedValue bv = new BasicPropDefnAllowedValue((ComponentTypeDefnID)typeDefn.getID(), typeDefn.getComponentTypeID(), id, value);
        this.createCreationAction(id, bv);
        propDefn.getAllowedValues().add(bv);
        return bv;
    }

    @Override
    public DeployedComponent createDeployedServiceComponent(String name, Configuration configuration, HostID hostId, VMComponentDefnID vmId, ServiceComponentDefn serviceComponentDefn, ProductServiceConfigID pscID) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{DeployedComponent.class.getName()}));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{HostID.class.getName()}));
        }
        if (vmId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{VMComponentDefnID.class.getName()}));
        }
        if (serviceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfigID.class.getName()}));
        }
        ConfigurationID configID = (ConfigurationID)configuration.getID();
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedComponent(name, configID, hostId, vmId, (ServiceComponentDefnID)serviceComponentDefn.getID(), pscID, serviceComponentDefn.getComponentTypeID());
        this.createCreationAction(deployComponent.getID(), deployComponent);
        DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addDeployedComponent(newDefn);
        return newDefn;
    }

    @Override
    public DeployedComponent createDeployedServiceComponent(String name, ConfigurationID configurationID, HostID hostId, VMComponentDefnID vmId, ServiceComponentDefnID serviceComponentDefnID, ProductServiceConfigID pscID, ComponentTypeID serviceComponentTypeID) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{DeployedComponent.class.getName()}));
        }
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{HostID.class.getName()}));
        }
        if (vmId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{VMComponentDefnID.class.getName()}));
        }
        if (serviceComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ServiceComponentDefnID.class.getName()}));
        }
        if (serviceComponentTypeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfigID.class.getName()}));
        }
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedComponent(name, configurationID, hostId, vmId, serviceComponentDefnID, pscID, serviceComponentTypeID);
        this.createCreationAction(deployComponent.getID(), deployComponent);
        DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
        return newDefn;
    }

    public DeployedComponent createDeployedVMComponentx(String name, Configuration configuration, VMComponentDefn vmComponentDefn) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{DeployedComponent.class.getName()}));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (vmComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{VMComponentDefn.class.getName()}));
        }
        ConfigurationID configID = (ConfigurationID)configuration.getID();
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedVMComponent(name, configID, vmComponentDefn.getHostID(), (VMComponentDefnID)vmComponentDefn.getID(), vmComponentDefn.getComponentTypeID());
        this.createCreationAction(deployComponent.getID(), deployComponent);
        DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addDeployedComponent(newDefn);
        return newDefn;
    }

    public DeployedComponent createDeployedVMComponentx(String instanceName, ConfigurationID configurationID, HostID hostId, VMComponentDefnID vmComponentDefnID, ComponentTypeID componentTypeID) {
        if (instanceName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{DeployedComponent.class.getName()}));
        }
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{HostID.class.getName()}));
        }
        if (vmComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{VMComponentDefnID.class.getName()}));
        }
        if (componentTypeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedVMComponent(instanceName, configurationID, hostId, vmComponentDefnID, componentTypeID);
        this.createCreationAction(deployComponent.getID(), deployComponent);
        DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
        return newDefn;
    }

    @Override
    public ServiceComponentDefn createServiceComponentDefn(ConfigurationID configurationID, ComponentTypeID typeID, String componentName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        String routingUUID = typeID.getName().equals("RuntimeMetadataService") ? "RuntimeMetadataService" : this.getObjectIDFactory().create().toString();
        return this.createServiceComponentDefn(configurationID, typeID, componentName, routingUUID);
    }

    @Override
    public ServiceComponentDefn createServiceComponentDefn(ConfigurationID configurationID, ComponentTypeID typeID, String componentName, String routingUUID) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        if (routingUUID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0090", new Object[]{componentName}));
        }
        BasicServiceComponentDefn defn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, typeID, componentName);
        defn.setRoutingUUID(routingUUID);
        this.createCreationAction(defn.getID(), defn);
        ServiceComponentDefn newDefn = (ServiceComponentDefn)defn.clone();
        return newDefn;
    }

    @Override
    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ComponentTypeID typeID, String componentName, ProductServiceConfigID pscID) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfigID.class.getName()}));
        }
        ProductServiceConfig psc = (ProductServiceConfig)configuration.getComponentDefn(pscID);
        Assertion.isNotNull((Object)psc, (String)("PSC " + pscID + " does not exist"));
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicServiceComponentDefn newServiceDefn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, typeID, componentName);
        this.addServiceComponentDefn(psc, (ServiceComponentDefnID)newServiceDefn.getID());
        ServiceComponentDefn newDefn = (ServiceComponentDefn)newServiceDefn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        this.deployServiceDefn(bc, newDefn, pscID);
        return newDefn;
    }

    @Override
    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ComponentTypeID typeID, String componentName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        String routingUUID = componentName.equals("RuntimeMetadataService") ? "RuntimeMetadataService" : this.getObjectIDFactory().create().toString();
        return this.createServiceComponentDefn(configuration, typeID, componentName, routingUUID);
    }

    @Override
    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ComponentTypeID typeID, String componentName, String routingUUID) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        if (routingUUID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0090", new Object[]{componentName}));
        }
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicServiceComponentDefn serviceDefn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, typeID, componentName);
        serviceDefn.setRoutingUUID(routingUUID);
        this.createCreationAction(serviceDefn.getID(), serviceDefn);
        ServiceComponentDefn newDefn = (ServiceComponentDefn)serviceDefn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ServiceComponentDefn originalServiceComponentDefn, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (originalServiceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicServiceComponentDefn serviceDefn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, originalServiceComponentDefn.getComponentTypeID(), newName);
        serviceDefn.setIsQueuedService(originalServiceComponentDefn.isQueuedService());
        if (serviceDefn.getComponentTypeID().getName().equals("RuntimeMetadataService")) {
            serviceDefn.setRoutingUUID("RuntimeMetadataService");
        } else {
            serviceDefn.setRoutingUUID(originalServiceComponentDefn.getRoutingUUID());
        }
        this.createCreationAction(serviceDefn.getID(), serviceDefn);
        this.modifyProperties(serviceDefn, originalServiceComponentDefn.getProperties(), 1);
        ServiceComponentDefn newServiceDefn = (ServiceComponentDefn)serviceDefn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newServiceDefn);
        return newServiceDefn;
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(ConfigurationID configurationID, ComponentTypeID typeID, String descriptorName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ResourceDescriptor.class.getName()}));
        }
        BasicResourceDescriptor defn = (BasicResourceDescriptor)BasicUtil.createComponentDefn(9, configurationID, typeID, descriptorName);
        this.createCreationAction(defn.getID(), defn);
        ResourceDescriptor newDefn = (ResourceDescriptor)defn.clone();
        return newDefn;
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(Configuration configuration, ComponentTypeID typeID, String descriptorName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ResourceDescriptor.class.getName()}));
        }
        ConfigurationID configID = (ConfigurationID)configuration.getID();
        BasicResourceDescriptor defn = (BasicResourceDescriptor)BasicUtil.createComponentDefn(9, configID, typeID, descriptorName);
        this.createCreationAction(defn.getID(), defn);
        ResourceDescriptor newDefn = (ResourceDescriptor)defn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    public ResourceDescriptor createResourceDescriptor(Configuration configuration, ResourceDescriptor original, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ResourceDescriptor.class.getName()}));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ResourceDescriptor.class.getName()}));
        }
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicResourceDescriptor defn = (BasicResourceDescriptor)BasicUtil.createComponentDefn(9, configurationID, original.getComponentTypeID(), newName);
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, original.getProperties(), 1);
        ResourceDescriptor newDefn = (ResourceDescriptor)defn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    @Override
    public SharedResource createSharedResource(ComponentTypeID typeID, String resourceName) {
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{SharedResource.class.getName()}));
        }
        BasicSharedResource defn = (BasicSharedResource)BasicUtil.createComponentObject(10, typeID, resourceName);
        this.createCreationAction(defn.getID(), defn);
        SharedResource newDefn = (SharedResource)defn.clone();
        return newDefn;
    }

    @Override
    public VMComponentDefn createVMComponentDefn(ConfigurationID configurationID, HostID hostID, ComponentTypeID typeID, String componentName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{VMComponentDefn.class.getName()}));
        }
        BasicVMComponentDefn defn = (BasicVMComponentDefn)BasicUtil.createComponentDefn(5, configurationID, hostID, typeID, componentName);
        this.createCreationAction(defn.getID(), defn);
        VMComponentDefn newDefn = (VMComponentDefn)defn.clone();
        return newDefn;
    }

    @Override
    public VMComponentDefn createVMComponentDefn(Configuration configuration, HostID hostID, ComponentTypeID typeID, String componentName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        VMComponentDefn newDefn = this.createVMComponentDefn((ConfigurationID)configuration.getID(), hostID, typeID, componentName);
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    public VMComponentDefn createVMComponentDefn(Configuration configuration, VMComponentDefn original, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{VMComponentDefn.class.getName()}));
        }
        BasicVMComponentDefn defn = (BasicVMComponentDefn)this.createVMComponentDefn((ConfigurationID)configuration.getID(), original.getHostID(), original.getComponentTypeID(), newName);
        Properties props = original.getProperties();
        props.putAll((Map<?, ?>)defn.getEditableProperties());
        this.modifyProperties(defn, props, 1);
        this.createDeployedVMComponentx(defn.getName(), configuration, defn);
        VMComponentDefn newDefn = (VMComponentDefn)defn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    @Override
    public ProductServiceConfig createProductServiceConfig(Configuration configuration, ProductServiceConfig originalPSC, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (originalPSC == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ProductServiceConfig.class.getName()}));
        }
        ProductServiceConfig psc = this.createProductServiceConfig(configuration, (ProductTypeID)originalPSC.getComponentTypeID(), newName);
        this.modifyProperties(psc, originalPSC.getProperties(), 1);
        Iterator iter = originalPSC.getServiceComponentDefnIDs().iterator();
        ServiceComponentDefnID originalServiceDefnID = null;
        while (iter.hasNext()) {
            originalServiceDefnID = (ServiceComponentDefnID)iter.next();
            this.addServiceComponentDefn(psc, originalServiceDefnID);
        }
        ProductServiceConfig newPSC = (ProductServiceConfig)psc.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newPSC);
        return newPSC;
    }

    @Override
    public ProductServiceConfig createProductServiceConfig(ConfigurationID configurationID, ProductTypeID productTypeID, String componentName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        if (productTypeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ProductServiceConfig.class.getName()}));
        }
        BasicProductServiceConfig psc = (BasicProductServiceConfig)BasicUtil.createComponentDefn(6, configurationID, productTypeID, componentName);
        this.createCreationAction(psc.getID(), psc);
        ProductServiceConfig newPSC = (ProductServiceConfig)psc.clone();
        return newPSC;
    }

    @Override
    public ProductServiceConfig createProductServiceConfig(Configuration config, ProductTypeID productTypeID, String name) {
        ProductServiceConfig psc = this.createProductServiceConfig((ConfigurationID)config.getID(), productTypeID, name);
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(config, BasicConfiguration.class);
        bc.addComponentDefn(psc);
        return psc;
    }

    @Override
    public Collection deployProductServiceConfig(Configuration configuration, ProductServiceConfig psc, HostID hostId, VMComponentDefnID vmId) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{HostID.class.getName()}));
        }
        if (vmId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{VMComponentDefnID.class.getName()}));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        ProductServiceConfigID pscID = (ProductServiceConfigID)psc.getID();
        Collection serviceComponentDefnIDs = psc.getServiceComponentDefnIDs();
        HashSet<DeployedComponent> result = new HashSet<DeployedComponent>(serviceComponentDefnIDs.size());
        Iterator iter = serviceComponentDefnIDs.iterator();
        ServiceComponentDefn serviceDefn = null;
        ServiceComponentDefnID serviceDefnID = null;
        while (iter.hasNext()) {
            DeployedComponentID id;
            serviceDefnID = (ServiceComponentDefnID)iter.next();
            serviceDefn = (ServiceComponentDefn)configuration.getComponentDefn(serviceDefnID);
            if (!psc.isServiceEnabled(serviceDefnID) || configuration.getDeployedComponent(id = new DeployedComponentID(serviceDefnID.getName(), (ConfigurationID)configuration.getID(), hostId, vmId, pscID, serviceDefnID)) != null) continue;
            DeployedComponent dc = this.createDeployedServiceComponent(serviceDefnID.getName(), configuration, hostId, vmId, serviceDefn, pscID);
            result.add(dc);
        }
        return result;
    }

    @Override
    public ProductServiceConfig updateProductServiceConfig(Configuration config, ProductServiceConfig psc, Collection newServiceIDList) throws ConfigurationException {
        if (config == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        if (newServiceIDList == null) {
            return psc;
        }
        HashSet set = new HashSet();
        set.addAll(psc.getServiceComponentDefnIDs());
        ProductServiceConfig c = (ProductServiceConfig)psc.clone();
        BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)this.verifyTargetClass(c, BasicProductServiceConfig.class);
        basicPSC.resetServices();
        ProductServiceConfigID pscID = (ProductServiceConfigID)psc.getID();
        if (newServiceIDList.isEmpty()) {
            basicPSC.resetServices();
        } else {
            for (ServiceComponentDefnID sid : newServiceIDList) {
                ServiceComponentDefn sd = (ServiceComponentDefn)config.getComponentDefn(sid);
                if (psc.containsService(sid)) {
                    set.remove(sid);
                } else {
                    this.deployServiceDefn(config, sd, pscID);
                }
                basicPSC.addServiceComponentDefnID(sid);
            }
        }
        for (ServiceComponentDefnID sid : set) {
            ServiceComponentDefn sdefn = (ServiceComponentDefn)config.getComponentDefn(sid);
            this.setEnabled(config, sdefn, psc, false, true);
        }
        this.createExchangeAction(pscID, ConfigurationModel.Attribute.UPDATE_PSC, newServiceIDList, Boolean.TRUE);
        return basicPSC;
    }

    public ComponentType updateComponentType(ComponentType origType, ComponentType replaceType) {
        if (replaceType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        this.createExchangeAction(replaceType.getID(), ConfigurationModel.Attribute.UPDATE_COMPONENT_TYPE, origType, replaceType);
        return replaceType;
    }

    @Override
    public void setRoutingUUID(ServiceComponentDefn serviceComponentDefn, String newRoutingUUID) {
        if (serviceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        String oldUUID = serviceComponentDefn.getRoutingUUID();
        BasicServiceComponentDefn basicService = (BasicServiceComponentDefn)this.verifyTargetClass(serviceComponentDefn, BasicServiceComponentDefn.class);
        basicService.setRoutingUUID(newRoutingUUID);
        this.createExchangeAction(basicService.getID(), ConfigurationModel.Attribute.ROUTING_UUID, oldUUID, newRoutingUUID);
    }

    @Override
    public ProductServiceConfig setEnabled(ServiceComponentDefnID serviceComponentDefnID, ProductServiceConfig psc, boolean enabled) {
        if (serviceComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ServiceComponentDefnID.class.getName()}));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        if (!psc.containsService(serviceComponentDefnID)) {
            return psc;
        }
        boolean oldEnabled = psc.isServiceEnabled(serviceComponentDefnID);
        if (enabled != oldEnabled) {
            BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)this.verifyTargetClass(psc, BasicProductServiceConfig.class);
            basicPSC.setServiceEnabled(serviceComponentDefnID, enabled);
            this.createExchangeAction(basicPSC.getID(), ConfigurationModel.Attribute.IS_ENABLED, serviceComponentDefnID, enabled);
            return basicPSC;
        }
        return psc;
    }

    @Override
    public Collection setEnabled(Configuration configuration, ServiceComponentDefn serviceComponentDefn, ProductServiceConfig psc, boolean enabled, boolean deleteDeployedComps) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (serviceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ServiceComponentDefn.class.getName()}));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        Collection<DeployedComponent> result = null;
        ServiceComponentDefnID svcID = (ServiceComponentDefnID)serviceComponentDefn.getID();
        if (!psc.containsService(svcID)) {
            throw new ConfigurationException(CommonPlugin.Util.getString("ERR.003.001.0091", new Object[]{svcID, psc.getName()}));
        }
        boolean oldEnabled = psc.isServiceEnabled(svcID);
        if (enabled != oldEnabled) {
            psc = this.setEnabled(svcID, psc, enabled);
            BasicConfiguration targetConfig = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
            Collection deps = targetConfig.getDeployedComponents(svcID, (ProductServiceConfigID)psc.getID());
            if (!enabled && deleteDeployedComps) {
                if (!deps.isEmpty()) {
                    result = new ArrayList(deps.size());
                    for (DeployedComponent deployedService : deps) {
                        DeployedComponentID deployedServiceID = (DeployedComponentID)deployedService.getID();
                        this.createDestroyAction(deployedServiceID, deployedService);
                        targetConfig.removeComponentObject(deployedServiceID);
                        DeployedComponent ds = targetConfig.getDeployedComponent(deployedServiceID);
                        if (ds != null) {
                            throw new ConfigurationException("Deployed Component " + deployedServiceID + " was not removed");
                        }
                        DeployedComponent newService = (DeployedComponent)deployedService.clone();
                        result.add(newService);
                    }
                }
            } else if (enabled) {
                ProductServiceConfigID pscID = (ProductServiceConfigID)psc.getID();
                result = this.deployServiceDefn(targetConfig, serviceComponentDefn, pscID);
            }
            targetConfig.addComponentDefn(psc);
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public ProductServiceConfig addServiceComponentDefn(Configuration configuration, ProductServiceConfig psc, ServiceComponentDefnID serviceComponentDefnID) {
        return this.addServiceComponentDefn(psc, serviceComponentDefnID);
    }

    @Override
    public ProductServiceConfig addServiceComponentDefn(ProductServiceConfig psc, ServiceComponentDefnID serviceComponentDefnID) {
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        if (serviceComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ServiceComponentDefnID.class.getName()}));
        }
        BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)this.verifyTargetClass(psc, BasicProductServiceConfig.class);
        basicPSC.addServiceComponentDefnID(serviceComponentDefnID);
        this.createExchangeAction(serviceComponentDefnID, ConfigurationModel.Attribute.PSC_NAME, null, basicPSC.getID());
        ProductServiceConfig newDefn = (ProductServiceConfig)basicPSC.clone();
        return newDefn;
    }

    @Override
    public ProductType addServiceComponentType(ProductType productType, ComponentType serviceComponentType) {
        BasicProductType basicProdType = (BasicProductType)productType;
        ComponentTypeID productTypeID = (ComponentTypeID)basicProdType.getID();
        this.setParentComponentTypeID(serviceComponentType, productTypeID);
        basicProdType.addServiceTypeID((ComponentTypeID)serviceComponentType.getID());
        return basicProdType;
    }

    @Override
    public ProductType removeServiceComponentType(ProductType productType, ComponentType serviceComponentType) {
        BasicProductType basicProdType = (BasicProductType)productType;
        ComponentTypeID productTypeID = (ComponentTypeID)basicProdType.getID();
        this.setParentComponentTypeID(serviceComponentType, productTypeID);
        basicProdType.removeServiceTypeID((ComponentTypeID)serviceComponentType.getID());
        return basicProdType;
    }

    @Override
    public Configuration setLogConfiguration(Configuration t, LogConfiguration logConfiguration) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t, BasicConfiguration.class);
        try {
            LogConfiguration oldLogConfig = t.getLogConfiguration();
            Set discardedContexts = oldLogConfig.getDiscardedContexts();
            Properties props = BasicLogConfiguration.getLogConfigurationProperties(logConfiguration);
            String contextValue = props.getProperty("metamatrix.log.contexts");
            if (contextValue == null && !discardedContexts.isEmpty()) {
                this.removeProperty(t, "metamatrix.log.contexts");
            } else if (contextValue != null && discardedContexts.isEmpty()) {
                this.addProperty(t, "metamatrix.log.contexts", contextValue);
            } else if (contextValue != null && !discardedContexts.isEmpty()) {
                this.setProperty(t, "metamatrix.log.contexts", contextValue);
            }
            this.setProperty(t, "metamatrix.log", props.getProperty("metamatrix.log"));
        }
        catch (LogConfigurationException e) {
            LogManager.logError("CONFIG", (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.003.001.0001"));
        }
        return target;
    }

    @Override
    public ComponentObject addProperty(ComponentObject t, String name, String value) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentObject.class.getName()}));
        }
        if (name == null || value == null) {
            return t;
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t, BasicComponentObject.class);
        this.createAddNamedAction(target.getID(), ConfigurationModel.Attribute.PROPERTY, name, value);
        target.addProperty(name, value);
        return target;
    }

    @Override
    public ComponentObject setProperty(ComponentObject t, String name, String value) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentObject.class.getName()}));
        }
        if (name == null || value == null) {
            return t;
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t, BasicComponentObject.class);
        String oldValue = target.getProperty(name);
        this.createExchangeNamedAction(target.getID(), ConfigurationModel.Attribute.PROPERTY, name, oldValue, value);
        target.removeProperty(name);
        target.addProperty(name, value);
        return target;
    }

    @Override
    public ComponentObject removeProperty(ComponentObject t, String name) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentObject.class.getName()}));
        }
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0092"));
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t, BasicComponentObject.class);
        String value = target.getProperty(name);
        this.createRemoveNamedAction(target.getID(), ConfigurationModel.Attribute.PROPERTY, name, value);
        target.removeProperty(name);
        return target;
    }

    @Override
    public ComponentTypeDefn modifyComponentTypeDefn(ComponentTypeDefn original, ComponentTypeDefn updated) {
        if (updated == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeDefn.class.getName()}));
        }
        BasicComponentTypeDefn target = (BasicComponentTypeDefn)this.verifyTargetClass(updated, BasicComponentTypeDefn.class);
        this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.COMPONENT_TYPE_DEFN, original, updated);
        return target;
    }

    @Override
    public ComponentObject modifyProperties(ComponentObject t, Properties props, int command) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentObject.class.getName()}));
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t, BasicComponentObject.class);
        super.verifyCommand(command);
        Properties newProps = null;
        switch (command) {
            case 1: {
                newProps = new Properties();
                newProps.putAll((Map<?, ?>)target.getEditableProperties());
                newProps.putAll((Map<?, ?>)props);
                this.createAddAction(target.getID(), ConfigurationModel.Attribute.PROPERTIES, props);
                target.addProperties(newProps);
                break;
            }
            case 2: {
                newProps = new Properties();
                newProps.putAll((Map<?, ?>)target.getEditableProperties());
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    newProps.remove(iter.next());
                }
                this.createRemoveAction(target.getID(), ConfigurationModel.Attribute.PROPERTIES, props);
                target.setProperties(newProps);
                break;
            }
            case 0: {
                this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.PROPERTIES, target.getEditableProperties(), props);
                target.setProperties(props);
            }
        }
        return target;
    }

    @Override
    public Configuration setIsReleased(Configuration t, boolean newValue) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t, BasicConfiguration.class);
        BasicConfigurationInfo info = (BasicConfigurationInfo)target.getInfo();
        boolean oldValue = info.isReleased();
        if (oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_RELEASED, oldValue, newValue);
            info.setIsReleased(newValue);
            target.setInfo(info);
        }
        return target;
    }

    @Override
    public Configuration setIsDeployed(Configuration t, boolean newValue) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t, BasicConfiguration.class);
        BasicConfigurationInfo info = (BasicConfigurationInfo)target.getInfo();
        boolean oldValue = info.isDeployed();
        if (oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_DEPLOYED, oldValue, newValue);
            info.setIsDeployed(newValue);
            target.setInfo(info);
        }
        return target;
    }

    @Override
    public ComponentType setIsDeployable(ComponentType t, boolean newValue) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t, BasicComponentType.class);
        boolean oldValue = target.isDeployable();
        if (!oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_DEPLOYABLE, oldValue, newValue);
            target.setIsDeployable(newValue);
        }
        return target;
    }

    @Override
    public ComponentType setIsDeprecated(ComponentType t, boolean newValue) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t, BasicComponentType.class);
        boolean oldValue = target.isDeprecated();
        if (!oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_DEPRECATED, oldValue, newValue);
            target.setIsDeprecated(newValue);
        }
        return target;
    }

    @Override
    public ComponentType setIsMonitored(ComponentType t, boolean newValue) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t, BasicComponentType.class);
        boolean oldValue = target.isMonitored();
        if (!oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_MONITORED, oldValue, newValue);
            target.setIsMonitored(newValue);
        }
        return target;
    }

    @Override
    public ComponentObject setComponentType(ComponentObject t, ComponentTypeID componentType) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentObject.class.getName()}));
        }
        if (componentType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t, BasicComponentObject.class);
        ComponentTypeID oldValue = target.getComponentTypeID();
        if (!oldValue.equals(componentType)) {
            this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.COMPONENT_TYPEID, oldValue, componentType);
            target.setComponentTypeID(componentType);
        }
        return target;
    }

    @Override
    public ComponentType setParentComponentTypeID(ComponentType t, ComponentTypeID parentID) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t, BasicComponentType.class);
        ComponentTypeID oldValue = target.getParentComponentTypeID();
        if (parentID == null && oldValue != null || oldValue == null || !oldValue.equals(parentID)) {
            this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.PARENT_COMPONENT_TYPEID, oldValue, parentID);
            target.setParentComponentTypeID(parentID);
        }
        return target;
    }

    @Override
    public ComponentType setSuperComponentTypeID(ComponentType t, ComponentTypeID superID) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t, BasicComponentType.class);
        ComponentTypeID oldValue = target.getParentComponentTypeID();
        if (superID == null && oldValue != null || !oldValue.equals(superID)) {
            this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.SUPER_COMPONENT_TYPEID, oldValue, superID);
            target.setSuperComponentTypeID(superID);
        }
        return target;
    }

    @Override
    public ComponentType setLastChangedHistory(ComponentType type, String lastChangedBy, String lastChangedDate) {
        return ConfigurationObjectEditorHelper.setLastChangedHistory(type, lastChangedBy, lastChangedDate);
    }

    @Override
    public ComponentType setCreationChangedHistory(ComponentType type, String createdBy, String creationDate) {
        return ConfigurationObjectEditorHelper.setCreationChangedHistory(type, createdBy, creationDate);
    }

    @Override
    public ComponentObject setLastChangedHistory(ComponentObject defn, String lastChangedBy, String lastChangedDate) {
        return ConfigurationObjectEditorHelper.setLastChangedHistory(defn, lastChangedBy, lastChangedDate);
    }

    @Override
    public ComponentObject setCreationChangedHistory(ComponentObject defn, String createdBy, String creationDate) {
        return ConfigurationObjectEditorHelper.setCreationChangedHistory(defn, createdBy, creationDate);
    }

    @Override
    public void delete(Host target) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Host.class.getName()}));
        }
        this.createDestroyAction(target.getID(), target);
    }

    @Override
    public void delete(ComponentTypeDefn target, ComponentType type) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeDefn.class.getName()}));
        }
        if (type == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(type, BasicComponentType.class);
        this.createDestroyAction(target.getID(), target);
        basicType.removeComponentTypeDefinition(target);
    }

    public void delete(PropDefnAllowedValue target) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{PropDefnAllowedValue.class.getName()}));
        }
        this.createDestroyAction(target.getID(), target);
    }

    @Override
    public void delete(ComponentType target) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(target, BasicComponentType.class);
        this.createDestroyAction(basicType.getID(), basicType);
    }

    @Override
    public void delete(ConfigurationID targetID) throws ConfigurationException {
        if (targetID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConfigurationID.class.getName()}));
        }
        this.createDestroyAction(targetID, targetID);
    }

    @Override
    public void delete(Configuration target) throws ConfigurationException {
        this.delete(target, false);
    }

    @Override
    public void delete(Configuration target, boolean deleteDependencies) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        BasicConfiguration basicConfig = (BasicConfiguration)this.verifyTargetClass(target, BasicConfiguration.class);
        this.delete((ConfigurationID)basicConfig.getID());
    }

    @Override
    public SharedResource delete(SharedResource target) throws ConfigurationException {
        this.createDestroyAction(target.getID(), target);
        return target;
    }

    @Override
    public Configuration delete(ComponentObject target, Configuration configuration) throws ConfigurationException {
        return this.delete(target, configuration, false);
    }

    @Override
    public Configuration delete(ComponentObject target, Configuration configuration, boolean deleteDependencies) throws ConfigurationException {
        if (target instanceof Configuration) {
            throw new UnsupportedOperationException("Cannot call method delete(ComponentObject, Configuration) to delete a configuration, call delete(Configuration).");
        }
        Configuration config = ConfigurationObjectEditorHelper.delete((ComponentObjectID)target.getID(), configuration);
        this.createDestroyAction(target.getID(), target);
        return config;
    }

    @Override
    public ProductServiceConfig renamePSC(ProductServiceConfig psc, String name) throws ConfigurationException {
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        BasicProductServiceConfig target = (BasicProductServiceConfig)this.verifyTargetClass(psc, BasicProductServiceConfig.class);
        ConfigurationID configID = target.getConfigurationID();
        target = (BasicProductServiceConfig)BasicUtil.createComponentDefn(6, configID, psc.getComponentTypeID(), name);
        this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.NAME, target.getName(), name);
        return target;
    }

    @Override
    public VMComponentDefn renameVM(VMComponentDefn vm, String name) throws ConfigurationException {
        if (vm == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{VMComponentDefn.class.getName()}));
        }
        BasicVMComponentDefn target = (BasicVMComponentDefn)this.verifyTargetClass(vm, BasicVMComponentDefn.class);
        ConfigurationID configID = target.getConfigurationID();
        target = (BasicVMComponentDefn)BasicUtil.createComponentDefn(5, configID, target.getComponentTypeID(), name);
        this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.NAME, target.getName(), name);
        return target;
    }

    public boolean isDeployed(ServiceComponentDefnID defnID, Configuration config) {
        for (DeployedComponent comp : config.getDeployedComponents()) {
            ServiceComponentDefnID depDefnID = comp.getServiceComponentDefnID();
            if (!defnID.equals(depDefnID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBootStrapConfiguration(ConfigurationID configurationID) throws ConfigurationException {
        this.createExchangeAction(configurationID, ConfigurationModel.Attribute.NEXT_STARTUP_CONFIGURATION, configurationID, configurationID);
    }

    public void setStartupConfiguration(ConfigurationID configurationID) throws ConfigurationException {
        this.createExchangeAction(configurationID, ConfigurationModel.Attribute.STARTUP_CONFIGURATION, configurationID, configurationID);
    }

    @Override
    public void setNextStartupConfiguration(ConfigurationID configurationID) throws ConfigurationException {
        this.createExchangeAction(configurationID, ConfigurationModel.Attribute.NEXT_STARTUP_CONFIGURATION, configurationID, configurationID);
    }

    @Override
    public ComponentType setComponentTypeDefinitions(ComponentType t, Collection defns) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentType.class.getName()}));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t, BasicComponentType.class);
        target.setComponentTypeDefinitions(defns);
        return target;
    }

    @Override
    public ComponentTypeDefn setPropertyDefinition(ComponentTypeDefn t, PropertyDefinition defn) {
        if (t == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeDefn.class.getName()}));
        }
        BasicComponentTypeDefn target = (BasicComponentTypeDefn)this.verifyTargetClass(t, BasicComponentTypeDefn.class);
        target.setPropertyDefinition(defn);
        return target;
    }

    public Configuration setConfigurationComponentDefns(Configuration t, Collection componentDefns) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t, BasicConfiguration.class);
        HashMap<BaseID, ComponentDefn> defns = new HashMap<BaseID, ComponentDefn>(componentDefns.size());
        for (ComponentDefn cd : componentDefns) {
            defns.put(cd.getID(), cd);
        }
        target.setComponentDefns(defns);
        return target;
    }

    public Configuration setConfigurationDeployedComponents(Configuration t, Collection deployedComponents) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t, BasicConfiguration.class);
        HashMap<BaseID, DeployedComponent> dcs = new HashMap<BaseID, DeployedComponent>(deployedComponents.size());
        for (DeployedComponent dc : deployedComponents) {
            dcs.put(dc.getID(), dc);
        }
        target.setDeployedComponents(dcs);
        return target;
    }

    public Configuration setConfigurationHostComponents(Configuration t, Collection hostComponents) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t, BasicConfiguration.class);
        HashMap<BaseID, Host> hosts = new HashMap<BaseID, Host>(hostComponents.size());
        for (Host host : hostComponents) {
            hosts.put(host.getID(), host);
        }
        target.setHosts(hosts);
        return target;
    }

    @Override
    public Properties getEditableProperties(ComponentObject t) {
        BasicComponentObject bco = (BasicComponentObject)this.verifyTargetClass(t, BasicComponentObject.class);
        return bco.getEditableProperties();
    }

    public Object assignConfigurationID(Object t, ConfigurationID configurationID) {
        if (t instanceof ComponentDefn) {
            BasicComponentDefn bcd = (BasicComponentDefn)this.verifyTargetClass(t, BasicComponentDefn.class);
            bcd.setConfigurationID(configurationID);
        } else if (t instanceof DeployedComponent) {
            BasicDeployedComponent bdc = (BasicDeployedComponent)this.verifyTargetClass(t, BasicDeployedComponent.class);
            bdc.setConfigurationID(configurationID);
        }
        return t;
    }

    @Override
    public ConnectorBinding createConnectorComponent(ConfigurationID configurationID, ComponentTypeID typeID, String descriptorName, String routingUUID) {
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ConnectorBinding.class.getName()}));
        }
        BasicConnectorBinding defn = (BasicConnectorBinding)BasicUtil.createComponentDefn(2, configurationID, typeID, descriptorName);
        this.createCreationAction(defn.getID(), defn);
        if (routingUUID == null) {
            routingUUID = this.getObjectIDFactory().create().toString();
        }
        defn.setRoutingUUID(routingUUID);
        ConnectorBinding newDefn = (ConnectorBinding)defn.clone();
        return newDefn;
    }

    @Override
    public ConnectorBinding createConnectorComponent(Configuration configuration, ComponentTypeID typeID, String componentName, ProductServiceConfigID pscID) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfigID.class.getName()}));
        }
        ProductServiceConfig psc = (ProductServiceConfig)configuration.getComponentDefn(pscID);
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ProductServiceConfig.class.getName()}));
        }
        BasicConnectorBinding newServiceDefn = (BasicConnectorBinding)this.createConnectorComponent((ConfigurationID)configuration.getID(), typeID, componentName, null);
        this.addServiceComponentDefn(psc, (ServiceComponentDefnID)newServiceDefn.getID());
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newServiceDefn);
        this.deployServiceDefn(bc, newServiceDefn, pscID);
        return newServiceDefn;
    }

    @Override
    public ConnectorBinding createConnectorComponent(ConfigurationID configurationID, ConnectorBinding original, String newName, String routingUUID) {
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConnectorBinding.class.getName()}));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ConnectorBinding.class.getName()}));
        }
        BasicConnectorBinding defn = (BasicConnectorBinding)BasicUtil.createComponentDefn(2, configurationID, original.getComponentTypeID(), newName);
        if (routingUUID == null) {
            routingUUID = this.getObjectIDFactory().create().toString();
        }
        defn.setRoutingUUID(routingUUID);
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, original.getProperties(), 1);
        ConnectorBinding newDefn = (ConnectorBinding)defn.clone();
        return newDefn;
    }

    public ConnectorBinding createConnectorComponent(Configuration configuration, ConnectorBinding originalConnector, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (originalConnector == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ConnectorBinding.class.getName()}));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{ConnectorBinding.class.getName()}));
        }
        BasicConnectorBinding defn = (BasicConnectorBinding)BasicUtil.createComponentDefn(2, (ConfigurationID)configuration.getID(), originalConnector.getComponentTypeID(), newName);
        defn.setRoutingUUID(originalConnector.getRoutingUUID());
        defn.setIsQueuedService(originalConnector.isQueuedService());
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, originalConnector.getProperties(), 1);
        ConnectorBinding newDefn = (ConnectorBinding)defn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    @Override
    public void addAuthenticationProvider(Configuration configuration, AuthenticationProvider provider) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (provider == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{AuthenticationProvider.class.getName()}));
        }
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(provider);
    }

    @Override
    public AuthenticationProvider createAuthenticationProviderComponent(Configuration configuration, AuthenticationProvider originalProvider, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{Configuration.class.getName()}));
        }
        if (originalProvider == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{AuthenticationProvider.class.getName()}));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{AuthenticationProvider.class.getName()}));
        }
        BasicAuthenticationProvider defn = (BasicAuthenticationProvider)BasicUtil.createComponentDefn(11, (ConfigurationID)configuration.getID(), originalProvider.getComponentTypeID(), newName);
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, originalProvider.getProperties(), 1);
        AuthenticationProvider newDefn = (AuthenticationProvider)defn.clone();
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    @Override
    public AuthenticationProvider createAuthenticationProviderComponent(ConfigurationID configurationID, ComponentTypeID typeID, String descriptorName) {
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{ComponentTypeID.class.getName()}));
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{AuthenticationProvider.class.getName()}));
        }
        BasicAuthenticationProvider defn = (BasicAuthenticationProvider)BasicUtil.createComponentDefn(11, configurationID, typeID, descriptorName);
        this.createCreationAction(defn.getID(), defn);
        AuthenticationProvider newDefn = (AuthenticationProvider)defn.clone();
        return newDefn;
    }

    @Override
    public AuthenticationProvider createAuthenticationProviderComponent(ConfigurationID configurationID, AuthenticationProvider original, String newName) {
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", new Object[]{AuthenticationProvider.class.getName()}));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", new Object[]{AuthenticationProvider.class.getName()}));
        }
        BasicAuthenticationProvider defn = (BasicAuthenticationProvider)BasicUtil.createComponentDefn(11, configurationID, original.getComponentTypeID(), newName);
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, original.getProperties(), 1);
        AuthenticationProvider newDefn = (AuthenticationProvider)defn.clone();
        return newDefn;
    }

    @Override
    public Collection deployServiceDefn(Configuration configuration, ServiceComponentDefn serviceComponentDefn, ProductServiceConfigID pscID) {
        ArrayList<DeployedComponent> result = null;
        BasicServiceComponentDefn basicService = (BasicServiceComponentDefn)this.verifyTargetClass(serviceComponentDefn, BasicServiceComponentDefn.class);
        BasicConfiguration targetConfig = (BasicConfiguration)this.verifyTargetClass(configuration, BasicConfiguration.class);
        DeployedComponent aDeployedComponent2 = null;
        ProductServiceConfigID aPscID = null;
        HostID hostID = null;
        VMComponentDefnID vmID = null;
        ConfigurationID configID = (ConfigurationID)targetConfig.getID();
        ServiceComponentDefnID serviceDefnID = (ServiceComponentDefnID)basicService.getID();
        ProductServiceConfig psc = targetConfig.getPSC(pscID);
        HashSet<DeployedComponentID> deployedIDs = new HashSet<DeployedComponentID>();
        for (DeployedComponent aDeployedComponent2 : targetConfig.getDeployedComponents()) {
            aPscID = aDeployedComponent2.getProductServiceConfigID();
            if (aPscID == null || !aPscID.equals(pscID)) continue;
            hostID = aDeployedComponent2.getHostID();
            vmID = aDeployedComponent2.getVMComponentDefnID();
            DeployedComponentID id = new DeployedComponentID(serviceDefnID.getName(), configID, hostID, vmID, pscID, serviceDefnID);
            if (deployedIDs.contains(id)) continue;
            deployedIDs.add(id);
            DeployedComponent deployComponent = this.createDeployedServiceComponent(serviceDefnID.getName(), configuration, hostID, vmID, basicService, aPscID);
            if (result == null) {
                result = new ArrayList<DeployedComponent>();
            }
            result.add(deployComponent);
            if (psc.getServiceComponentDefnIDs() == null) {
                this.addServiceComponentDefn(psc, serviceDefnID);
                continue;
            }
            if (psc.getServiceComponentDefnIDs().contains(serviceDefnID)) continue;
            this.addServiceComponentDefn(psc, serviceDefnID);
        }
        targetConfig.addComponentDefn(basicService);
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }
}

