/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class BasicConnectorBindingType
extends BasicComponentType
implements ConnectorBindingType {
    public static final long serialVersionUID = 1592753260156781311L;
    private static final String XA_CONNECTOR = "XA Connector";

    public BasicConnectorBindingType(ComponentTypeID id, ComponentTypeID parentID, ComponentTypeID superID, boolean deployable, boolean deprecated, boolean monitored) {
        super(id, parentID, superID, deployable, deprecated, monitored);
        if (parentID == null) {
            Assertion.isNotNull((Object)parentID, (String)CommonPlugin.Util.getString("ERR.003.001.0075", new Object[]{id}));
        }
        if (superID == null) {
            Assertion.isNotNull((Object)superID, (String)CommonPlugin.Util.getString("ERR.003.001.0076", new Object[]{id}));
        }
    }

    BasicConnectorBindingType(BasicConnectorBindingType copy) {
        super(copy);
    }

    @Override
    public boolean isOfConnectorProductType() {
        return this.getParentComponentTypeID().getFullName().equalsIgnoreCase("Connectors");
    }

    @Override
    public boolean isOfTypeConnector() {
        return true;
    }

    @Override
    public boolean isOfTypeXAConnector() {
        return this.getFullName().endsWith(XA_CONNECTOR);
    }

    @Override
    public synchronized Object clone() {
        BasicConnectorBindingType result = null;
        result = new BasicConnectorBindingType(this);
        Collection defns = this.getComponentTypeDefinitions();
        result.setComponentTypeDefinitions(defns);
        return result;
    }

    @Override
    public String[] getExtensionModules() {
        ArrayList<String> modules = new ArrayList<String>();
        String classPath = this.getDefaultValue("ConnectorClassPath");
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath, ";");
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                int idx = path.indexOf("extensionjar");
                if (idx == -1) continue;
                String jarFile = path.substring(idx + "extensionjar".length() + 1);
                modules.add(jarFile);
            }
        }
        return modules.toArray(new String[modules.size()]);
    }
}

