/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicServiceComponentDefn;
import com.metamatrix.common.namedobject.BaseID;
import java.io.Serializable;

public class BasicDeployedComponent
extends BasicComponentObject
implements DeployedComponent,
Serializable {
    private ConfigurationID configurationID;
    private ServiceComponentDefnID componentID;
    private HostID hostID;
    private VMComponentDefnID vmComponentID;
    private ProductServiceConfigID pscID;

    public BasicDeployedComponent(DeployedComponentID deployedId, ConfigurationID configId, HostID hostId, VMComponentDefnID vmId, ComponentTypeID deployedTypeID) {
        this(deployedId, configId, hostId, vmId, null, null, deployedTypeID);
    }

    public BasicDeployedComponent(DeployedComponentID deployedId, ConfigurationID configId, HostID hostId, VMComponentDefnID vmId, ServiceComponentDefnID serviceId, ProductServiceConfigID pscID, ComponentTypeID deployedTypeID) {
        super(deployedId, deployedTypeID);
        this.configurationID = configId;
        this.hostID = hostId;
        this.vmComponentID = vmId;
        if (serviceId != null) {
            this.componentID = serviceId;
        }
        if (pscID != null) {
            this.pscID = pscID;
        }
    }

    public BasicDeployedComponent(BasicDeployedComponent deployedComponent) {
        super(deployedComponent.getID(), deployedComponent.getComponentTypeID());
        this.configurationID = deployedComponent.getConfigurationID();
        this.hostID = deployedComponent.getHostID();
        this.vmComponentID = deployedComponent.getVMComponentDefnID();
        if (deployedComponent.getServiceComponentDefnID() != null) {
            this.componentID = deployedComponent.getServiceComponentDefnID();
            this.pscID = deployedComponent.getProductServiceConfigID();
        }
    }

    @Override
    public boolean isDeployedService() {
        if (this.componentID == null) {
            return false;
        }
        return !(this.componentID instanceof ConnectorBindingID);
    }

    @Override
    public boolean isDeployedConnector() {
        return !this.isDeployedService() && this.componentID instanceof ConnectorBindingID;
    }

    @Override
    public ProductServiceConfigID getProductServiceConfigID() {
        return this.pscID;
    }

    @Override
    public ServiceComponentDefnID getServiceComponentDefnID() {
        return this.componentID;
    }

    @Override
    public ConfigurationID getConfigurationID() {
        return this.configurationID;
    }

    @Override
    public VMComponentDefnID getVMComponentDefnID() {
        return this.vmComponentID;
    }

    @Override
    public HostID getHostID() {
        return this.hostID;
    }

    @Override
    public ComponentDefnID getDeployedComponentDefnID() {
        if (this.componentID != null) {
            return this.componentID;
        }
        return this.vmComponentID;
    }

    @Override
    public ComponentDefn getDeployedComponentDefn(Configuration configuration) {
        return configuration.getComponentDefn(this.getDeployedComponentDefnID());
    }

    @Override
    public boolean isDependentUpon(BaseID componentObjectId) {
        if (componentObjectId instanceof ConfigurationID) {
            return this.configurationID.equals(componentObjectId);
        }
        if (componentObjectId instanceof HostID) {
            return this.hostID.equals(componentObjectId);
        }
        if (componentObjectId instanceof VMComponentDefnID) {
            return this.vmComponentID.equals(componentObjectId);
        }
        if (componentObjectId instanceof ServiceComponentDefnID) {
            if (this.componentID == null) {
                return false;
            }
            return this.componentID.equals(componentObjectId);
        }
        if (componentObjectId instanceof ProductServiceConfigID) {
            if (this.pscID == null) {
                return false;
            }
            return this.pscID.equals(componentObjectId);
        }
        return false;
    }

    void setConfigurationID(ConfigurationID configID) {
        this.configurationID = configID;
    }

    @Override
    public synchronized Object clone() {
        return new BasicDeployedComponent(this);
    }

    @Override
    public String toString() {
        return BasicServiceComponentDefn.getDisplayableName(this.getName());
    }
}

