/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.util.Assertion;
import java.util.Collection;
import java.util.Properties;

public class ComponentCryptoUtil {
    public static boolean checkPropertiesDecryptable(ComponentDefn defn, Collection componentTypeDefns) {
        boolean result = true;
        try {
            ComponentCryptoUtil.decryptProperties(defn, componentTypeDefns);
        }
        catch (CryptoException e) {
            result = false;
        }
        return result;
    }

    public static boolean checkPropertiesDecryptable(Properties props, Collection maskedPropertyNames) {
        if (maskedPropertyNames != null) {
            for (String maskedPropName : maskedPropertyNames) {
                String maskedValue = null;
                if (props != null) {
                    maskedValue = props.getProperty(maskedPropName);
                }
                if (maskedValue == null || CryptoUtil.canDecrypt((String)maskedValue)) continue;
                return false;
            }
        }
        return true;
    }

    public static Properties getDecryptedProperties(ComponentDefn defn) throws ConfigurationException, CryptoException {
        ConfigurationModelContainer configModel = CurrentConfiguration.getInstance().getConfigurationModel();
        ComponentType componentType = configModel.getComponentType(defn.getComponentTypeID().getName());
        Assertion.isNotNull((Object)componentType, (String)"unknown component type");
        Collection compTypeDefns = componentType.getComponentTypeDefinitions();
        return ComponentCryptoUtil.decryptProperties(defn, compTypeDefns);
    }

    private static Properties decryptProperties(ComponentDefn defn, Collection compTypeDefns) throws CryptoException {
        Properties result = PropertiesUtils.clone((Properties)defn.getProperties(), (boolean)false);
        for (ComponentTypeDefn typeDefn : compTypeDefns) {
            PropertyDefinition propDefn = typeDefn.getPropertyDefinition();
            String propName = propDefn.getName();
            String propValue = result.getProperty(propName);
            if (propValue == null || !propDefn.isMasked()) continue;
            propValue = CryptoUtil.getDecryptor().decrypt(propValue);
            result.setProperty(propName, propValue);
        }
        return result;
    }
}

