/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.util.MetaMatrixProductNames;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;

public class ConfigurationModelContainerAdapter {
    public ConfigurationModelContainer readConfigurationModel(String file, ConfigurationID configID) throws ConfigurationException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ConfigurationModelContainer configurationModelContainer = this.readConfigurationModel(fis, configID);
            return configurationModelContainer;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception ioe) {
            throw new ConfigurationException(ioe, "ERR.003.001.0099", CommonPlugin.Util.getString("ERR.003.001.0099", new Object[]{configID.getFullName()}));
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public ConfigurationModelContainer readConfigurationModel(InputStream inputStream, ConfigurationID configID) throws ConfigurationException {
        Collection configObjects = null;
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
        try {
            XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
            configObjects = io.importConfigurationObjects(inputStream, editor, configID.getFullName());
            ConfigurationModelContainerImpl configModel = new ConfigurationModelContainerImpl();
            configModel.setConfigurationObjects(configObjects);
            return configModel;
        }
        catch (Exception ioe) {
            throw new ConfigurationException(ioe, "ERR.003.001.0099", CommonPlugin.Util.getString("ERR.003.001.0099", new Object[]{configID.getFullName()}));
        }
    }

    public void writeConfigurationModel(String file, ConfigurationModelContainer model, String principalName) throws ConfigurationException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.writeConfigurationModel(fos, model, principalName);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception ioe) {
            throw new ConfigurationException(ioe, "ERR.003.001.0100", CommonPlugin.Util.getString("ERR.003.001.0100", new Object[]{model.getConfiguration().getID()}));
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void writeConfigurationModel(OutputStream out, ConfigurationModelContainer model, String principalName) throws ConfigurationException {
        try {
            XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
            Properties props = new Properties();
            props.put("ApplicationCreatedBy", "Configuration Import_Export Utility");
            props.put("ApplicationVersion", MetaMatrixProductNames.VERSION_NUMBER);
            props.put("UserCreatedBy", principalName);
            io.exportConfiguration(out, model.getAllObjects(), props);
        }
        catch (Exception ioe) {
            throw new ConfigurationException(ioe, "ERR.003.001.0100", CommonPlugin.Util.getString("ERR.003.001.0100", new Object[]{model.getConfiguration().getID()}));
        }
    }

    public void validateModel(ConfigurationModelContainer model) throws ConfigObjectsNotResolvableException {
        XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
        io.resolveConfigurationObjects(model.getAllObjects());
    }
}

