/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.SharedResourceID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.model.BasicConfiguration;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicProductType;
import com.metamatrix.common.config.model.ConfigurationObjectEditorHelper;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ConfigurationModelContainerImpl
implements ConfigurationModelContainer,
Serializable {
    private BasicConfiguration configuration = null;
    private transient ConfigurationObjectEditorHelper editor = null;
    private Map compTypes = Collections.synchronizedMap(new HashMap(45));
    private Map prodTypes = Collections.synchronizedMap(new HashMap(10));
    private Map resources = Collections.synchronizedMap(new HashMap(25));

    public ConfigurationModelContainerImpl() {
    }

    public ConfigurationModelContainerImpl(ArrayList configObjects) throws ConfigurationException {
        this.setConfigurationObjects(configObjects);
    }

    public ConfigurationModelContainerImpl(Collection configObjects) throws ConfigurationException {
        this.setConfigurationObjects(configObjects);
    }

    public ConfigurationModelContainerImpl(Configuration config) {
        this.configuration = (BasicConfiguration)config;
    }

    protected ConfigurationObjectEditorHelper getEditor() {
        if (this.editor == null) {
            this.editor = new ConfigurationObjectEditorHelper();
        }
        return this.editor;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isConfigurationModel() {
        return this.getConfiguration() != null;
    }

    @Override
    public ConfigurationID getConfigurationID() {
        return (ConfigurationID)this.configuration.getID();
    }

    @Override
    public Collection getAllObjects() {
        ArrayList<Configuration> configObjects = new ArrayList<Configuration>();
        configObjects.add(this.getConfiguration());
        configObjects.addAll(this.getConfiguration().getVMComponentDefns());
        configObjects.addAll(this.getConfiguration().getServiceComponentDefns());
        configObjects.addAll(this.getConfiguration().getDeployedComponents());
        configObjects.addAll(this.getConfiguration().getPSCs());
        configObjects.addAll(this.getHosts());
        configObjects.addAll(this.getConfiguration().getConnectorBindings());
        configObjects.addAll(this.getComponentTypes().values());
        configObjects.addAll(this.getProductTypes());
        configObjects.addAll(this.getResources());
        return configObjects;
    }

    @Override
    public Map getComponentTypes() {
        return new HashMap(this.compTypes);
    }

    @Override
    public ComponentTypeDefn getComponentTypeDefinition(ComponentTypeID typeID, String defnName) {
        ComponentType type = this.getComponentType(typeID.getFullName());
        if (type == null) {
            return null;
        }
        ComponentTypeDefn defn = null;
        defn = type.getComponentTypeDefinition(defnName);
        if (defn != null) {
            return defn;
        }
        Collection inheritedDefns = this.getSuperComponentTypeDefinitions(null, null, type);
        if (inheritedDefns == null || inheritedDefns.size() == 0) {
            return defn;
        }
        Iterator inheritedIter = inheritedDefns.iterator();
        ComponentTypeDefn inheritedDefn = null;
        while (inheritedIter.hasNext()) {
            inheritedDefn = (ComponentTypeDefn)inheritedIter.next();
            if (!inheritedDefn.getFullName().equalsIgnoreCase(defnName)) continue;
            return inheritedDefn;
        }
        return defn;
    }

    @Override
    public Collection getAllComponentTypeDefinitions(ComponentTypeID typeID) {
        ComponentType type = this.getComponentType(typeID.getFullName());
        if (type == null) {
            return Collections.EMPTY_LIST;
        }
        Collection defns = type.getComponentTypeDefinitions();
        Collection inheritedDefns = this.getSuperComponentTypeDefinitions(null, null, type);
        Iterator inheritedIter = inheritedDefns.iterator();
        Iterator localIter = defns.iterator();
        ComponentTypeDefn inheritedDefn = null;
        ComponentTypeDefn localDefn = null;
        while (localIter.hasNext()) {
            localDefn = (ComponentTypeDefn)localIter.next();
            while (inheritedIter.hasNext()) {
                inheritedDefn = (ComponentTypeDefn)inheritedIter.next();
                if (!localDefn.getPropertyDefinition().equals(inheritedDefn.getPropertyDefinition())) continue;
                inheritedIter.remove();
            }
            inheritedIter = inheritedDefns.iterator();
        }
        defns.addAll(inheritedDefns);
        return defns;
    }

    private Collection getSuperComponentTypeDefinitions(Map defnMap, Collection defns, ComponentType type) {
        if (defnMap == null) {
            defnMap = new HashMap<PropertyDefinition, ComponentTypeDefn>();
        }
        if (defns == null) {
            defns = new ArrayList<ComponentTypeDefn>();
        }
        if (type == null) {
            return defns;
        }
        if (type.getSuperComponentTypeID() == null) {
            return defns;
        }
        ComponentType superType = this.getComponentType(type.getSuperComponentTypeID().getFullName());
        if (superType == null) {
            return defns;
        }
        Collection superDefns = superType.getComponentTypeDefinitions();
        if (superDefns != null && superDefns.size() > 0) {
            for (ComponentTypeDefn sDefn : superDefns) {
                if (defnMap.containsKey(sDefn.getPropertyDefinition())) continue;
                defnMap.put(sDefn.getPropertyDefinition(), sDefn);
                defns.add(sDefn);
            }
        }
        return this.getSuperComponentTypeDefinitions(defnMap, defns, superType);
    }

    @Override
    public ComponentType getComponentType(String fullName) {
        if (this.compTypes.containsKey(fullName)) {
            return (ComponentType)this.compTypes.get(fullName);
        }
        return null;
    }

    @Override
    public Properties getDefaultPropertyValues(ComponentTypeID componentTypeID) {
        Properties result = new Properties();
        Collection defns = this.getAllComponentTypeDefinitions(componentTypeID);
        for (ComponentTypeDefn ctd : defns) {
            Object value = ctd.getPropertyDefinition().getDefaultValue();
            if (value == null) continue;
            if (value instanceof String) {
                String v = (String)value;
                if (v.trim().length() <= 0) continue;
                result.put(ctd.getPropertyDefinition().getName(), v);
                continue;
            }
            result.put(ctd.getPropertyDefinition().getName(), value.toString());
        }
        return result;
    }

    @Override
    public Collection getHosts() {
        ArrayList hosts = new ArrayList(this.configuration.getHosts().size());
        hosts.addAll(this.configuration.getHosts());
        return hosts;
    }

    @Override
    public Host getHost(String fullName) {
        try {
            return this.configuration.getHost(fullName);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Collection getConnectionPools() {
        ArrayList pools = new ArrayList(this.configuration.getResourcePools().size());
        pools.addAll(this.configuration.getResourcePools());
        return pools;
    }

    @Override
    public ProductType getProductType(String name) {
        if (this.prodTypes.containsKey(name)) {
            return (ProductType)this.prodTypes.get(name);
        }
        return null;
    }

    @Override
    public Collection getProductTypes() {
        ArrayList pts = new ArrayList(this.prodTypes.size());
        pts.addAll(this.prodTypes.values());
        return pts;
    }

    @Override
    public SharedResource getResource(String resourceName) {
        if (this.resources.containsKey(resourceName)) {
            return (SharedResource)this.resources.get(resourceName);
        }
        return null;
    }

    @Override
    public Collection getResources() {
        ArrayList result = new ArrayList(this.resources.size());
        result.addAll(this.resources.values());
        return result;
    }

    @Override
    public ConfigurationModelContainer copyAs(ConfigurationID configID) throws ConfigurationException {
        BasicConfigurationObjectEditor ceditor = new BasicConfigurationObjectEditor(false);
        Configuration newConfig = ceditor.createConfiguration(this.configuration, configID.getFullName());
        ConfigurationModelContainerImpl newConfigModel = new ConfigurationModelContainerImpl(newConfig);
        newConfigModel.setComponentTypes(this.compTypes);
        newConfigModel.setProductTypes(this.prodTypes.values());
        newConfigModel.setResources(this.resources);
        return newConfigModel;
    }

    public void setComponentTypes(Map newCompTypes) throws ConfigurationLockException {
        this.compTypes = Collections.synchronizedMap(new HashMap(newCompTypes.size()));
        Iterator it = newCompTypes.values().iterator();
        while (it.hasNext()) {
            this.addComponentType((ComponentType)it.next());
        }
    }

    public void setProductTypes(Collection newProdTypes) throws ConfigurationLockException {
        this.prodTypes = Collections.synchronizedMap(new HashMap(newProdTypes.size()));
        Iterator it = newProdTypes.iterator();
        while (it.hasNext()) {
            this.addProductType((ProductType)it.next());
        }
    }

    public void setResources(Map theResources) {
        this.resources = Collections.synchronizedMap(new HashMap(theResources.size()));
        this.resources.putAll(theResources);
    }

    public void setResources(Collection theResources) {
        this.resources = Collections.synchronizedMap(new HashMap(theResources.size()));
        for (SharedResource rd : theResources) {
            this.resources.put(rd.getID().getFullName(), rd);
        }
    }

    public void addComponentType(ComponentType type) {
        this.compTypes.put(type.getFullName(), type);
    }

    public void addProductType(ProductType type) {
        this.prodTypes.put(type.getFullName(), type);
    }

    public void addResource(SharedResource rd) {
        this.resources.put(rd.getID().getFullName(), rd);
    }

    public void addObjects(Collection objects) throws ConfigurationException {
        this.setConfigurationObjects(objects);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addObject(Object obj) throws ConfigurationException {
        if (obj instanceof ServiceComponentDefn) {
            ServiceComponentDefn scd = (ServiceComponentDefn)obj;
            if (this.configuration == null) {
                throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
            }
            ConfigurationObjectEditorHelper.addConfigurationComponentDefn(this.configuration, scd);
            return;
        } else if (obj instanceof DeployedComponent) {
            DeployedComponent deployedComp = (DeployedComponent)obj;
            if (this.configuration == null) {
                throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
            }
            ConfigurationObjectEditorHelper.addConfigurationDeployedComponent(this.configuration, deployedComp);
            return;
        } else if (obj instanceof VMComponentDefn) {
            VMComponentDefn vm = (VMComponentDefn)obj;
            if (this.configuration == null) {
                throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
            }
            ConfigurationObjectEditorHelper.addConfigurationComponentDefn(this.configuration, vm);
            return;
        } else if (obj instanceof Host) {
            Host host = (Host)obj;
            if (this.configuration == null) {
                throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
            }
            ConfigurationObjectEditorHelper.addConfigurationHostComponent(this.configuration, host);
            return;
        } else if (obj instanceof ProductServiceConfig) {
            ProductServiceConfig psc = (ProductServiceConfig)obj;
            if (this.configuration == null) {
                throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
            }
            ConfigurationObjectEditorHelper.addConfigurationComponentDefn(this.configuration, psc);
            return;
        } else if (obj instanceof SharedResource) {
            SharedResource rd = (SharedResource)obj;
            this.addResource(rd);
            return;
        } else if (obj instanceof AuthenticationProvider) {
            AuthenticationProvider rd = (AuthenticationProvider)obj;
            ConfigurationObjectEditorHelper.addConfigurationComponentDefn(this.configuration, rd);
            return;
        } else if (obj instanceof ResourceDescriptor) {
            ResourceDescriptor rd = (ResourceDescriptor)obj;
            if (this.configuration == null) {
                throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
            }
            ConfigurationObjectEditorHelper.addConfigurationComponentDefn(this.configuration, rd);
            return;
        } else if (obj instanceof Configuration) {
            if (this.configuration != null) throw new ConfigurationException("ERR.003.001.0094", CommonPlugin.Util.getString("ERR.003.001.0094"));
            this.configuration = (BasicConfiguration)obj;
            return;
        } else if (obj instanceof ProductType) {
            this.addProductType((ProductType)obj);
            return;
        } else {
            if (!(obj instanceof ComponentType)) throw new ConfigurationException("ERR.003.001.0095", CommonPlugin.Util.getString("ERR.003.001.0095", new Object[]{obj.getClass().getName()}));
            this.addComponentType((ComponentType)obj);
        }
    }

    public void setConfigurationObjects(Collection objects) throws ConfigurationException {
        if (this.configuration != null) {
            throw new ConfigurationException("ERR.003.001.0096", CommonPlugin.Util.getString("ERR.003.001.0096"));
        }
        for (Object obj : objects) {
            if (obj instanceof Configuration) {
                BasicConfiguration config;
                this.configuration = config = (BasicConfiguration)obj;
                continue;
            }
            this.addObject(obj);
        }
    }

    public void remove(BaseID objID) throws ConfigurationException {
        if (objID instanceof ServiceComponentDefnID) {
            this.remove((ServiceComponentDefnID)objID);
        } else if (objID instanceof DeployedComponentID) {
            this.remove((DeployedComponentID)objID);
        } else if (objID instanceof VMComponentDefnID) {
            this.remove((VMComponentDefnID)objID);
        } else if (objID instanceof HostID) {
            this.remove((HostID)objID);
        } else if (objID instanceof ProductServiceConfigID) {
            this.remove((ProductServiceConfigID)objID);
        } else if (objID instanceof SharedResourceID) {
            this.removeSharedResource((SharedResourceID)objID);
        } else if (objID instanceof ResourceDescriptorID) {
            this.remove((ResourceDescriptorID)objID);
        } else if (objID instanceof ProductTypeID) {
            this.removeProductType((ProductTypeID)objID);
        } else if (objID instanceof ComponentTypeID) {
            this.removeComponentType((ComponentTypeID)objID);
        } else {
            throw new ConfigurationException("ERR.003.001.0101", CommonPlugin.Util.getString("ERR.003.001.0101", new Object[]{objID.getClass().getName()}));
        }
    }

    private void removeComponentType(ComponentTypeID typeID) {
        if (this.compTypes.containsKey(typeID.getFullName())) {
            this.compTypes.remove(typeID.getFullName());
        }
        Collection c = this.getProductTypes();
        for (BasicProductType type : c) {
            type.removeServiceTypeID(typeID);
        }
    }

    private void removeProductType(ProductTypeID typeID) {
        if (this.prodTypes.containsKey(typeID.getFullName())) {
            this.prodTypes.remove(typeID.getFullName());
        }
    }

    private void removeSharedResource(SharedResourceID rdID) {
        if (this.resources.containsKey(rdID.getFullName())) {
            this.resources.remove(rdID.getFullName());
        }
    }

    private void remove(ServiceComponentDefnID defnID) throws ConfigurationException {
        if (this.configuration == null) {
            throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
        }
        ConfigurationObjectEditorHelper.delete(defnID, this.configuration);
    }

    private void remove(VMComponentDefnID defnID) throws ConfigurationException {
        if (this.configuration == null) {
            throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
        }
        ConfigurationObjectEditorHelper.delete(defnID, this.configuration);
    }

    private void remove(DeployedComponentID dcID) throws ConfigurationException {
        if (this.configuration == null) {
            throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
        }
        ConfigurationObjectEditorHelper.delete(dcID, this.configuration);
    }

    private void remove(HostID hostID) throws ConfigurationException {
        if (this.configuration == null) {
            throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
        }
        ConfigurationObjectEditorHelper.delete(hostID, this.configuration);
    }

    private void remove(ProductServiceConfigID pscID) throws ConfigurationException {
        if (this.configuration == null) {
            throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
        }
        ConfigurationObjectEditorHelper.delete(pscID, this.configuration);
    }

    private void remove(ResourceDescriptorID rdID) throws ConfigurationException {
        if (this.configuration == null) {
            throw new ConfigurationException("ERR.003.001.0093", CommonPlugin.Util.getString("ERR.003.001.0093"));
        }
        ConfigurationObjectEditorHelper.delete(rdID, this.configuration);
    }

    @Override
    public Object clone() {
        Configuration config = (Configuration)this.configuration.clone();
        ConfigurationModelContainerImpl newConfig = new ConfigurationModelContainerImpl(config);
        try {
            newConfig.setComponentTypes(this.compTypes);
            newConfig.setProductTypes(this.prodTypes.values());
        }
        catch (ConfigurationLockException e) {
            throw new MetaMatrixRuntimeException((Throwable)((Object)e));
        }
        newConfig.setResources(this.resources);
        return newConfig;
    }
}

