/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.model.BasicConfiguration;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.config.model.BasicProductServiceConfig;
import com.metamatrix.common.config.model.BasicProductType;
import com.metamatrix.common.config.model.BasicServiceComponentDefn;
import com.metamatrix.common.config.model.BasicUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ConfigurationObjectEditorHelper {
    public static final int SET = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static boolean set = false;

    public static Host createHost(Configuration config, String hostName) throws ConfigurationException {
        ArgCheck.isNotNull((Object)hostName);
        ArgCheck.isNotNull((Object)config);
        BasicHost bh = (BasicHost)BasicUtil.createComponentDefn(7, (ConfigurationID)config.getID(), Host.HOST_COMPONENT_TYPE_ID, hostName);
        BasicConfiguration bc = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(config, BasicConfiguration.class);
        bc.addHost(bh);
        return bh;
    }

    public static ComponentType setLastChangedHistory(ComponentType type, String lastChangedBy, String lastChangedDate) {
        Assertion.isNotNull((Object)type);
        BasicComponentType target = (BasicComponentType)ConfigurationObjectEditorHelper.verifyTargetClass(type, BasicComponentType.class);
        target.setLastChangedBy(lastChangedBy);
        target.setLastChangedDate(lastChangedDate);
        return target;
    }

    public static ComponentType setCreationChangedHistory(ComponentType type, String createdBy, String creationDate) {
        Assertion.isNotNull((Object)type);
        BasicComponentType target = (BasicComponentType)ConfigurationObjectEditorHelper.verifyTargetClass(type, BasicComponentType.class);
        target.setCreatedBy(createdBy);
        target.setCreatedDate(creationDate);
        return target;
    }

    public static ComponentObject setLastChangedHistory(ComponentObject defn, String lastChangedBy, String lastChangedDate) {
        Assertion.isNotNull((Object)defn);
        BasicComponentObject target = (BasicComponentObject)ConfigurationObjectEditorHelper.verifyTargetClass(defn, BasicComponentObject.class);
        target.setLastChangedBy(lastChangedBy);
        target.setLastChangedDate(lastChangedDate);
        return target;
    }

    public static ComponentObject setCreationChangedHistory(ComponentObject defn, String createdBy, String creationDate) {
        Assertion.isNotNull((Object)defn);
        BasicComponentObject target = (BasicComponentObject)ConfigurationObjectEditorHelper.verifyTargetClass(defn, BasicComponentObject.class);
        target.setCreatedBy(createdBy);
        target.setCreatedDate(creationDate);
        return target;
    }

    public static void setRoutingUUID(ServiceComponentDefn serviceComponentDefn, String newRoutingUUID) {
        Assertion.isNotNull((Object)serviceComponentDefn);
        BasicServiceComponentDefn basicService = (BasicServiceComponentDefn)ConfigurationObjectEditorHelper.verifyTargetClass(serviceComponentDefn, BasicServiceComponentDefn.class);
        basicService.setRoutingUUID(newRoutingUUID);
    }

    public static void setEnabled(ServiceComponentDefnID serviceComponentDefnID, ProductServiceConfig psc, boolean enabled) {
        Assertion.isNotNull((Object)serviceComponentDefnID);
        Assertion.isNotNull((Object)psc);
        if (!psc.containsService(serviceComponentDefnID)) {
            return;
        }
        boolean oldEnabled = psc.isServiceEnabled(serviceComponentDefnID);
        if (enabled != oldEnabled) {
            BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)ConfigurationObjectEditorHelper.verifyTargetClass(psc, BasicProductServiceConfig.class);
            basicPSC.setServiceEnabled(serviceComponentDefnID, enabled);
        }
    }

    public static Configuration addHostComponent(Configuration t, Host host) {
        if (host == null) {
            return t;
        }
        BasicConfiguration target = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicConfiguration.class);
        target.addHost(host);
        return target;
    }

    public static ProductServiceConfig addServiceComponentDefn(ProductServiceConfig psc, ServiceComponentDefnID serviceComponentDefnID) {
        Assertion.isNotNull((Object)psc);
        Assertion.isNotNull((Object)serviceComponentDefnID);
        BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)ConfigurationObjectEditorHelper.verifyTargetClass(psc, BasicProductServiceConfig.class);
        basicPSC.addServiceComponentDefnID(serviceComponentDefnID);
        return basicPSC;
    }

    public static Configuration addComponentDefn(Configuration t, ComponentDefn defn) {
        BasicConfiguration target = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicConfiguration.class);
        target.addComponentDefn(defn);
        return target;
    }

    public static Configuration addDeployedComponent(Configuration t, DeployedComponent deployComponent) {
        BasicConfiguration target = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicConfiguration.class);
        target.addDeployedComponent(deployComponent);
        return target;
    }

    public static ComponentObject addProperty(ComponentObject t, String name, String value) {
        Assertion.isNotNull((Object)t);
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)value);
        BasicComponentObject target = (BasicComponentObject)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicComponentObject.class);
        target.addProperty(name, value);
        return target;
    }

    public static ComponentObject setProperty(ComponentObject t, String name, String value) {
        Assertion.isNotNull((Object)t);
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)value);
        BasicComponentObject target = (BasicComponentObject)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicComponentObject.class);
        target.removeProperty(name);
        target.addProperty(name, value);
        return target;
    }

    public static ProductServiceConfig resetServices(ProductServiceConfig psc) {
        Assertion.isNotNull((Object)psc);
        BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)ConfigurationObjectEditorHelper.verifyTargetClass(psc, BasicProductServiceConfig.class);
        basicPSC.resetServices();
        return basicPSC;
    }

    public static ComponentObject removeProperty(ComponentObject t, String name) {
        Assertion.isNotNull((Object)t);
        Assertion.isNotNull((Object)name);
        BasicComponentObject target = (BasicComponentObject)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicComponentObject.class);
        target.removeProperty(name);
        return target;
    }

    public static ComponentObject modifyProperties(ComponentObject t, Properties props, int command) {
        Assertion.isNotNull((Object)t);
        if (props == null) {
            return t;
        }
        BasicComponentObject target = (BasicComponentObject)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicComponentObject.class);
        Properties newProps = null;
        switch (command) {
            case 1: {
                newProps = new Properties();
                newProps.putAll((Map<?, ?>)target.getEditableProperties());
                newProps.putAll((Map<?, ?>)props);
                target.addProperties(newProps);
                break;
            }
            case 2: {
                newProps = new Properties();
                newProps.putAll((Map<?, ?>)target.getEditableProperties());
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    newProps.remove(iter.next());
                }
                target.setProperties(newProps);
                break;
            }
            case 0: {
                target.setProperties(props);
            }
        }
        return target;
    }

    public static Configuration delete(ComponentObjectID targetID, Configuration configuration) throws ConfigurationException {
        BasicConfiguration basicConfig = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(configuration, BasicConfiguration.class);
        if (targetID instanceof ProductServiceConfigID) {
            if (ProductServiceConfigID.ALL_STANDARD_PSC_NAMES.contains(targetID.getName())) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0070"));
            }
            basicConfig.removeComponentObject(targetID);
        } else {
            basicConfig.removeComponentObject(targetID);
        }
        return basicConfig;
    }

    public static ProductType addServiceComponentType(ProductType productType, ComponentType serviceComponentType) {
        BasicProductType basicProdType = (BasicProductType)productType;
        ComponentTypeID productTypeID = (ComponentTypeID)basicProdType.getID();
        ConfigurationObjectEditorHelper.setParentComponentTypeID(serviceComponentType, productTypeID);
        basicProdType.addServiceTypeID((ComponentTypeID)serviceComponentType.getID());
        return basicProdType;
    }

    protected static ComponentType setParentComponentTypeID(ComponentType t, ComponentTypeID parentID) {
        BasicComponentType target = (BasicComponentType)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicComponentType.class);
        ComponentTypeID oldValue = target.getParentComponentTypeID();
        if (parentID == null && oldValue != null || oldValue == null || !oldValue.equals(parentID)) {
            target.setParentComponentTypeID(parentID);
        }
        return target;
    }

    public static ProductType removeServiceComponentType(ProductType productType, ComponentType serviceComponentType) {
        BasicProductType basicProdType = (BasicProductType)productType;
        basicProdType.removeServiceTypeID((ComponentTypeID)serviceComponentType.getID());
        return basicProdType;
    }

    public static Configuration addConfigurationComponentDefn(Configuration t, ComponentDefn defn) {
        Assertion.isNotNull((Object)defn);
        BasicConfiguration target = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicConfiguration.class);
        target.addComponentDefn(defn);
        return target;
    }

    public static Configuration addConfigurationDeployedComponent(Configuration t, DeployedComponent deployedComponent) {
        Assertion.isNotNull((Object)deployedComponent);
        BasicConfiguration target = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicConfiguration.class);
        target.addDeployedComponent(deployedComponent);
        return target;
    }

    public static Configuration addConfigurationHostComponent(Configuration t, Host host) {
        Assertion.isNotNull((Object)host);
        BasicConfiguration target = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicConfiguration.class);
        target.addHost(host);
        return target;
    }

    public static Configuration addAuthenticationProviderComponent(Configuration t, AuthenticationProvider provider) {
        Assertion.isNotNull((Object)provider);
        BasicConfiguration target = (BasicConfiguration)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicConfiguration.class);
        target.addComponentDefn(provider);
        return target;
    }

    public static Properties getEditableProperties(ComponentObject t) {
        BasicComponentObject bco = (BasicComponentObject)ConfigurationObjectEditorHelper.verifyTargetClass(t, BasicComponentObject.class);
        return bco.getEditableProperties();
    }

    protected static Object verifyTargetClass(Object target, Class requiredClass) throws IllegalArgumentException {
        if (!requiredClass.isInstance(target)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0072", new Object[]{requiredClass.getName()}));
        }
        return target;
    }
}

