/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.reader;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationConnectionException;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.config.reader.CurrentConfigurationReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesConfigurationReader
implements CurrentConfigurationReader {
    private ConfigurationModelContainer c;
    public static final String FILENAME = "metamatrix.config.readerFile";

    @Override
    public void connect(Properties env) throws ConfigurationConnectionException {
        String filename = env.getProperty(FILENAME);
        Properties p = null;
        if (filename != null) {
            File f = new File(filename);
            InputStream is = null;
            try {
                is = f.exists() ? new FileInputStream(f) : this.getClass().getResourceAsStream(filename);
                if (is == null) {
                    throw new ConfigurationConnectionException("ERR.003.001.0064", CommonPlugin.Util.getString("ERR.003.001.0064", new Object[]{filename}));
                }
                p = new Properties(env);
                p.load(is);
            }
            catch (IOException e) {
                throw new ConfigurationConnectionException(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        p = env;
        BasicConfigurationObjectEditor coe = new BasicConfigurationObjectEditor(false);
        Configuration currentConfiguration = coe.createConfiguration(PropertiesConfigurationReader.class.getSimpleName() + ':' + filename);
        currentConfiguration = (Configuration)coe.modifyProperties(currentConfiguration, p, 0);
        this.c = new ConfigurationModelContainerImpl(currentConfiguration);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public ConfigurationModelContainer getConfigurationModel() throws ConfigurationException {
        return this.c;
    }

    @Override
    public void indicateSystemShutdown() throws ConfigurationException {
    }

    @Override
    public void performSystemInitialization(boolean forceInitialization) throws StartupStateException, ConfigurationException {
    }
}

