/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.util;

import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.core.util.StringUtil;
import java.util.Collection;
import java.util.Properties;

public class ConfigUtil
implements StringUtil.Constants {
    private static ConfigurationObjectEditor editor = new BasicConfigurationObjectEditor();

    public static ConfigurationObjectEditor getEditor() {
        return editor;
    }

    public static final Properties buildDefaultPropertyValues(ComponentTypeID componentTypeID, ConfigurationModelContainer model) {
        Properties result = new Properties();
        Collection defns = model.getAllComponentTypeDefinitions(componentTypeID);
        for (ComponentTypeDefn ctd : defns) {
            Object value = ctd.getPropertyDefinition().getDefaultValue();
            if (value == null) continue;
            if (value instanceof String) {
                String v = (String)value;
                if (v.trim().length() <= 0) continue;
                result.put(ctd.getPropertyDefinition().getName(), v);
                continue;
            }
            result.put(ctd.getPropertyDefinition().getName(), value.toString());
        }
        return result;
    }

    public static ProductServiceConfig getFirstDeployedConnectorProductTypePSC(ConfigurationModelContainer cmc) throws Exception {
        ProductTypeID prodType = new ProductTypeID("Connectors");
        for (DeployedComponent dc : cmc.getConfiguration().getDeployedComponents()) {
            if (!dc.isDeployedConnector()) continue;
            ProductServiceConfigID pscID = dc.getProductServiceConfigID();
            ProductServiceConfig psc = cmc.getConfiguration().getPSC(pscID);
            if (!psc.getComponentTypeID().equals(prodType)) continue;
            return psc;
        }
        return null;
    }
}

