/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfig_42_HelperImpl;
import com.metamatrix.common.config.xml.XMLConfig_42_Visitor;
import com.metamatrix.common.config.xml.XMLConfig_Base_ImportExportUtility;
import com.metamatrix.common.config.xml.XMLHelper;
import com.metamatrix.common.config.xml.XMLHelperUtil;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BaseObject;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ReflectionHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLConfig_42_ImportExportUtility
extends XMLConfig_Base_ImportExportUtility {
    private static final String CONFIG_MODEL_CLASS = ConfigurationModelContainerImpl.class.getName();
    private XMLConfig_42_HelperImpl xmlHelper = null;

    public void exportConfiguration(OutputStream stream, Collection configurationObjects, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        Assertion.isNotNull((Object)configurationObjects);
        Assertion.isNotNull((Object)stream);
        List[] lists = this.segregateConfigurationObjects(configurationObjects);
        this.resolveConfigurationObjects(lists);
        ConfigurationModelContainer cmc = null;
        try {
            ArrayList<Collection> parms = new ArrayList<Collection>(1);
            parms.add(configurationObjects);
            cmc = (ConfigurationModelContainer)ReflectionHelper.create((String)CONFIG_MODEL_CLASS, parms, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (MetaMatrixCoreException err) {
            throw new IOException(err.getMessage());
        }
        this.getXMLHelper();
        XMLConfig_42_Visitor visitor = new XMLConfig_42_Visitor(this.xmlHelper);
        Element root = this.xmlHelper.createRootConfigurationDocumentElement();
        Document doc = new Document(root);
        root = XMLHelperUtil.addHeaderElement(root, props);
        Configuration config = cmc.getConfiguration();
        Element configElement = visitor.visitComponent(config);
        root.addContent((Content)configElement);
        try {
            for (Host h : cmc.getHosts()) {
                Element hostElement = visitor.visitComponent(h);
                configElement.addContent((Content)hostElement);
                for (VMComponentDefn vm : cmc.getConfiguration().getVMsForHost((HostID)h.getID())) {
                    Element vmElement = visitor.visitComponent(vm);
                    hostElement.addContent((Content)vmElement);
                    HashMap pscSvcMap = new HashMap(10);
                    Iterator depIt = cmc.getConfiguration().getDeployedServicesForVM(vm).iterator();
                    Collection<DeployedComponent> svcs = null;
                    while (depIt.hasNext()) {
                        DeployedComponent dc = (DeployedComponent)depIt.next();
                        if (!pscSvcMap.containsKey(dc.getProductServiceConfigID())) {
                            svcs = new ArrayList();
                            pscSvcMap.put(dc.getProductServiceConfigID(), svcs);
                        } else {
                            svcs = (Collection)pscSvcMap.get(dc.getProductServiceConfigID());
                        }
                        svcs.add(dc);
                    }
                    for (ProductServiceConfigID pscID : pscSvcMap.keySet()) {
                        ProductServiceConfig psc = cmc.getConfiguration().getPSC(pscID);
                        Element pscElement = this.getXMLHelper().createDeployedProductServiceConfigElement(psc);
                        vmElement.addContent((Content)pscElement);
                        Collection depsvcs = (Collection)pscSvcMap.get(pscID);
                        for (DeployedComponent dc : depsvcs) {
                            Element svcElement = visitor.visitComponent(dc);
                            pscElement.addContent((Content)svcElement);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConfigObjectsNotResolvableException(e, (Object)"Error exporting configuration");
        }
        Element pscsElement = this.xmlHelper.createProductServiceConfigsElement();
        root.addContent((Content)pscsElement);
        Collection pscs = cmc.getConfiguration().getPSCs();
        if (pscs != null && pscs.size() > 0) {
            for (ProductServiceConfig type : pscs) {
                Element productTypeElement = visitor.visitComponent(type);
                pscsElement.addContent((Content)productTypeElement);
            }
        }
        Element productTypesElement = this.xmlHelper.createProductTypesElement();
        root.addContent((Content)productTypesElement);
        Collection productTypes = cmc.getProductTypes();
        if (productTypes != null && productTypes.size() > 0) {
            for (ProductType type : productTypes) {
                Element productTypeElement = visitor.visitComponent(type);
                productTypesElement.addContent((Content)productTypeElement);
            }
        }
        Element resourcePoolsElement = this.xmlHelper.createResourcePoolsElement();
        root.addContent((Content)resourcePoolsElement);
        Collection pools = cmc.getConnectionPools();
        if (pools != null && pools.size() > 0) {
            for (ResourceDescriptor type : pools) {
                Element resourceElement = visitor.visitComponent(type);
                resourcePoolsElement.addContent((Content)resourceElement);
            }
        }
        Element providersElement = this.xmlHelper.createAuthenticationProviderElement();
        root.addContent((Content)providersElement);
        Collection providers = cmc.getConfiguration().getAuthenticationProviders();
        if (providers != null && providers.size() > 0) {
            for (AuthenticationProvider provider : providers) {
                Element resourceElement = visitor.visitComponent(provider);
                providersElement.addContent((Content)resourceElement);
            }
        }
        Element connectorsElement = this.xmlHelper.createConnectorBindingsElement();
        root.addContent((Content)connectorsElement);
        Collection bindings = cmc.getConfiguration().getConnectorBindings();
        if (bindings != null && bindings.size() > 0) {
            for (ConnectorBinding connector : bindings) {
                Element connElement = visitor.visitConnectorBindingComponent(connector);
                connectorsElement.addContent((Content)connElement);
            }
        }
        Element servicessElement = this.xmlHelper.createServiceComponentDefnsElement();
        root.addContent((Content)servicessElement);
        Collection svcdefns = cmc.getConfiguration().getServiceComponentDefns();
        if (svcdefns != null && svcdefns.size() > 0) {
            for (ServiceComponentDefn svc : svcdefns) {
                Element svcElement = visitor.visitComponent(svc);
                servicessElement.addContent((Content)svcElement);
            }
        }
        Element resourcesElement = this.xmlHelper.createSharedResourcesElement();
        root.addContent((Content)resourcesElement);
        Collection sharedResources = cmc.getResources();
        if (sharedResources != null && sharedResources.size() > 0) {
            for (SharedResource resource : sharedResources) {
                Element resourceElement = visitor.visitComponent(resource);
                resourcesElement.addContent((Content)resourceElement);
            }
        }
        Element componentTypesElement = this.xmlHelper.createComponentTypesElement();
        root.addContent((Content)componentTypesElement);
        Map compTypes = cmc.getComponentTypes();
        if (compTypes != null && compTypes.size() > 0) {
            for (ComponentType componentType : compTypes.values()) {
                Element componentTypeElement = visitor.visitComponent(componentType);
                componentTypesElement.addContent((Content)componentTypeElement);
            }
        }
        this.getXMLReaderWriter().writeDocument(doc, stream);
        stream.close();
        LogManager.logInfo("CONFIG", CommonPlugin.Util.getString("MSG.003.001.0003", new Object[]{cmc.getConfigurationID().getFullName()}));
    }

    public Collection importConfigurationObjects(Element root, ConfigurationObjectEditor editor, String name) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Element authprovidersElement;
        Element resourcePoolsElement;
        ArrayList productTypes;
        Element productTypesElement;
        Assertion.isNotNull((Object)root);
        Assertion.isNotNull((Object)editor);
        ArrayList<BaseObject> configurationObjects = new ArrayList<BaseObject>();
        this.getXMLHelper();
        Element configurationElement = root.getChild("Configuration");
        if (configurationElement == null) {
            throw new ConfigObjectsNotResolvableException("ERR.003.001.0004", (Object)CommonPlugin.Util.getString("ERR.003.001.0004"));
        }
        Configuration config = this.xmlHelper.createConfiguration(configurationElement, editor, name);
        ConfigurationID configID = (ConfigurationID)config.getID();
        configurationObjects.add(config);
        this.xmlHelper.addProperties(configurationElement, config, editor);
        Collection componentTypes = this.createComponentTypes(root, editor);
        HashMap<BaseID, ComponentType> componentTypeMap = new HashMap<BaseID, ComponentType>();
        if (componentTypes != null) {
            for (ComponentType type : componentTypes) {
                componentTypeMap.put(type.getID(), type);
                configurationObjects.add(type);
            }
        }
        if ((productTypesElement = root.getChild("ProductTypes")) != null && (productTypes = productTypesElement.getChildren("ProductType")) != null && productTypes.size() > 0) {
            productTypes = new ArrayList(productTypes);
            this.xmlHelper.orderComponentTypeElementList(productTypes);
            for (Element productTypeElement : productTypes) {
                ProductType type = this.xmlHelper.createProductType(productTypeElement, editor, componentTypeMap, null);
                configurationObjects.add(type);
            }
        }
        Element resourcesElement = root.getChild("SharedResources");
        List resources = null;
        resources = resourcesElement != null ? resourcesElement.getChildren("Resource") : Collections.EMPTY_LIST;
        for (Element resourceElement : resources) {
            SharedResource resource = this.xmlHelper.createSharedResource(resourceElement, editor);
            configurationObjects.add(resource);
        }
        HashMap<String, ProductServiceConfig> pscMap = new HashMap<String, ProductServiceConfig>(1);
        Element productServiceConfigsElement = root.getChild("ProductServiceConfigs");
        if (productServiceConfigsElement != null) {
            List productServiceConfigElements = productServiceConfigsElement.getChildren("PSC");
            pscMap = new HashMap(productServiceConfigElements.size());
            for (Element productServiceConfigElement : productServiceConfigElements) {
                ProductServiceConfig productServiceConfig = this.xmlHelper.createProductServiceConfig(productServiceConfigElement, configID, editor, null);
                configurationObjects.add(productServiceConfig);
                pscMap.put(productServiceConfig.getName(), productServiceConfig);
            }
        }
        if ((resourcePoolsElement = root.getChild("ConnectionPools")) != null) {
            List resourcePoolsElements = resourcePoolsElement.getChildren("ConnectionPool");
            for (Element resourcePoolElement : resourcePoolsElements) {
                ResourceDescriptor pool = this.xmlHelper.createResourcePool(resourcePoolElement, configID, editor);
                configurationObjects.add(pool);
            }
        }
        if ((authprovidersElement = root.getChild("AuthenticationProviders")) != null) {
            List authproviderElements = authprovidersElement.getChildren("Provider");
            for (Element resourcePoolElement : authproviderElements) {
                AuthenticationProvider provider = this.xmlHelper.createAuthenticationProvider(resourcePoolElement, configID, editor);
                configurationObjects.add(provider);
            }
        }
        Collection bindings = this.createConnectorBindings(configID, root, editor, true);
        HashMap<BaseID, ComponentDefn> serviceComponentDefnMap = new HashMap<BaseID, ComponentDefn>();
        for (ComponentDefn defn : bindings) {
            serviceComponentDefnMap.put(defn.getID(), defn);
        }
        Element serviceComponentDefnsElement = root.getChild("Services");
        if (serviceComponentDefnsElement != null) {
            List serviceComponentDefnElements = serviceComponentDefnsElement.getChildren("Service");
            for (Element serviceComponentDefnElement : serviceComponentDefnElements) {
                ComponentDefn defn = this.xmlHelper.createServiceComponentDefn(serviceComponentDefnElement, config, editor, null);
                serviceComponentDefnMap.put(defn.getID(), defn);
                configurationObjects.add(defn);
            }
        }
        configurationObjects.addAll(bindings);
        List hostElements = configurationElement.getChildren("Host");
        Iterator hostiterator = hostElements.iterator();
        Host host = null;
        HostID hostID = null;
        while (hostiterator.hasNext()) {
            Element hostElement = (Element)hostiterator.next();
            host = this.xmlHelper.createHost(hostElement, configID, editor, null);
            hostID = (HostID)host.getID();
            configurationObjects.add(host);
            List vmElements = hostElement.getChildren("Process");
            for (Element vmElement : vmElements) {
                VMComponentDefn vm = this.xmlHelper.createVMComponentDefn(vmElement, configID, hostID, editor, null);
                VMComponentDefnID vmID = (VMComponentDefnID)vm.getID();
                configurationObjects.add(vm);
                List pscElements = vmElement.getChildren("PSC");
                for (Element pscElement : pscElements) {
                    String pscName = pscElement.getAttributeValue("Name");
                    ProductServiceConfig psc = (ProductServiceConfig)pscMap.get(pscName);
                    List svcElements = pscElement.getChildren("Service");
                    for (Element svcElement : svcElements) {
                        DeployedComponent dc = this.xmlHelper.createDeployedServiceComponent(svcElement, configID, hostID, vmID, (ProductServiceConfigID)psc.getID(), componentTypeMap, editor);
                        configurationObjects.add(dc);
                    }
                }
            }
        }
        this.resolveConfigurationObjects(configurationObjects);
        return configurationObjects;
    }

    @Override
    protected XMLHelper getXMLHelper() {
        if (this.xmlHelper == null) {
            this.xmlHelper = new XMLConfig_42_HelperImpl();
        }
        return this.xmlHelper;
    }

    public ComponentType importComponentType(Element root, ConfigurationObjectEditor editor, String name) throws IOException, InvalidConfigurationElementException {
        Assertion.isNotNull((Object)editor);
        ComponentType t = this.createComponentType(root, editor, name);
        return t;
    }

    public Collection importComponentTypes(Element root, ConfigurationObjectEditor editor) throws IOException, InvalidConfigurationElementException {
        Assertion.isNotNull((Object)editor);
        Collection connectorTypes = this.createComponentTypes(root, editor);
        return connectorTypes;
    }

    @Override
    protected ComponentType createComponentType(Element root, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        XMLHelper helper = this.getXMLHelper();
        Element componentTypesElement = root.getChild("ComponentTypes");
        if (componentTypesElement == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0008", (Object)CommonPlugin.Util.getString("ERR.003.001.0008", new Object[]{"ComponentTypes"}));
        }
        Element componentTypeElement = componentTypesElement.getChild("ComponentType");
        if (componentTypeElement == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0008", (Object)CommonPlugin.Util.getString("ERR.003.001.0008", new Object[]{"ComponentType"}));
        }
        return helper.createComponentType(componentTypeElement, editor, name, true);
    }

    protected Collection createComponentTypes(Element root, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Element componentTypesElement = root.getChild("ComponentTypes");
        if (componentTypesElement == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList componentTypes = new ArrayList(componentTypesElement.getChildren("ComponentType"));
        ArrayList<ComponentType> connObjects = null;
        if (componentTypes != null) {
            connObjects = new ArrayList<ComponentType>(componentTypes.size());
            this.getXMLHelper().orderComponentTypeElementList(componentTypes);
            for (Element connElement : componentTypes) {
                ComponentType type = this.getXMLHelper().createComponentType(connElement, editor, null, true);
                connObjects.add(type);
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        return connObjects;
    }
}

