/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.util.ConfigurationImportExportUtility;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.ConnectorArchiveImportExportUtility;
import com.metamatrix.common.config.xml.XMLConfig_42_ImportExportUtility;
import com.metamatrix.common.config.xml.XMLHelperUtil;
import com.metamatrix.common.xml.XMLReaderWriter;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.Assertion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XMLConfigurationImportExportUtility
implements ConfigurationImportExportUtility {
    private XMLReaderWriter readerWriter;

    @Override
    public void exportConfiguration(OutputStream stream, Collection configurationObjects, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        util.exportConfiguration(stream, configurationObjects, props);
    }

    public void exportComponentType(OutputStream stream, ComponentType type, Properties props) throws IOException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        util.exportComponentType(stream, type, props);
    }

    public void exportComponentTypes(OutputStream stream, ComponentType[] types, Properties props) throws IOException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        util.exportComponentTypes(stream, types, props);
    }

    @Override
    public Collection importConfigurationObjects(InputStream stream, ConfigurationObjectEditor editor, String name) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Assertion.isNotNull((Object)stream);
        Assertion.isNotNull((Object)editor);
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(stream);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new IOException(CommonPlugin.Util.getString("ERR.003.001.0002"));
        }
        Element root = doc.getRootElement();
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importConfigurationObjects(root, editor, name);
    }

    protected XMLReaderWriter getXMLReaderWriter() {
        if (this.readerWriter == null) {
            this.readerWriter = new XMLReaderWriterImpl();
        }
        return this.readerWriter;
    }

    @Override
    public ComponentType importComponentType(InputStream stream, ConfigurationObjectEditor editor, String name) throws IOException, InvalidConfigurationElementException {
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(stream);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new IOException(CommonPlugin.Util.getString("ERR.003.001.0002"));
        }
        Element root = doc.getRootElement();
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importComponentType(root, editor, name);
    }

    @Override
    public Collection importComponentTypes(InputStream stream, ConfigurationObjectEditor editor) throws IOException, InvalidConfigurationElementException {
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(stream);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new IOException(CommonPlugin.Util.getString("ERR.003.001.0002"));
        }
        Element root = doc.getRootElement();
        return this.importComponentTypes(root, editor);
    }

    public Collection importComponentTypes(Element root, ConfigurationObjectEditor editor) throws IOException, InvalidConfigurationElementException {
        boolean is42Compatible = XMLHelperUtil.is42ConfigurationCompatible(root);
        return this.importComponentTypes(root, editor, is42Compatible);
    }

    public Collection importComponentTypes(Element root, ConfigurationObjectEditor editor, boolean is42Compatible) throws IOException, InvalidConfigurationElementException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importComponentTypes(root, editor);
    }

    @Override
    public void exportConnector(OutputStream stream, ComponentType type, Properties props) throws IOException {
        this.exportComponentType(stream, type, props);
    }

    @Override
    public void exportConnectorBinding(OutputStream stream, ConnectorBinding defn, ComponentType type, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        util.exportConnectorBinding(stream, defn, type, props);
    }

    public void exportConnectorBindings(ConnectorBinding[] bindings, ComponentType[] types, Element root) {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        util.exportConnectorBindings(bindings, types, root);
    }

    @Override
    public void exportConnectorBindings(OutputStream stream, ConnectorBinding[] bindings, ComponentType[] types, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        util.exportConnectorBindings(stream, bindings, types, props);
    }

    @Override
    public ComponentType importConnector(InputStream stream, ConfigurationObjectEditor editor, String newName) throws IOException, InvalidConfigurationElementException {
        return this.importComponentType(stream, editor, newName);
    }

    @Override
    public ConnectorBinding importConnectorBinding(InputStream stream, ConfigurationObjectEditor editor, String newName) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importConnectorBinding(stream, editor, newName);
    }

    public Collection importExistingConnectorBindings(Element root, ConfigurationObjectEditor editor, boolean importExistingBinding) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importConnectorBindings(root, editor, importExistingBinding);
    }

    public Collection importConnectorBindings(Element root, ConfigurationObjectEditor editor) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importConnectorBindings(root, editor, false);
    }

    @Override
    public Collection importConnectorBindings(InputStream stream, ConfigurationObjectEditor editor) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importConnectorBindings(stream, editor, false);
    }

    public Collection importExistingConnectorBindings(InputStream stream, ConfigurationObjectEditor editor, boolean useExistingBinding) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importConnectorBindings(stream, editor, useExistingBinding);
    }

    @Override
    public Object[] importConnectorBindingAndType(InputStream stream, ConfigurationObjectEditor editor, String[] newName) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        return util.importConnectorBindingAndType(stream, editor, newName);
    }

    public void resolveConfigurationObjects(Collection collection) throws ConfigObjectsNotResolvableException {
        XMLConfig_42_ImportExportUtility util = new XMLConfig_42_ImportExportUtility();
        util.resolveConfigurationObjects(collection);
    }

    @Override
    public ConnectorArchive importConnectorArchive(InputStream stream, ConfigurationObjectEditor editor) throws IOException, InvalidConfigurationElementException {
        ConnectorArchiveImportExportUtility util = new ConnectorArchiveImportExportUtility();
        return util.importConnectorArchive(stream, editor, this);
    }

    @Override
    public void exportConnectorArchive(OutputStream stream, ConnectorArchive archive, Properties properties) throws IOException, ConfigObjectsNotResolvableException {
        ConnectorArchiveImportExportUtility util = new ConnectorArchiveImportExportUtility();
        util.exportConnectorArchive(stream, archive, properties, this);
    }
}

