/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.google.inject.Inject;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.LogMessage;
import com.metamatrix.core.log.NullLogWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class LogManager {
    @Inject
    static LogConfiguration configuration = new BasicLogConfiguration();
    @Inject
    static LogListener logListener = new NullLogWriter();

    public static void logCritical(String context, String message) {
        LogManager.logMessage(1, context, message);
    }

    public static void logCritical(String context, Throwable e, String message) {
        LogManager.logMessage(1, context, e, message);
    }

    public static void logError(String context, String message) {
        LogManager.logMessage(2, context, message);
    }

    public static void logError(String context, Throwable e, String message) {
        LogManager.logMessage(2, context, e, message);
    }

    public static void logWarning(String context, String message) {
        LogManager.logMessage(3, context, message);
    }

    public static void logWarning(String context, Throwable e, String message) {
        LogManager.logMessage(3, context, e, message);
    }

    public static void logInfo(String context, String message) {
        LogManager.logMessage(4, context, message);
    }

    public static void logDetail(String context, Object ... msgParts) {
        LogManager.logMessage(5, context, msgParts);
    }

    public static void logDetail(String context, Throwable e, String message) {
        LogManager.logMessage(5, context, e, message);
    }

    public static void logTrace(String context, Object ... msgParts) {
        LogManager.logMessage(6, context, msgParts);
    }

    public static void logTrace(String context, Throwable e, Object ... msgParts) {
        LogManager.logMessage(6, context, e, msgParts);
    }

    public static void log(int msgLevel, String context, String message) {
        LogManager.logMessage(msgLevel, context, message);
    }

    public static void log(int msgLevel, String context, Throwable e, String message) {
        LogManager.logMessage(msgLevel, context, e, message);
    }

    public static LogConfiguration getLogConfigurationCopy() {
        if (configuration == null) {
            throw new MetaMatrixRuntimeException(CommonPlugin.Util.getString("LogManager_not_configured"));
        }
        return (LogConfiguration)configuration.clone();
    }

    public static void setLogConfiguration(LogConfiguration config) {
        if (config != null) {
            LogManager.logMessage(4, "LOG", CommonPlugin.Util.getString("MSG.003.014.0015", new Object[]{config}));
            configuration = (LogConfiguration)config.clone();
        }
    }

    public static void setLogListener(LogListener listener) {
        logListener.shutdown();
        logListener = listener != null ? listener : new NullLogWriter();
    }

    public static boolean isMessageToBeRecorded(String context, int msgLevel) {
        return configuration.isMessageToBeRecorded(context, msgLevel);
    }

    private static void logMessage(int level, String context, Object ... msgParts) {
        LogManager.logMessage(level, context, null, msgParts);
    }

    private static void logMessage(int level, String context, Throwable e, Object ... msgParts) {
        if (msgParts == null || msgParts.length == 0 || !LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(context, level, e, msgParts);
        logListener.logMessage(msg);
    }

    public static Object createLoggingProxy(final String loggingContext, final Object instance, Class[] interfaces, final int level) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                boolean log = LogManager.isMessageToBeRecorded(loggingContext, level);
                if (log) {
                    StringBuffer message = new StringBuffer();
                    message.append("before ");
                    message.append(method.getName());
                    message.append(":");
                    message.append(instance);
                    message.append("(");
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            if (args[i] != null) {
                                message.append(args[i]);
                            } else {
                                message.append("null");
                            }
                            if (i == args.length - 1) continue;
                            message.append(",");
                        }
                    }
                    message.append(")");
                    LogManager.log(level, loggingContext, message.toString());
                }
                try {
                    Object result = method.invoke(instance, args);
                    if (log) {
                        LogManager.log(level, loggingContext, "after " + method.getName() + " : " + result);
                    }
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
    }
}

