/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.Multiplicity;

final class IntervalMultiplicity
extends Multiplicity {
    private int minimum = 0;
    private int maximum = Integer.MAX_VALUE;

    IntervalMultiplicity(int number) {
        if (number < 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0008"));
        }
        if (number < 1) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0009"));
        }
        this.maximum = number;
        this.minimum = number;
    }

    IntervalMultiplicity(int minimum, int maximum, boolean isOrdered, boolean isUnique) {
        super(isOrdered, isUnique);
        if (maximum < 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0010", new Object[]{Integer.MAX_VALUE}));
        }
        if (minimum > maximum) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0011"));
        }
        this.maximum = maximum;
        this.minimum = minimum;
    }

    IntervalMultiplicity() {
        this(1);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public boolean isUnlimited() {
        return this.maximum == Integer.MAX_VALUE;
    }

    @Override
    public boolean isIncluded(int cardinality) {
        return cardinality >= this.minimum && cardinality <= this.maximum;
    }

    @Override
    public String toString() {
        String result = null;
        result = this.minimum != this.maximum ? (this.maximum != Integer.MAX_VALUE ? Integer.toString(this.minimum) + ".." + Integer.toString(this.maximum) : Integer.toString(this.minimum) + ".." + '*') : Integer.toString(this.minimum);
        return result;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0007", new Object[]{this.getClass().getName()}));
        }
        Multiplicity that = (Multiplicity)obj;
        return Multiplicity.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntervalMultiplicity) {
            IntervalMultiplicity that = (IntervalMultiplicity)obj;
            if (that.minimum == this.minimum && that.maximum == this.maximum) {
                return super.compareFlags(that) == 0;
            }
            return false;
        }
        return false;
    }
}

