/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.object.DefaultPropertyAccessPolicy;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertiedObjectImpl;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.transaction.UserTransactionFactory;
import com.metamatrix.common.transaction.manager.SimpleUserTransactionFactory;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import java.util.List;

public class PropertiedObjectEditorImpl
implements PropertiedObjectEditor {
    private PropertyAccessPolicy policy;
    private UserTransactionFactory txnFactory;

    public PropertiedObjectEditorImpl(PropertyAccessPolicy policy, UserTransactionFactory txnFactory) {
        ArgCheck.isNotNull((Object)policy);
        ArgCheck.isNotNull((Object)txnFactory);
        this.policy = policy;
        this.txnFactory = txnFactory;
    }

    public PropertiedObjectEditorImpl() {
        this(new DefaultPropertyAccessPolicy(), new SimpleUserTransactionFactory());
    }

    public PropertiedObjectEditorImpl(PropertyAccessPolicy policy) {
        this(policy, new SimpleUserTransactionFactory());
    }

    public PropertiedObjectEditorImpl(UserTransactionFactory txnFactory) {
        this(new DefaultPropertyAccessPolicy(), txnFactory);
    }

    protected PropertiedObjectImpl assertPropertiedObject(PropertiedObject obj) {
        ArgCheck.isInstanceOf(PropertiedObjectImpl.class, (Object)obj);
        return (PropertiedObjectImpl)obj;
    }

    @Override
    public List getPropertyDefinitions(PropertiedObject obj) {
        PropertiedObjectImpl descriptor = this.assertPropertiedObject(obj);
        return descriptor.getPropertyDefinitions();
    }

    @Override
    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        ArgCheck.isNotNull((Object)def);
        return def.getAllowedValues();
    }

    @Override
    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        PropertiedObjectImpl propObj = this.assertPropertiedObject(obj);
        ArgCheck.isNotNull((Object)def);
        return propObj.getValue(def);
    }

    @Override
    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        PropertiedObjectImpl propObj = this.assertPropertiedObject(obj);
        ArgCheck.isNotNull((Object)def);
        if (def.getMultiplicity().getMaximum() > 1) {
            Assertion.assertTrue((boolean)(value instanceof Object[]), (String)("The property definition " + def.getDisplayName() + " is multi-valued, so the property value must be an Object[]"));
        }
        return propObj.isValidValue(def, value);
    }

    @Override
    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        PropertiedObjectImpl propObj = this.assertPropertiedObject(obj);
        ArgCheck.isNotNull((Object)def);
        if (def.getMultiplicity().getMaximum() > 1) {
            Assertion.assertTrue((boolean)(value instanceof Object[]), (String)("The property definition " + def.getDisplayName() + " is multi-valued, so the property value must be an Object[]"));
        }
        propObj.setValue(def, value);
    }

    @Override
    public PropertyAccessPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicy(PropertyAccessPolicy policy) {
        this.policy = policy == null ? new DefaultPropertyAccessPolicy() : policy;
    }

    @Override
    public boolean isReadOnly(PropertiedObject obj) {
        return this.policy.isReadOnly(obj);
    }

    @Override
    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) {
        ArgCheck.isNotNull((Object)obj);
        ArgCheck.isNotNull((Object)def);
        return this.policy.isReadOnly(obj, def);
    }

    @Override
    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
        ArgCheck.isNotNull((Object)obj);
        ArgCheck.isNotNull((Object)def);
        this.policy.setReadOnly(obj, def, readOnly);
    }

    @Override
    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
        ArgCheck.isNotNull((Object)obj);
        this.policy.setReadOnly(obj, readOnly);
    }

    @Override
    public void reset(PropertiedObject obj) {
        ArgCheck.isNotNull((Object)obj);
        this.assertPropertiedObject(obj);
        this.policy.reset(obj);
    }

    @Override
    public UserTransaction createReadTransaction() {
        return this.txnFactory.createReadTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction() {
        return this.txnFactory.createWriteTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction(Object source) {
        return this.txnFactory.createWriteTransaction(source);
    }
}

