/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.HashCodeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiedObjectImpl
implements PropertiedObject,
Serializable,
Cloneable,
Comparable {
    private Map properties;
    private List unmodifiablePropertyDefns;

    public PropertiedObjectImpl(List propertyDefns) {
        ArgCheck.isNotNull((Object)propertyDefns);
        this.properties = new HashMap();
        this.unmodifiablePropertyDefns = propertyDefns;
        this.updateHashCode();
    }

    protected PropertiedObjectImpl(PropertiedObjectImpl original) {
        Assertion.isNotNull((Object)original, (String)"The original PropertiedObjectImpl reference may not be null");
        this.properties = new HashMap(original.properties);
        this.unmodifiablePropertyDefns = original.unmodifiablePropertyDefns;
        this.updateHashCode();
    }

    protected final void updateHashCode() {
        this.computeHashCode();
    }

    protected int computeHashCode() {
        int result = 1;
        HashCodeUtil.hashCode((int)result, (Object)this.properties);
        HashCodeUtil.expHashCode((int)result, (List)this.unmodifiablePropertyDefns);
        return result;
    }

    public int compareTo(Object obj) {
        PropertiedObjectImpl that = (PropertiedObjectImpl)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0007", new Object[]{this.getClass().getName()}));
        }
        return this.compare(that);
    }

    protected int compare(PropertiedObjectImpl that) {
        int diff = this.properties.size() - that.properties.size();
        if (diff != 0) {
            return diff;
        }
        Map.Entry entry2 = null;
        Object thatValue = null;
        Object thisValue = null;
        for (Map.Entry entry2 : this.properties.entrySet()) {
            thisValue = entry2.getValue();
            thatValue = that.properties.get(entry2.getKey());
            if (thisValue != null) {
                if (thatValue == null) {
                    return 1;
                }
                diff = thisValue instanceof Comparable ? ((Comparable)thisValue).compareTo(thatValue) : thisValue.toString().compareTo(thatValue.toString());
                if (diff == 0) continue;
                return diff;
            }
            if (thatValue == null) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            PropertiedObjectImpl that = (PropertiedObjectImpl)obj;
            return this.compare(that) == 0;
        }
        return false;
    }

    public Object clone() {
        return new PropertiedObjectImpl(this);
    }

    public List getPropertyDefinitions() {
        return this.unmodifiablePropertyDefns;
    }

    protected synchronized void setPropertyDefinitions(List propertyDefns) {
        ArgCheck.isNotNull((Object)propertyDefns);
        this.unmodifiablePropertyDefns = propertyDefns;
        this.updateHashCode();
    }

    public synchronized Object getValue(PropertyDefinition def) {
        Object result = this.properties.get(def);
        if (result == null && def.hasDefaultValue()) {
            result = def.getDefaultValue();
        }
        if (result == null) {
            return result;
        }
        if (result instanceof Collection && def.getPropertyType() != PropertyType.LIST) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.019.0021", new Object[]{def.getPropertyType().getDisplayName()}));
        }
        if (result instanceof Set && def.getPropertyType() != PropertyType.SET) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.019.0022", new Object[]{def.getPropertyType().getDisplayName()}));
        }
        if (def.getMultiplicity().getMaximum() > 1 && !(result instanceof Object[])) {
            result = new Object[]{result};
        }
        return result;
    }

    public boolean isValidValue(PropertyDefinition def, Object value) {
        ArgCheck.isNotNull((Object)def);
        if (value == null) {
            return def.getMultiplicity().getMinimum() == 0;
        }
        if (value instanceof Collection && def.getPropertyType() != PropertyType.LIST) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.019.0021", new Object[]{def.getPropertyType().getDisplayName()}));
        }
        if (value instanceof Set && def.getPropertyType() != PropertyType.SET) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.019.0022", new Object[]{def.getPropertyType().getDisplayName()}));
        }
        if (def.getMultiplicity().getMaximum() > 1) {
            Assertion.assertTrue((boolean)(value instanceof Object[]), (String)("The property definition " + def.getDisplayName() + " is multi-valued, so the property value must be an Object[]"));
        }
        return def.getPropertyType().isValidValue(value);
    }

    public synchronized void setValue(PropertyDefinition def, Object value) {
        Assertion.contains((Collection)this.unmodifiablePropertyDefns, (Object)def, (String)"The specified PropertyDefinition is not known or is not defined for this instance");
        if (value instanceof Collection && def.getPropertyType() != PropertyType.LIST) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.019.0021", new Object[]{def.getPropertyType().getDisplayName()}));
        }
        if (value instanceof Set && def.getPropertyType() != PropertyType.SET) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.019.0022", new Object[]{def.getPropertyType().getDisplayName()}));
        }
        if (value != null && def.getMultiplicity().getMaximum() > 1) {
            Assertion.assertTrue((boolean)(value instanceof Object[]), (String)("The property definition " + def.getDisplayName() + " is multi-valued, so the property value must be an Object[]"));
        }
        this.properties.put(def, value);
        this.updateHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream in) throws IOException {
        ArgCheck.isNotNull((Object)in);
        Properties props = new Properties();
        props.load(in);
        PropertiedObjectImpl propertiedObjectImpl = this;
        synchronized (propertiedObjectImpl) {
            this.properties.clear();
            PropertyDefinition defn2 = null;
            HashMap<String, PropertyDefinition> propDefnsByName = new HashMap<String, PropertyDefinition>();
            for (PropertyDefinition defn2 : this.unmodifiablePropertyDefns) {
                propDefnsByName.put(defn2.getName(), defn2);
            }
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = enumeration.nextElement().toString();
                String value = props.getProperty(name);
                defn2 = (PropertyDefinition)propDefnsByName.get(name);
                if (defn2 == null) continue;
                this.properties.put(defn2, value);
            }
        }
        this.updateHashCode();
    }

    public void store(OutputStream out, String header) throws IOException {
        ArgCheck.isNotNull((Object)out);
        Properties props = this.getPropertiesObject();
        props.store(out, header);
    }

    protected synchronized Properties getPropertiesObject() {
        Properties result = new Properties();
        Map.Entry entry2 = null;
        Object value = null;
        PropertyDefinition defn = null;
        for (Map.Entry entry2 : this.properties.entrySet()) {
            defn = (PropertyDefinition)entry2.getKey();
            value = entry2.getValue();
            result.put(defn.getName(), value.toString());
        }
        return result;
    }

    public boolean containsAllRequiredValues() {
        Map.Entry entry2 = null;
        Object value = null;
        PropertyDefinition defn = null;
        for (Map.Entry entry2 : this.properties.entrySet()) {
            defn = (PropertyDefinition)entry2.getKey();
            if (this.isValidValue(defn, value = entry2.getValue())) continue;
            return false;
        }
        return true;
    }
}

