/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertiedObjectEditorImpl;
import com.metamatrix.common.object.PropertiedObjectsEditor;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransactionFactory;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class PropertiedObjectsEditorImpl
extends PropertiedObjectEditorImpl
implements PropertiedObjectsEditor {
    private List objects = new LinkedList();

    public PropertiedObjectsEditorImpl(PropertyAccessPolicy policy, UserTransactionFactory txnFactory) {
        super(policy, txnFactory);
    }

    public PropertiedObjectsEditorImpl() {
    }

    public PropertiedObjectsEditorImpl(PropertyAccessPolicy policy) {
        super(policy);
    }

    public PropertiedObjectsEditorImpl(UserTransactionFactory txnFactory) {
        super(txnFactory);
    }

    @Override
    public List getObjects() {
        return this.objects;
    }

    @Override
    public void setObjects(List objs) {
        if (objs == null) {
            objs = new LinkedList();
        }
        this.objects = objs;
    }

    @Override
    public boolean hasObjects() {
        return this.objects.size() != 0;
    }

    @Override
    public List getSharedPropertyDefinitions() {
        int objSize = this.objects.size();
        if (objSize == 0) {
            return Collections.EMPTY_LIST;
        }
        List propDefns = this.getPropertyDefinitions((PropertiedObject)this.objects.get(0));
        if (objSize == 1) {
            return propDefns;
        }
        ArrayList sharedPropDefns = new ArrayList(7);
        ArrayList<List> propDefnsForObjects = new ArrayList<List>(objSize - 1);
        for (int i = 1; i < objSize; ++i) {
            propDefnsForObjects.add(this.getPropertyDefinitions((PropertiedObject)this.objects.get(i)));
        }
        ListIterator iter = propDefns.listIterator();
        while (iter.hasNext()) {
            boolean isShared = true;
            Object propDefn = iter.next();
            for (int j = 0; j < propDefnsForObjects.size(); ++j) {
                if (((List)propDefnsForObjects.get(j)).contains(propDefn)) continue;
                isShared = false;
                break;
            }
            if (!isShared) continue;
            sharedPropDefns.add(propDefn);
        }
        return Collections.unmodifiableList(sharedPropDefns);
    }

    @Override
    public List getValues(PropertyDefinition def) {
        ArgCheck.isNotNull((Object)def);
        if (this.objects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        ListIterator iter = this.objects.listIterator();
        while (iter.hasNext()) {
            PropertiedObject propObj = (PropertiedObject)iter.next();
            if (this.getPropertyDefinitions(propObj).contains(def)) {
                values.add(this.getValue(propObj, def));
                continue;
            }
            values.add(PropertiedObjectEditor.NO_VALUE);
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void setValues(PropertyDefinition def, List values) {
        ArgCheck.isNotNull((Object)def);
        Assertion.assertTrue((this.hasObjects() && values.size() == this.getObjects().size() ? 1 : 0) != 0, (String)"Must has objects and the size of objects must be the same as that of the values.");
        int s = this.objects.size();
        for (int i = 0; i < s; ++i) {
            PropertiedObject propObj = (PropertiedObject)this.objects.get(i);
            Object value = values.get(i);
            if (!this.getPropertyDefinitions(propObj).contains(def)) continue;
            this.setValue(propObj, def, value);
        }
    }

    @Override
    public Object getValue(int index, PropertyDefinition def) {
        ArgCheck.isNotNull((Object)def);
        PropertiedObject propObj = (PropertiedObject)this.objects.get(index);
        if (this.getPropertyDefinitions(propObj).contains(def)) {
            return this.getValue(propObj, def);
        }
        return PropertiedObjectEditor.NO_VALUE;
    }

    @Override
    public boolean isValidValue(int index, PropertyDefinition def, Object value) {
        ArgCheck.isNotNull((Object)def);
        PropertiedObject propObj = (PropertiedObject)this.objects.get(index);
        if (this.getPropertyDefinitions(propObj).contains(def)) {
            return this.isValidValue(propObj, def, value);
        }
        return false;
    }

    @Override
    public void setValue(int index, PropertyDefinition def, Object value) {
        ArgCheck.isNotNull((Object)def);
        PropertiedObject propObj = (PropertiedObject)this.objects.get(index);
        if (this.getPropertyDefinitions(propObj).contains(def)) {
            this.setValue(propObj, def, value);
        }
    }

    @Override
    public Object getValue(PropertyDefinition def) {
        List sharedPropDefns = this.getSharedPropertyDefinitions();
        if (this.hasObjects() && sharedPropDefns.contains(def)) {
            Object value = this.getValue(0, def);
            int s = this.objects.size();
            for (int i = 1; i < s; ++i) {
                Object nextValue = this.getValue(i, def);
                if (value.equals(nextValue)) continue;
                return PropertiedObjectsEditor.DIFFERENT_VALUES;
            }
            return value;
        }
        return PropertiedObjectsEditor.DIFFERENT_VALUES;
    }

    @Override
    public void setValue(PropertyDefinition def, Object value) {
        ArgCheck.isNotNull((Object)def);
        int s = this.objects.size();
        for (int i = 0; i < s; ++i) {
            PropertiedObject propObj = (PropertiedObject)this.objects.get(i);
            if (!this.getPropertyDefinitions(propObj).contains(def)) continue;
            this.setValue(propObj, def, value);
        }
    }
}

