/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.Multiplicity;
import com.metamatrix.common.object.ObjectDefinitionImpl;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PropertyDefinitionImpl
extends ObjectDefinitionImpl
implements PropertyDefinition {
    public static final List BOOLEAN_ALLOWED_VALUES = Collections.unmodifiableList(Arrays.asList(Boolean.FALSE.toString(), Boolean.TRUE.toString()));
    public static final PropertyType DEFAULT_TYPE = PropertyType.STRING;
    public static final String DEFAULT_DELIMITER = ",";
    public static final Object DEFAULT_VALUE = null;
    public static final boolean DEFAULT_IS_EXPERT = false;
    public static final boolean DEFAULT_IS_PREFERRED = false;
    public static final boolean DEFAULT_IS_HIDDEN = false;
    public static final boolean DEFAULT_IS_MASKED = false;
    public static final boolean DEFAULT_IS_CONSTRAINED = true;
    public static final boolean DEFAULT_IS_MODIFIABLE = true;
    public static final boolean DEFAULT_REQUIRES_RESTART = false;
    public static final String DEFAULT_MULTIPLICITY = "0..1";
    public static final String DEFAULT_DEFAULT_VALUE = null;
    public static final String DEFAULT_DISPLAY_NAME = null;
    public static final String DEFAULT_SHORT_DESCRIPTION = null;
    private boolean modifiable = true;
    private boolean constrained = true;
    private boolean hidden = false;
    private boolean preferred = false;
    private boolean expert = false;
    private boolean masked = false;
    private boolean requiresRestart = false;
    private Object defaultValue = DEFAULT_VALUE;
    private List allowedValues = new ArrayList();
    private String valueDelimiter = ",";
    private PropertyType type = DEFAULT_TYPE;
    private Multiplicity multiplicity;

    public PropertyDefinitionImpl() {
        this.multiplicity = Multiplicity.getInstance();
    }

    public PropertyDefinitionImpl(String name, PropertyType type, Multiplicity multiplicity) {
        super(name);
        this.setPropertyType(type);
        this.setMultiplicity(multiplicity);
    }

    public PropertyDefinitionImpl(String name, String displayName, PropertyType type, Multiplicity multiplicity) {
        super(name, displayName);
        this.setPropertyType(type);
        this.setMultiplicity(multiplicity);
    }

    public PropertyDefinitionImpl(String name, String displayName, PropertyType type, Multiplicity multiplicity, String shortDescription, Object defaultValue, List allowedValues, String valueDelimiter, boolean isHidden, boolean isPreferred, boolean isExpert) {
        super(name, displayName);
        this.setPropertyType(type);
        this.setMultiplicity(multiplicity);
        this.setShortDescription(shortDescription);
        this.setDefaultValue(defaultValue);
        this.setAllowedValues(allowedValues);
        this.setHidden(isHidden);
        this.setPreferred(isPreferred);
        this.setExpert(isExpert);
        this.setValueDelimiter(valueDelimiter);
    }

    public PropertyDefinitionImpl(String name, String displayName, PropertyType type, Multiplicity multiplicity, String shortDescription, Object defaultValue, List allowedValues, String valueDelimiter, boolean isHidden, boolean isPreferred, boolean isExpert, boolean isModifiable) {
        this(name, displayName, type, multiplicity, shortDescription, defaultValue, allowedValues, valueDelimiter, isHidden, isPreferred, isExpert);
        this.setModifiable(isModifiable);
    }

    public PropertyDefinitionImpl(PropertyDefinition defn) {
        super(defn);
        this.setDefaultValue(defn.getDefaultValue());
        this.setPropertyType(defn.getPropertyType());
        this.setMultiplicity(defn.getMultiplicity());
        this.setAllowedValues(defn.getAllowedValues());
        this.setHidden(defn.isHidden());
        this.setPreferred(defn.isPreferred());
        this.setExpert(defn.isExpert());
        this.setValueDelimiter(defn.getValueDelimiter());
        this.setModifiable(defn.isModifiable());
        this.setMasked(defn.isMasked());
        this.setConstrainedToAllowedValues(defn.isConstrainedToAllowedValues());
        this.setRequiresRestart(defn.getRequiresRestart());
    }

    @Override
    public boolean getRequiresRestart() {
        return this.requiresRestart;
    }

    public void setRequiresRestart(boolean flag) {
        this.requiresRestart = flag;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean flag) {
        this.modifiable = flag;
    }

    @Override
    public boolean isConstrainedToAllowedValues() {
        return this.constrained;
    }

    public void setConstrainedToAllowedValues(boolean flag) {
        this.constrained = flag;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    @Override
    public boolean isMasked() {
        return this.masked;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }

    @Override
    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    @Override
    public PropertyType getPropertyType() {
        return this.type;
    }

    public void setPropertyType(PropertyType type) {
        this.type = type != null ? type : DEFAULT_TYPE;
    }

    @Override
    public Object getDefaultValue() {
        if (this.multiplicity != null && this.multiplicity.getMaximum() > 1) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = PropertyType.BOOLEAN.getClassName().equals(this.getPropertyType().getClassName()) && defaultValue instanceof String ? Boolean.valueOf((String)defaultValue) : defaultValue;
    }

    @Override
    public List getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List allowedValues) {
        this.allowedValues = allowedValues != null ? allowedValues : new ArrayList();
        this.allowedValues = Collections.unmodifiableList(this.allowedValues);
    }

    @Override
    public String getValueDelimiter() {
        return this.valueDelimiter;
    }

    public void setValueDelimiter(String delim) {
        this.valueDelimiter = delim;
    }

    @Override
    public boolean hasDefaultValue() {
        if (this.multiplicity != null && this.multiplicity.getMaximum() > 1) {
            return false;
        }
        return this.defaultValue != null;
    }

    @Override
    public boolean hasAllowedValues() {
        return !this.allowedValues.isEmpty();
    }

    @Override
    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(Multiplicity multiplicity) {
        this.multiplicity = multiplicity == null ? Multiplicity.getInstance() : multiplicity;
    }

    @Override
    public boolean isRequired() {
        return !this.multiplicity.isIncluded(0);
    }

    @Override
    public Object clone() {
        return new PropertyDefinitionImpl(this);
    }

    @Override
    public int compareTo(Object obj) {
        PropertyDefinitionImpl that = (PropertyDefinitionImpl)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0007", new Object[]{this.getClass().getName()}));
        }
        return this.getName().compareTo(that.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            PropertyDefinitionImpl that = (PropertyDefinitionImpl)obj;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    @Override
    public String getValuesAsString(Object[] values) {
        ArgCheck.isNotNull((Object)values);
        return this.getValuesAsString(values, this.getValueDelimiter());
    }

    @Override
    public String getValuesAsString(Object[] values, String delim) {
        ArgCheck.isNotNull((Object)values);
        if (delim == null) {
            delim = this.getValueDelimiter();
        }
        if (delim == null) {
            delim = DEFAULT_DELIMITER;
        }
        return StringUtil.join(Arrays.asList(values), (String)delim);
    }

    @Override
    public Object[] getValuesFromString(String stringifiedValues) {
        return this.getValuesFromString(stringifiedValues, this.getValueDelimiter());
    }

    @Override
    public Object[] getValuesFromString(String stringifiedValues, String delim) {
        if (stringifiedValues == null || stringifiedValues.length() == 0) {
            return new Object[0];
        }
        if (delim == null) {
            delim = this.getValueDelimiter();
        }
        if (delim == null) {
            delim = DEFAULT_DELIMITER;
        }
        List result = StringUtil.getTokens((String)stringifiedValues, (String)delim);
        return result.toArray();
    }
}

