/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.object.Multiplicity;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyTypeValidator;
import com.metamatrix.common.object.StandardPropertyTypeValidator;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.core.id.ObjectID;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PropertyType
implements Comparable,
Serializable {
    private static final long serialVersionUID = -740884659902823711L;
    static final String STRING_NAME = "String";
    static final String INTEGER_NAME = "Integer";
    static final String LONG_NAME = "Long";
    static final String FLOAT_NAME = "Float";
    static final String DOUBLE_NAME = "Double";
    static final String BYTE_NAME = "Byte";
    static final String SHORT_NAME = "Short";
    static final String BOOLEAN_NAME = "Boolean";
    static final String TIME_NAME = "Time";
    static final String DATE_NAME = "Date";
    static final String TIMESTAMP_NAME = "Timestamp";
    static final String LIST_NAME = "List";
    static final String SET_NAME = "Set";
    static final String URL_NAME = "URL";
    static final String URI_NAME = "URI";
    static final String HOSTNAME_NAME = "Hostname";
    static final String FILE_NAME = "File";
    static final String OBJECT_ID_NAME = "ObjectID";
    static final String PROPERTIED_OBJECT_NAME = "PropertiedObject";
    static final String MULTIPLICITY_NAME = "Multiplicity";
    static final String PASSWORD_NAME = "Password";
    static final String DESCRIPTOR_NAME = "ResourceDescriptor";
    static final String OBJECT_REFERENCE_NAME = "ObjectReference";
    static final String DATA_TYPE_NAME = "DataType";
    static final String UNBOUNDED_INTEGER_NAME = "UnboundedInteger";
    static final String REG_EXPRESSION_NAME = "RegularExpression";
    static final Class PASSWORD_CLASS = new byte[1].getClass();
    public static final PropertyType STRING = new PropertyType(101, "String", String.class.getName());
    public static final PropertyType INTEGER = new PropertyType(102, "Integer", Integer.class.getName());
    public static final PropertyType LONG = new PropertyType(103, "Long", Long.class.getName());
    public static final PropertyType FLOAT = new PropertyType(104, "Float", Float.class.getName());
    public static final PropertyType DOUBLE = new PropertyType(105, "Double", Double.class.getName());
    public static final PropertyType BYTE = new PropertyType(106, "Byte", Byte.class.getName());
    public static final PropertyType SHORT = new PropertyType(107, "Short", Short.class.getName());
    public static final PropertyType BOOLEAN = new PropertyType(108, "Boolean", Boolean.class.getName());
    public static final PropertyType TIME = new PropertyType(109, "Time", Time.class.getName());
    public static final PropertyType DATE = new PropertyType(110, "Date", Date.class.getName());
    public static final PropertyType TIMESTAMP = new PropertyType(111, "Timestamp", Timestamp.class.getName());
    public static final PropertyType LIST = new PropertyType(112, "List", List.class.getName());
    public static final PropertyType SET = new PropertyType(113, "Set", Set.class.getName());
    public static final PropertyType URL = new PropertyType(114, "URL", URL.class.getName());
    public static final PropertyType HOSTNAME = new PropertyType(115, "Hostname", InetAddress.class.getName());
    public static final PropertyType FILE = new PropertyType(116, "File", DirectoryEntry.class.getName());
    public static final PropertyType OBJECT_ID = new PropertyType(117, "ObjectID", ObjectID.class.getName());
    public static final PropertyType MULTIPLICITY = new PropertyType(118, "Multiplicity", Multiplicity.class.getName());
    public static final PropertyType PASSWORD = new PropertyType(119, "Password", PASSWORD_CLASS.getName());
    public static final PropertyType PROPERTIED_OBJECT = new PropertyType(120, "PropertiedObject", PropertiedObject.class.getName());
    public static final PropertyType DESCRIPTOR = new PropertyType(121, "ResourceDescriptor", PropertiedObject.class.getName());
    public static final PropertyType OBJECT_REFERENCE = new PropertyType(122, "ObjectReference", Object.class.getName());
    public static final PropertyType DATA_TYPE = new PropertyType(123, "DataType", Object.class.getName());
    public static final PropertyType UNBOUNDED_INTEGER = new PropertyType(124, "UnboundedInteger", String.class.getName());
    public static final PropertyType REG_EXPRESSION = new PropertyType(125, "RegularExpression", String.class.getName());
    public static final PropertyType URI = new PropertyType(126, "URI", String.class.getName());
    public static final String UNBOUNDED_INTEGER_KEYWORD = "unbounded";
    private static Map BY_VALUE = new HashMap();
    private static Map BY_NAME = new HashMap();
    private static Map BY_CLASSNAME = new HashMap();
    private int value;
    private String displayName;
    private String className;
    private PropertyTypeValidator validator;

    private static void add(PropertyType propType) {
        BY_VALUE.put(new Integer(propType.hashCode()), propType);
        BY_NAME.put(propType.getDisplayName(), propType);
        BY_CLASSNAME.put(propType.getClassName(), propType);
    }

    public static PropertyType getInstance(int value) {
        return (PropertyType)BY_VALUE.get(new Integer(value));
    }

    public static PropertyType getInstance(String displayName) {
        return (PropertyType)BY_NAME.get(displayName);
    }

    public static PropertyType getInstanceByClassName(String className) {
        return (PropertyType)BY_CLASSNAME.get(className);
    }

    private PropertyType(int value, String displayName, String className) {
        this.value = value;
        this.displayName = displayName;
        this.className = className;
        this.validator = StandardPropertyTypeValidator.lookup(displayName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getClassName() {
        return this.className;
    }

    public int compareTo(Object obj) {
        PropertyType that = (PropertyType)obj;
        if (obj == null) {
            throw new IllegalArgumentException("Attempt to compare null");
        }
        return this.value - that.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyType) {
            PropertyType that = (PropertyType)obj;
            return this.value == that.value;
        }
        return false;
    }

    public final int hashCode() {
        return this.value;
    }

    public final String toString() {
        return Integer.toString(this.value);
    }

    public boolean isValidValue(Object value) {
        if (this.validator != null) {
            return this.validator.isValidValue(value);
        }
        return true;
    }

    static {
        PropertyType.add(STRING);
        PropertyType.add(INTEGER);
        PropertyType.add(LONG);
        PropertyType.add(FLOAT);
        PropertyType.add(DOUBLE);
        PropertyType.add(BYTE);
        PropertyType.add(SHORT);
        PropertyType.add(BOOLEAN);
        PropertyType.add(TIME);
        PropertyType.add(DATE);
        PropertyType.add(TIMESTAMP);
        PropertyType.add(LIST);
        PropertyType.add(SET);
        PropertyType.add(URL);
        PropertyType.add(URI);
        PropertyType.add(HOSTNAME);
        PropertyType.add(FILE);
        PropertyType.add(OBJECT_ID);
        PropertyType.add(MULTIPLICITY);
        PropertyType.add(PASSWORD);
        PropertyType.add(PROPERTIED_OBJECT);
        PropertyType.add(DESCRIPTOR);
        PropertyType.add(OBJECT_REFERENCE);
        PropertyType.add(DATA_TYPE);
        PropertyType.add(UNBOUNDED_INTEGER);
        PropertyType.add(REG_EXPRESSION);
    }
}

