/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.queue;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.core.util.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerPoolFactory {
    public static WorkerPool newWorkerPool(String name, int numThreads, long keepAlive) {
        return WorkerPoolFactory.newWorkerPool(name, numThreads, keepAlive, true);
    }

    public static WorkerPool newWorkerPool(String name, int numThreads, long keepAlive, boolean preferExistingThreads) {
        if (preferExistingThreads && numThreads > 1) {
            final ThreadReuseLinkedBlockingQueue queue = new ThreadReuseLinkedBlockingQueue();
            StatsCapturingThreadPoolExecutor executor = new StatsCapturingThreadPoolExecutor(0, numThreads, keepAlive, TimeUnit.MILLISECONDS, (BlockingQueue)queue, (ThreadFactory)((Object)new DefaultThreadFactory(name))){

                @Override
                public void execute(Runnable arg0) {
                    if (this.isShutdown()) {
                        throw new RejectedExecutionException();
                    }
                    super.execute(arg0);
                }
            };
            queue.setExecutor(executor);
            executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable arg0, ThreadPoolExecutor arg1) {
                    try {
                        queue.add(arg0);
                    }
                    catch (IllegalStateException e) {
                        throw new RejectedExecutionException(e);
                    }
                }
            });
            return new ExecutorWorkerPool(name, executor);
        }
        StatsCapturingThreadPoolExecutor executor = new StatsCapturingThreadPoolExecutor(numThreads, numThreads, keepAlive, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)((Object)new DefaultThreadFactory(name)));
        executor.allowCoreThreadTimeOut(true);
        return new ExecutorWorkerPool(name, executor);
    }

    static class ExecutorWorkerPool
    implements WorkerPool {
        private String name;
        private StatsCapturingThreadPoolExecutor executor;

        public ExecutorWorkerPool(String name, StatsCapturingThreadPoolExecutor executor) {
            this.name = name;
            this.executor = executor;
        }

        @Override
        public void execute(Runnable r) {
            this.executor.execute(r);
        }

        @Override
        public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            this.executor.awaitTermination(timeout, unit);
        }

        @Override
        public WorkerPoolStats getStats() {
            WorkerPoolStats stats = new WorkerPoolStats();
            stats.name = this.name;
            stats.queued = this.executor.getQueue().size();
            stats.threads = this.executor.getPoolSize();
            stats.activeThreads = this.executor.getActiveCount();
            stats.totalSubmitted = this.executor.getSubmittedCount();
            stats.highestActiveThreads = this.executor.getLargestPoolSize();
            stats.totalCompleted = this.executor.getCompletedCount();
            return stats;
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public void shutdown() {
            this.executor.shutdown();
        }

        @Override
        public boolean hasWork() {
            return this.executor.getSubmittedCount() - this.executor.getCompletedCount() > 0 && !this.executor.isTerminated();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }
    }

    public static class DefaultThreadFactory
    extends NamedThreadFactory {
        public DefaultThreadFactory(String name) {
            super(name);
        }

        public Thread newThread(Runnable r) {
            Thread result = super.newThread(r);
            if (LogManager.isMessageToBeRecorded("RESOURCE_POOLING", 6)) {
                LogManager.logTrace("RESOURCE_POOLING", CommonPlugin.Util.getString("WorkerPool.New_thread", new Object[]{result.getName()}));
            }
            return result;
        }
    }

    static class StatsCapturingThreadPoolExecutor
    extends ThreadPoolExecutor {
        private AtomicInteger activeCount = new AtomicInteger(0);
        private AtomicInteger submittedCount = new AtomicInteger(0);
        private AtomicInteger completedCount = new AtomicInteger(0);

        public StatsCapturingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            this.activeCount.getAndIncrement();
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null) {
                LogManager.logError("RESOURCE_POOLING", t, CommonPlugin.Util.getString("WorkerPool.uncaughtException"));
            }
            this.activeCount.getAndDecrement();
            this.completedCount.getAndIncrement();
        }

        @Override
        public void execute(Runnable command) {
            this.submittedCount.getAndIncrement();
            super.execute(command);
        }

        @Override
        public int getActiveCount() {
            return this.activeCount.get();
        }

        public int getSubmittedCount() {
            return this.submittedCount.get();
        }

        public int getCompletedCount() {
            return this.completedCount.get();
        }
    }

    static final class ThreadReuseLinkedBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private StatsCapturingThreadPoolExecutor executor;

        ThreadReuseLinkedBlockingQueue() {
        }

        void setExecutor(StatsCapturingThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public boolean offer(Runnable o) {
            if (this.executor.getPoolSize() + this.executor.getCompletedCount() >= this.executor.getSubmittedCount()) {
                return super.offer(o);
            }
            return false;
        }

        @Override
        public boolean add(Runnable arg0) {
            if (super.offer(arg0)) {
                return true;
            }
            throw new IllegalStateException("Queue full");
        }
    }
}

