/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.PassThroughTreeNodeFilter;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeFilter;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeNodePathComparator;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.core.util.ArgCheck;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTreeView
implements TreeView {
    private static TreeNodeFilter DEFAULT_FILTER = new PassThroughTreeNodeFilter();
    private static Comparator DEFAULT_COMPARATOR = new TreeNodePathComparator();
    private TreeNodeFilter filter = DEFAULT_FILTER;
    private Comparator comparator = DEFAULT_COMPARATOR;

    @Override
    public void setFilter(TreeNodeFilter filter) {
        this.filter = filter == null ? DEFAULT_FILTER : filter;
    }

    @Override
    public TreeNodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setComparator(Comparator comparator) {
        this.comparator = comparator == null ? DEFAULT_COMPARATOR : comparator;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public abstract List getPropertyDefinitions();

    @Override
    public abstract List getRoots();

    @Override
    public boolean isRoot(TreeNode node) {
        if (node == null) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0001"));
        }
        return this.getRoots().contains(node);
    }

    @Override
    public abstract boolean isHidden(TreeNode var1);

    @Override
    public abstract boolean isMarked(TreeNode var1);

    @Override
    public abstract TreeNode getHome();

    @Override
    public abstract String getPath(TreeNode var1);

    @Override
    public abstract char getSeparatorChar();

    @Override
    public abstract String getSeparator();

    @Override
    public abstract TreeNode getParent(TreeNode var1);

    @Override
    public abstract List getChildren(TreeNode var1);

    @Override
    public abstract boolean isParentOf(TreeNode var1, TreeNode var2);

    @Override
    public abstract boolean isAncestorOf(TreeNode var1, TreeNode var2);

    @Override
    public abstract PropertiedObjectEditor getPropertiedObjectEditor();

    @Override
    public abstract TreeNodeEditor getTreeNodeEditor();

    @Override
    public abstract UserTransaction createReadTransaction();

    @Override
    public abstract UserTransaction createWriteTransaction();

    @Override
    public abstract UserTransaction createWriteTransaction(Object var1);

    @Override
    public Iterator iterator() {
        return new TreeNodeIterator(this.getRoots(), (TreeView)this);
    }

    @Override
    public Iterator iterator(TreeNode startingPoint) {
        ArgCheck.isNotNull((Object)startingPoint);
        return new TreeNodeIterator(startingPoint, (TreeView)this);
    }
}

