/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.AbstractTreeView;
import com.metamatrix.common.tree.ChildRules;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuledTreeViewImpl
extends AbstractTreeView
implements TreeView {
    private List roots = null;
    private TreeView tree = null;
    private ChildRules rules = null;

    public RuledTreeViewImpl(TreeView tree, ChildRules rules) {
        ArgCheck.isNotNull((Object)tree);
        ArgCheck.isNotNull((Object)rules);
        this.tree = tree;
        this.rules = rules;
        this.roots = null;
    }

    public RuledTreeViewImpl(TreeView tree, TreeNode root, ChildRules rules) {
        ArgCheck.isNotNull((Object)tree);
        ArgCheck.isNotNull((Object)tree);
        ArgCheck.isNotNull((Object)rules);
        boolean found = false;
        for (TreeNode treeRoot : tree.getRoots()) {
            if (!tree.isAncestorOf(treeRoot, root)) continue;
            found = true;
            break;
        }
        Assertion.assertTrue((boolean)found, (String)"The TreeNode must reference a node contained by the TreeView");
        this.tree = tree;
        this.rules = rules;
        this.roots = new ArrayList(1);
        this.roots.add(root);
    }

    protected TreeView getTreeView() {
        return this.tree;
    }

    @Override
    public PropertiedObjectEditor getPropertiedObjectEditor() {
        return this.tree.getPropertiedObjectEditor();
    }

    @Override
    public List getPropertyDefinitions() {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0004"));
    }

    @Override
    public List getRoots() {
        List results;
        List theRoots = this.roots;
        if (theRoots == null) {
            theRoots = this.tree.getRoots();
        }
        if ((results = this.getUnhiddenNodes(theRoots)).size() != 0) {
            return results;
        }
        ArrayList modResults = new ArrayList(results);
        Iterator iter = theRoots.iterator();
        while (iter.hasNext()) {
            modResults.addAll(this.tree.getChildren((TreeNode)iter.next()));
        }
        return this.getUnhiddenNodes(modResults);
    }

    protected void setViewRoots(List roots) {
        this.roots = roots == null || roots.isEmpty() ? null : roots;
    }

    protected List getUnhiddenNodes(List nodes) {
        if (nodes == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TreeNode> removeNodes = null;
        for (TreeNode node : nodes) {
            if (!this.isNodeHidden(node)) continue;
            if (removeNodes == null) {
                removeNodes = new ArrayList<TreeNode>(nodes.size());
            }
            removeNodes.add(node);
        }
        if (removeNodes == null) {
            return nodes;
        }
        ArrayList results = new ArrayList(nodes.size());
        results.addAll(nodes);
        results.removeAll(removeNodes);
        return Collections.unmodifiableList(results);
    }

    protected Set getUnhiddenNodes(Set nodes) {
        if (nodes == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<TreeNode> removeNodes = null;
        for (TreeNode node : nodes) {
            if (!this.isNodeHidden(node)) continue;
            if (removeNodes == null) {
                removeNodes = new ArrayList<TreeNode>(nodes.size());
            }
            removeNodes.add(node);
        }
        if (removeNodes == null) {
            return nodes;
        }
        HashSet results = new HashSet(7);
        results.addAll(nodes);
        results.removeAll(removeNodes);
        return Collections.unmodifiableSet(results);
    }

    @Override
    public boolean isHidden(TreeNode node) {
        if (node == null) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0001"));
        }
        return this.isNodeHidden(node);
    }

    protected boolean isNodeHidden(TreeNode node) {
        if (this.rules.isHidden(node.getType())) {
            return true;
        }
        return !super.getFilter().accept(node);
    }

    @Override
    public boolean isMarked(TreeNode node) {
        ArgCheck.isNotNull((Object)node);
        return this.tree.isMarked(node);
    }

    @Override
    public void setMarked(TreeNode node, boolean markedState) {
        ArgCheck.isNotNull((Object)node);
        this.tree.setMarked(node, markedState);
    }

    @Override
    public Set getMarked() {
        return this.getUnhiddenNodes(this.tree.getMarked());
    }

    @Override
    public TreeNode getHome() {
        return this.tree.getHome();
    }

    @Override
    public String getPath(TreeNode node) {
        return this.tree.getPath(node);
    }

    @Override
    public char getSeparatorChar() {
        return this.tree.getSeparatorChar();
    }

    @Override
    public String getSeparator() {
        return this.tree.getSeparator();
    }

    @Override
    public TreeNode getParent(TreeNode node) {
        if (this.roots != null && this.roots.contains(node)) {
            return null;
        }
        return this.tree.getParent(node);
    }

    @Override
    public boolean allowsChildren(TreeNode entry) {
        ArgCheck.isNotNull((Object)entry);
        return this.rules.getAllowsChildren(entry.getType());
    }

    @Override
    public boolean allowsChild(TreeNode parent, TreeNode potentialChild) {
        ArgCheck.isNotNull((Object)parent);
        ArgCheck.isNotNull((Object)potentialChild);
        return this.rules.getAllowsChild(parent.getType(), potentialChild.getType());
    }

    @Override
    public List getChildren(TreeNode parent) {
        ArgCheck.isNotNull((Object)parent);
        return this.getUnhiddenNodes(this.tree.getChildren(parent));
    }

    @Override
    public boolean isParentOf(TreeNode parent, TreeNode child) {
        ArgCheck.isNotNull((Object)parent);
        ArgCheck.isNotNull((Object)child);
        if (this.roots != null && this.roots.contains(child)) {
            return false;
        }
        return this.tree.isParentOf(parent, child);
    }

    @Override
    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        ArgCheck.isNotNull((Object)ancestor);
        ArgCheck.isNotNull((Object)descendent);
        if (this.roots != null && this.roots.contains(descendent)) {
            return false;
        }
        return this.tree.isAncestorOf(ancestor, descendent);
    }

    @Override
    public TreeNodeEditor getTreeNodeEditor() {
        return this.tree.getTreeNodeEditor();
    }

    @Override
    public UserTransaction createReadTransaction() {
        return this.tree.createReadTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction() {
        return this.tree.createWriteTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction(Object source) {
        return this.tree.createWriteTransaction(source);
    }

    @Override
    public Iterator iterator() {
        return new TreeNodeIterator(this.getRoots(), (TreeView)this);
    }

    @Override
    public Iterator iterator(TreeNode startingPoint) {
        ArgCheck.isNotNull((Object)startingPoint);
        return new TreeNodeIterator(startingPoint, (TreeView)this);
    }

    protected ChildRules getChildRules() {
        return this.rules;
    }

    public void print(PrintStream stream) {
        if (stream == null) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0010"));
        }
        stream.println("ProxyTreeViewImpl");
        Iterator iter = this.getRoots().iterator();
        while (iter.hasNext()) {
            this.print((TreeNode)iter.next(), stream, "  ");
        }
    }

    private void print(TreeNode node, PrintStream stream, String leadingString) {
        if (this.isNodeHidden(node)) {
            return;
        }
        stream.println(leadingString + node.getName());
        Iterator iter = this.getChildren(node).iterator();
        while (iter.hasNext()) {
            this.print((TreeNode)iter.next(), stream, leadingString + "  ");
        }
    }
}

