/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.PassThroughTreeNodeFilter;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeFilter;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeNodePathComparator;
import com.metamatrix.common.tree.TreeNodeSource;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.common.tree.basic.BasicTreeNodeEditor;
import com.metamatrix.common.tree.basic.BasicTreeNodeSource;
import com.metamatrix.core.util.Assertion;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BasicTreeView
implements TreeView {
    private static TreeNodeFilter DEFAULT_FILTER = new PassThroughTreeNodeFilter();
    private static Comparator DEFAULT_COMPARATOR = new TreeNodePathComparator();
    private TreeNodeFilter filter = DEFAULT_FILTER;
    private Comparator comparator = DEFAULT_COMPARATOR;
    private BasicTreeNode root;
    private BasicTreeNodeSource source;
    private BasicTreeNodeEditor editor;
    private List unmodifiableRoot;
    private String delimiter;

    public BasicTreeView(TreeNode root, TreeNodeSource source) {
        Assertion.isNotNull((Object)source, (String)"The BasicTreeNodeSource reference may not be null");
        Assertion.assertTrue((boolean)(source instanceof BasicTreeNodeSource), (String)"The TreeNodeSource must be a BasicTreeNodeSource");
        this.root = this.assertBasicTreeNode(root);
        this.source = (BasicTreeNodeSource)source;
        ArrayList<BasicTreeNode> viewRoot = new ArrayList<BasicTreeNode>(1);
        viewRoot.add(this.root);
        this.unmodifiableRoot = Collections.unmodifiableList(viewRoot);
    }

    protected BasicTreeNode assertBasicTreeNode(TreeNode node) {
        Assertion.isNotNull((Object)node, (String)"The TreeNode reference may not be null");
        Assertion.assertTrue((boolean)(node instanceof BasicTreeNode), (String)"The referenced object is not an BasicTreeNode");
        BasicTreeNode basicNode = (BasicTreeNode)node;
        return basicNode;
    }

    @Override
    public void setFilter(TreeNodeFilter filter) {
        this.filter = filter == null ? DEFAULT_FILTER : filter;
    }

    @Override
    public TreeNodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setComparator(Comparator comparator) {
        this.comparator = comparator == null ? DEFAULT_COMPARATOR : comparator;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public Iterator iterator() {
        return new TreeNodeIterator(this.root, (TreeView)this);
    }

    @Override
    public Iterator iterator(TreeNode startingPoint) {
        Assertion.isNotNull((Object)startingPoint, (String)"The TreeNode reference may not be null");
        return new TreeNodeIterator(startingPoint, (TreeView)this);
    }

    @Override
    public List getPropertyDefinitions() {
        return this.getTreeNodeEditor().getPropertyDefinitions(this.root);
    }

    @Override
    public List getRoots() {
        return this.unmodifiableRoot;
    }

    @Override
    public boolean isRoot(TreeNode node) {
        BasicTreeNode basicNode = this.assertBasicTreeNode(node);
        return this.getRoots().contains(basicNode);
    }

    @Override
    public boolean allowsChildren(TreeNode node) {
        return this.source.allowsChildren(node);
    }

    @Override
    public boolean allowsChild(TreeNode parent, TreeNode potentialChild) {
        return this.source.allowsChild(parent, potentialChild);
    }

    @Override
    public boolean isHidden(TreeNode node) {
        return false;
    }

    @Override
    public boolean isMarked(TreeNode node) {
        BasicTreeNode basicNode = this.assertBasicTreeNode(node);
        return basicNode.isMarked();
    }

    @Override
    public void setMarked(TreeNode node, boolean markedState) {
        BasicTreeNode basicNode = this.assertBasicTreeNode(node);
        basicNode.setMarked(markedState);
    }

    @Override
    public Set getMarked() {
        HashSet result = new HashSet();
        this.addMarkedNodesToSet(this.root, result);
        return Collections.unmodifiableSet(result);
    }

    private void addMarkedNodesToSet(BasicTreeNode parent, Set result) {
        if (parent.isMarked()) {
            result.add(parent);
        }
        BasicTreeNode child2 = null;
        for (BasicTreeNode child2 : parent.getChildren()) {
            this.addMarkedNodesToSet(child2, result);
        }
    }

    @Override
    public TreeNode getHome() {
        return this.root;
    }

    @Override
    public String getPath(TreeNode node) {
        BasicTreeNode basicNode = this.assertBasicTreeNode(node);
        if (this.delimiter != null) {
            return basicNode.getFullName(this.delimiter);
        }
        return basicNode.getFullName();
    }

    @Override
    public char getSeparatorChar() {
        if (this.delimiter != null) {
            return this.delimiter.charAt(0);
        }
        return this.root.getSeparatorChar();
    }

    @Override
    public String getSeparator() {
        if (this.delimiter != null) {
            return this.delimiter;
        }
        return this.root.getSeparator();
    }

    public void setSeparator(String delimiter) {
        if (delimiter == null) {
            this.delimiter = null;
            return;
        }
        Assertion.assertTrue((delimiter.length() == 1 ? 1 : 0) != 0, (String)"The delimiter string must be a single character");
        this.delimiter = delimiter;
    }

    @Override
    public TreeNode getParent(TreeNode node) {
        return this.source.getParent(node);
    }

    @Override
    public List getChildren(TreeNode parent) {
        return this.source.getChildren(parent);
    }

    @Override
    public boolean isParentOf(TreeNode parent, TreeNode child) {
        return this.source.isParentOf(parent, child);
    }

    public int getIndexOfChild(TreeNode child) {
        Assertion.isNotNull((Object)child, (String)"The TreeNode reference may not be null");
        BasicTreeNode childNode = this.assertBasicTreeNode(child);
        BasicTreeNode parentNode = childNode.getParent();
        if (parentNode != null) {
            return parentNode.getIndexOfChild(childNode);
        }
        if (child == this.getHome()) {
            return -1;
        }
        throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0029", new Object[]{childNode.getFullName(this.getSeparator())}));
    }

    @Override
    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        return this.source.isAncestorOf(ancestor, descendent);
    }

    @Override
    public PropertiedObjectEditor getPropertiedObjectEditor() {
        return this.getTreeNodeEditor();
    }

    @Override
    public TreeNodeEditor getTreeNodeEditor() {
        if (this.editor == null) {
            this.editor = (BasicTreeNodeEditor)this.source.createTreeNodeEditor();
        }
        return this.editor;
    }

    @Override
    public UserTransaction createReadTransaction() {
        return this.getTreeNodeEditor().createReadTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction() {
        return this.getTreeNodeEditor().createWriteTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction(Object source) {
        return this.getTreeNodeEditor().createWriteTransaction(source);
    }

    public Collection lookup(String path) {
        Assertion.isNotNull((Object)path, (String)"The path reference may not be null");
        Assertion.isNotZeroLength((String)path, (String)"The path may not be zero-length");
        if (this.root.getName().equals(path)) {
            ArrayList<BasicTreeNode> result = new ArrayList<BasicTreeNode>(1);
            result.add(this.root);
            return result;
        }
        String childPath = path;
        String rootPath = this.root.getName() + this.getSeparator();
        if (path.startsWith(rootPath)) {
            childPath = path.substring(rootPath.length());
        }
        return this.root.getDecendant(childPath, this.getSeparator(), true);
    }

    protected TreeNode getRoot() {
        return this.root;
    }

    protected boolean setRoot(TreeNode root) {
        Assertion.isNotNull((Object)root, (String)"The BasicTreeNodeSource reference may not be null");
        Assertion.assertTrue((boolean)(root instanceof BasicTreeNodeSource), (String)"The TreeNodeSource must be a BasicTreeNodeSource");
        this.root = this.assertBasicTreeNode(root);
        return true;
    }

    protected TreeNodeSource getTreeNodeSource() {
        return this.source;
    }

    public void print(PrintStream stream) {
        this.print(stream, false);
    }

    public void print(PrintStream stream, boolean showMarked) {
        Assertion.isNotNull((Object)stream, (String)"The stream reference may not be null");
        stream.println("BasicTreeView");
        this.print(this.root, stream, "  ", showMarked);
    }

    private void print(BasicTreeNode node, PrintStream stream, String leadingString, boolean showMarked) {
        String markedString = "";
        if (showMarked) {
            markedString = node.isMarked() ? " <marked>" : " <unmarked>";
        }
        stream.println(leadingString + node.getName() + markedString);
        Iterator iter = this.getChildren(node).iterator();
        while (iter.hasNext()) {
            this.print((BasicTreeNode)iter.next(), stream, leadingString + "  ", showMarked);
        }
    }

    public static String collectionToString(Collection objs) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("{");
        int counter = 0;
        Iterator itr = objs.iterator();
        while (itr.hasNext()) {
            if (counter > 0) {
                sb.append(",");
            }
            sb.append(itr.next().toString());
            ++counter;
        }
        sb.append("}");
        return sb.toString();
    }
}

