/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.MultiplicityExpressionException;
import com.metamatrix.common.object.MultiplicityPool;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyDefinitionImpl;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.FileDefinition;
import com.metamatrix.common.tree.directory.FolderDefinition;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;

public class FileSystemEntry
implements DirectoryEntry {
    private static final DecimalFormat FORMATTER = new DecimalFormat("###,###,###,###,###");
    private boolean marked = false;
    private ObjectDefinition objectDefn;
    private static PropertyDefinitionImpl NAME_PROPERTY = null;
    private static PropertyDefinitionImpl SIZE_PROPERTY = null;
    private static PropertyDefinitionImpl LAST_MODIFIED_PROPERTY = null;
    private static PropertyDefinitionImpl READ_ONLY_PROPERTY = null;
    private static PropertyDefinitionImpl IS_HIDDEN_PROPERTY = null;
    private static List PROPERTY_DEFINITIONS = new ArrayList(5);
    private static final List UNMODIFIABLE_PROPERTY_DEFINITIONS = Collections.unmodifiableList(PROPERTY_DEFINITIONS);
    private File file;
    private Map properties = new HashMap(3);
    private long lastTimePropertiesLoaded;

    public FileSystemEntry(File file) throws IOException {
        if (PROPERTY_DEFINITIONS.size() == 0) {
            PROPERTY_DEFINITIONS.addAll(FileSystemEntry.getPropertyDefinitionList());
        }
        ArgCheck.isNotNull((Object)file);
        this.makeExist(file, TYPE_FILE);
        this.file = file;
    }

    protected FileSystemEntry(File file, ObjectDefinition type) throws IOException {
        if (PROPERTY_DEFINITIONS.size() == 0) {
            PROPERTY_DEFINITIONS.addAll(FileSystemEntry.getPropertyDefinitionList());
        }
        ArgCheck.isNotNull((Object)file);
        ArgCheck.isNotNull((Object)type);
        Assertion.assertTrue((type instanceof FileDefinition || type instanceof FolderDefinition ? 1 : 0) != 0, (String)"The ObjectDefinition must be of type FileDefinition or FolderDefinition");
        this.makeExist(file, type);
        this.file = file;
    }

    protected File getFile() {
        return this.file;
    }

    protected static List getPropertyDefinitionList() {
        ArrayList<PropertyDefinitionImpl> result = new ArrayList<PropertyDefinitionImpl>(3);
        result.add(NAME_PROPERTY);
        result.add(SIZE_PROPERTY);
        result.add(LAST_MODIFIED_PROPERTY);
        result.add(READ_ONLY_PROPERTY);
        result.add(IS_HIDDEN_PROPERTY);
        return result;
    }

    protected void setMarked(boolean marked) {
        this.marked = marked;
    }

    protected boolean isMarked() {
        return this.marked;
    }

    protected List getPropertyDefinitions() {
        return UNMODIFIABLE_PROPERTY_DEFINITIONS;
    }

    protected PropertyDefinition getNamePropertyDefinition() {
        return NAME_PROPERTY;
    }

    protected PropertyDefinition getDescriptionPropertyDefinition() {
        return null;
    }

    @Override
    public boolean canWrite() {
        if (this.file.exists()) {
            return this.file.canWrite();
        }
        return true;
    }

    @Override
    public boolean canRead() {
        if (this.file.exists()) {
            return this.file.canRead();
        }
        return true;
    }

    public String getParentFolderPath() {
        if (this.file == null) {
            return null;
        }
        if (this.isFolder()) {
            return this.file.getAbsolutePath();
        }
        return this.file.getParentFile().getAbsolutePath();
    }

    protected boolean isValidValue(PropertyDefinition definition, Object value) {
        ArgCheck.isNotNull((Object)definition);
        if (value == null && definition.getMultiplicity().getMinimum() != 0) {
            return false;
        }
        if (!definition.isModifiable()) {
            return true;
        }
        if (definition == NAME_PROPERTY) {
            File newFile = new File(this.file.getParentFile(), value.toString());
            return !newFile.exists();
        }
        if (definition == SIZE_PROPERTY) {
            return false;
        }
        if (definition == LAST_MODIFIED_PROPERTY) {
            if (!this.file.exists()) {
                return false;
            }
            long lastModified = this.file.lastModified();
            boolean result = false;
            try {
                long newValue = 0L;
                if (value instanceof Long) {
                    Long longValue = (Long)value;
                    newValue = longValue;
                } else if (value instanceof Date) {
                    Date dateValue = (Date)value;
                    newValue = dateValue.getTime();
                } else {
                    newValue = Long.parseLong(value.toString());
                }
                result = this.file.setLastModified(newValue);
                this.file.setLastModified(lastModified);
            }
            catch (Exception e) {
                // empty catch block
            }
            return result;
        }
        if (definition == READ_ONLY_PROPERTY) {
            boolean readOnlyValue = false;
            if (value instanceof Boolean) {
                Boolean roValue = (Boolean)value;
                readOnlyValue = roValue;
            } else {
                Boolean roValue = Boolean.valueOf(value.toString());
                readOnlyValue = roValue;
            }
            return readOnlyValue || this.file.canWrite();
        }
        return false;
    }

    boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getFullName() {
        return this.file.getPath();
    }

    @Override
    public String getNamespace() {
        return this.file.getAbsolutePath();
    }

    public char getAbsoluteSeparatorChar() {
        return File.separatorChar;
    }

    public String getAbsoluteSeparator() {
        return File.separator;
    }

    @Override
    public char getSeparatorChar() {
        return File.separatorChar;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public boolean loadPreview() {
        this.loadProperties();
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.canRead()) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0039", new Object[]{this.getFullName()}));
        }
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.canWrite()) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0040", new Object[]{this.getFullName()}));
        }
        return new FileOutputStream(this.file);
    }

    public boolean isFolder() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }

    @Override
    public ObjectDefinition getType() {
        return this.objectDefn;
    }

    protected boolean renameTo(String newName) {
        ArgCheck.isNotNull((Object)newName);
        ArgCheck.isNotZeroLength((String)newName);
        File newFile = new File(this.file.getParent(), newName);
        boolean result = this.file.renameTo(newFile);
        this.file = newFile;
        return result;
    }

    protected boolean move(FileSystemEntry newParent) {
        ArgCheck.isNotNull((Object)newParent);
        Assertion.assertTrue((boolean)newParent.exists(), (String)"The parent FileSystemEntry reference must represent an existing folder");
        Assertion.assertTrue((boolean)newParent.isFolder(), (String)"The parent FileSystemEntry reference must represent an existing folder");
        File newFile = new File(newParent.getFile(), this.file.getName());
        boolean success = this.file.renameTo(newFile);
        if (success) {
            this.file = newFile;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeNode copy(FileSystemEntry newParent) {
        ArgCheck.isNotNull((Object)newParent);
        File newFile = new File(newParent.getFile(), this.file.getName());
        if (!(this.file.exists() && this.file.isFile() && this.file.canRead())) {
            return null;
        }
        if (newFile.exists()) {
            return null;
        }
        if (!(newParent.exists() && newParent.isFolder() && newParent.canWrite())) {
            return null;
        }
        FileInputStream istream = null;
        FileOutputStream ostream = null;
        FileSystemEntry newEntry = null;
        try {
            int bytesRead;
            istream = (FileInputStream)this.getInputStream();
            ostream = new FileOutputStream(newFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, bytesRead);
            }
            newEntry = new FileSystemEntry(newFile, this.getType());
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            TreeNode treeNode = null;
            return treeNode;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException e) {}
            }
        }
        return newEntry;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.file.toURL();
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        FileSystemEntry entry = (FileSystemEntry)obj;
        return this.file.compareTo(entry.getFile());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof File) {
            return this.file.equals(obj);
        }
        if (!(obj instanceof FileSystemEntry)) {
            return false;
        }
        FileSystemEntry entry = (FileSystemEntry)obj;
        return this.file.equals(entry.getFile());
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public String toString() {
        return this.file.toString();
    }

    protected boolean loadProperties() {
        long lastModified = this.file.lastModified();
        this.properties.put(NAME_PROPERTY, this.getName());
        this.properties.put(SIZE_PROPERTY, this.getFileSizeValue(this.file.length()));
        this.properties.put(LAST_MODIFIED_PROPERTY, new Date(lastModified));
        this.properties.put(READ_ONLY_PROPERTY, !this.file.canWrite());
        this.properties.put(IS_HIDDEN_PROPERTY, !this.file.canRead());
        boolean changedSinceLastTime = false;
        if (this.lastTimePropertiesLoaded < lastModified) {
            this.lastTimePropertiesLoaded = System.currentTimeMillis();
            changedSinceLastTime = true;
        }
        return changedSinceLastTime;
    }

    private void loadProperty(PropertyDefinition defn) {
        ArgCheck.isNotNull((Object)defn);
        if (defn == NAME_PROPERTY) {
            this.properties.put(NAME_PROPERTY, this.getName());
        }
        if (defn == SIZE_PROPERTY) {
            this.properties.put(SIZE_PROPERTY, this.getFileSizeValue(this.file.length()));
        }
        if (defn == LAST_MODIFIED_PROPERTY) {
            this.properties.put(LAST_MODIFIED_PROPERTY, new Date(this.file.lastModified()));
        }
        if (defn == READ_ONLY_PROPERTY) {
            this.properties.put(READ_ONLY_PROPERTY, !this.file.canWrite());
        }
        if (defn == IS_HIDDEN_PROPERTY) {
            this.properties.put(IS_HIDDEN_PROPERTY, !this.file.canRead());
        }
    }

    private String getFileSizeValue(long length) {
        if (length <= 0L) {
            return "0KB";
        }
        if (length <= 1024L) {
            return "1KB";
        }
        double temp = 0.0;
        long result = 0L;
        temp = (float)length / 1024.0f;
        result = Math.round(temp);
        return FORMATTER.format(result) + "KB";
    }

    protected boolean hasChildWithName(String name) {
        File potentialChild = new File(this.file, name);
        return potentialChild.exists();
    }

    protected void setValue(PropertyDefinition def, Object value) {
        ArgCheck.isNotNull((Object)def);
        try {
            if (def == NAME_PROPERTY && this.renameTo(value.toString())) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.028.0044", new Object[]{this.getName(), value}));
            }
            if (def == SIZE_PROPERTY) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.028.0045"));
            }
            if (def == LAST_MODIFIED_PROPERTY) {
                if (!this.file.exists()) {
                    throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.028.0046"));
                }
                try {
                    long newValue = 0L;
                    if (value instanceof Long) {
                        Long longValue = (Long)value;
                        newValue = longValue;
                    } else if (value instanceof Date) {
                        Date dateValue = (Date)value;
                        newValue = dateValue.getTime();
                    } else {
                        newValue = Long.parseLong(value.toString());
                    }
                    if (this.file.setLastModified(newValue)) {
                        throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.028.0047", new Object[]{LAST_MODIFIED_PROPERTY.getDisplayName(), new Date(newValue)}));
                    }
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (def == READ_ONLY_PROPERTY) {
                boolean readOnlyValue = false;
                if (value instanceof Boolean) {
                    Boolean roValue = (Boolean)value;
                    readOnlyValue = roValue;
                } else {
                    Boolean roValue = Boolean.valueOf(value.toString());
                    readOnlyValue = roValue;
                }
                if (!readOnlyValue) {
                    if (!this.file.canWrite()) {
                        throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.028.0047", new Object[]{READ_ONLY_PROPERTY.getDisplayName(), readOnlyValue}));
                    }
                } else if (this.file.canWrite()) {
                    this.file.setReadOnly();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.028.0048", new Object[]{def.getDisplayName(), value.toString()}));
        }
        this.loadPreview();
    }

    protected Object getValue(PropertyDefinition def) {
        ArgCheck.isNotNull((Object)def);
        this.loadProperty(def);
        if (def == SIZE_PROPERTY && this.isFolder()) {
            return null;
        }
        return this.properties.get(def);
    }

    public boolean isReadOnly() {
        return !this.exists() || !this.canWrite();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public Date getLastModifiedDate() {
        Object result = this.properties.get(LAST_MODIFIED_PROPERTY);
        if (result == null) {
            this.properties.put(LAST_MODIFIED_PROPERTY, new Date(this.file.lastModified()));
        }
        return (Date)this.properties.get(LAST_MODIFIED_PROPERTY);
    }

    private boolean makeExist(File f, ObjectDefinition type) throws IOException {
        boolean result;
        block9: {
            ArgCheck.isNotNull((Object)f);
            ArgCheck.isNotNull((Object)type);
            if (f.exists()) {
                if (f.isDirectory() && type instanceof FolderDefinition) {
                    this.objectDefn = type;
                } else if (f.isFile() && type instanceof FileDefinition) {
                    this.objectDefn = type;
                } else {
                    throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0049", new Object[]{f.getPath()}));
                }
                return false;
            }
            result = false;
            try {
                if (type instanceof FolderDefinition) {
                    this.objectDefn = type;
                    result = f.mkdirs();
                    break block9;
                }
                if (type instanceof FileDefinition) {
                    this.objectDefn = type;
                    result = f.createNewFile();
                    break block9;
                }
                result = false;
                throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0050", new Object[]{type.getName()}));
            }
            catch (IOException e) {
                result = false;
                throw e;
            }
        }
        return result;
    }

    public boolean setLastModifiedDate(Date date) {
        if (!this.canWrite()) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0039", new Object[]{this.getFullName()}));
        }
        boolean result = this.file.setLastModified(date.getTime());
        if (result) {
            this.properties.put(LAST_MODIFIED_PROPERTY, date);
        }
        return result;
    }

    public ZipFile getZipFile() throws IOException {
        if (!this.canRead()) {
            throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0040", new Object[]{this.getFullName()}));
        }
        if (this.isFolder() || this.file.length() == 0L) {
            return null;
        }
        ZipFile result = null;
        try {
            result = new ZipFile(this.file);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }

    static {
        try {
            NAME_PROPERTY = new PropertyDefinitionImpl("name", PropertyType.STRING, MultiplicityPool.get("1"));
            NAME_PROPERTY.setDisplayName("Name");
            NAME_PROPERTY.setPluralDisplayName("Name");
            NAME_PROPERTY.setShortDisplayName("Name");
            NAME_PROPERTY.setShortDescription("The name of the file or directory");
            NAME_PROPERTY.setDefaultValue("");
            NAME_PROPERTY.setExpert(false);
            NAME_PROPERTY.setModifiable(true);
            NAME_PROPERTY.setHidden(false);
            NAME_PROPERTY.setPreferred(true);
            NAME_PROPERTY.setConstrainedToAllowedValues(false);
            SIZE_PROPERTY = new PropertyDefinitionImpl("size", PropertyType.STRING, MultiplicityPool.get("1"));
            SIZE_PROPERTY.setDisplayName("Size");
            SIZE_PROPERTY.setPluralDisplayName("Size");
            SIZE_PROPERTY.setShortDisplayName("Size");
            SIZE_PROPERTY.setShortDescription("The size of the file or directory");
            SIZE_PROPERTY.setDefaultValue("0KB");
            SIZE_PROPERTY.setExpert(false);
            SIZE_PROPERTY.setModifiable(false);
            SIZE_PROPERTY.setHidden(false);
            SIZE_PROPERTY.setPreferred(false);
            SIZE_PROPERTY.setConstrainedToAllowedValues(false);
            LAST_MODIFIED_PROPERTY = new PropertyDefinitionImpl("modified", PropertyType.TIMESTAMP, MultiplicityPool.get("1"));
            LAST_MODIFIED_PROPERTY.setDisplayName("Modified");
            LAST_MODIFIED_PROPERTY.setPluralDisplayName("Modified");
            LAST_MODIFIED_PROPERTY.setShortDisplayName("Modified");
            LAST_MODIFIED_PROPERTY.setShortDescription("The time of last modification");
            LAST_MODIFIED_PROPERTY.setDefaultValue(null);
            LAST_MODIFIED_PROPERTY.setExpert(false);
            LAST_MODIFIED_PROPERTY.setModifiable(false);
            LAST_MODIFIED_PROPERTY.setHidden(false);
            LAST_MODIFIED_PROPERTY.setPreferred(false);
            LAST_MODIFIED_PROPERTY.setConstrainedToAllowedValues(false);
            READ_ONLY_PROPERTY = new PropertyDefinitionImpl("readOnly", PropertyType.BOOLEAN, MultiplicityPool.get("1"));
            READ_ONLY_PROPERTY.setDisplayName("Read Only");
            READ_ONLY_PROPERTY.setPluralDisplayName("Read Only");
            READ_ONLY_PROPERTY.setShortDisplayName("RO");
            READ_ONLY_PROPERTY.setShortDescription("Whether the file is read-only");
            READ_ONLY_PROPERTY.setExpert(false);
            READ_ONLY_PROPERTY.setModifiable(false);
            READ_ONLY_PROPERTY.setHidden(false);
            READ_ONLY_PROPERTY.setPreferred(false);
            READ_ONLY_PROPERTY.setAllowedValues(PropertyDefinitionImpl.BOOLEAN_ALLOWED_VALUES);
            READ_ONLY_PROPERTY.setDefaultValue(PropertyDefinitionImpl.BOOLEAN_ALLOWED_VALUES.get(0).toString());
            READ_ONLY_PROPERTY.setConstrainedToAllowedValues(true);
            IS_HIDDEN_PROPERTY = new PropertyDefinitionImpl("hidden", PropertyType.BOOLEAN, MultiplicityPool.get("1"));
            IS_HIDDEN_PROPERTY.setDisplayName("Hidden");
            IS_HIDDEN_PROPERTY.setPluralDisplayName("Hidden");
            IS_HIDDEN_PROPERTY.setShortDisplayName("Hidden");
            IS_HIDDEN_PROPERTY.setShortDescription("Whether the file is hidden");
            IS_HIDDEN_PROPERTY.setExpert(false);
            IS_HIDDEN_PROPERTY.setModifiable(false);
            IS_HIDDEN_PROPERTY.setHidden(true);
            IS_HIDDEN_PROPERTY.setPreferred(false);
            IS_HIDDEN_PROPERTY.setAllowedValues(PropertyDefinitionImpl.BOOLEAN_ALLOWED_VALUES);
            IS_HIDDEN_PROPERTY.setDefaultValue(PropertyDefinitionImpl.BOOLEAN_ALLOWED_VALUES.get(0).toString());
            IS_HIDDEN_PROPERTY.setConstrainedToAllowedValues(true);
        }
        catch (MultiplicityExpressionException e) {
            e.printStackTrace(System.out);
        }
    }
}

