/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeException;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryEditor;
import com.metamatrix.common.tree.directory.EmptyUserTransaction;
import com.metamatrix.common.tree.directory.FileDefinition;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.common.tree.directory.FolderDefinition;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FileSystemEntryEditor
implements DirectoryEntryEditor {
    private FileSystemView view;

    protected FileSystemEntryEditor(FileSystemView view) {
        Assertion.isNotNull((Object)view, (String)"The FileSystemView reference may not be null");
        this.view = view;
    }

    protected FileSystemView getView() {
        return this.view;
    }

    protected TreeNode getActualParent(TreeNode possibleParent) {
        if (possibleParent != null) {
            return possibleParent;
        }
        if (this.getView().getRoots().size() == 0) {
            return this.getView().getHome();
        }
        throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0051"));
    }

    @Override
    public void setMarked(TreeNode entry, boolean marked) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        fsEntry.setMarked(marked);
    }

    @Override
    public boolean isMarked(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        return fsEntry.isMarked();
    }

    @Override
    public boolean isParentOf(TreeNode parent, TreeNode child) {
        Assertion.isNotNull((Object)parent, (String)"The TreeNode reference for the parent may not be null");
        Assertion.isNotNull((Object)child, (String)"The TreeNode reference for the child may not be null");
        FileSystemEntry parentEntry = this.assertFileSystemEntry(parent);
        FileSystemEntry childEntry = this.assertFileSystemEntry(child);
        File parentFile = childEntry.getFile().getParentFile();
        return parentEntry.getFile().equals(parentFile);
    }

    @Override
    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        Assertion.isNotNull((Object)ancestor, (String)"The TreeNode reference for the ancestor may not be null");
        Assertion.isNotNull((Object)descendent, (String)"The TreeNode reference for the descendent may not be null");
        FileSystemEntry ancestorEntry = this.assertFileSystemEntry(ancestor);
        FileSystemEntry descendentEntry = this.assertFileSystemEntry(descendent);
        for (File descendentFile = descendentEntry.getFile().getParentFile(); descendentFile != null; descendentFile = descendentFile.getParentFile()) {
            if (!ancestorEntry.getFile().equals(descendentFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TreeNode create(TreeNode parent, ObjectDefinition type) {
        Assertion.isNotNull((Object)parent, (String)"The TreeNode reference may not be null");
        Assertion.isNotNull((Object)type, (String)"The ObjectDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(this.getActualParent(parent));
        this.assertDescendentOfRoot(parent);
        if (type instanceof FolderDefinition) {
            try {
                String namePrefix;
                String newName = namePrefix = this.getNewFolderName();
                int counter = 0;
                while (fsEntry.hasChildWithName(newName)) {
                    newName = namePrefix + ++counter;
                }
                return this.createNewEntry(fsEntry, newName, DirectoryEntry.TYPE_FOLDER);
            }
            catch (TreeNodeException e) {
            }
            catch (IOException e) {}
        } else if (type instanceof FileDefinition) {
            try {
                String namePrefix;
                String newName = namePrefix = this.getNewFileName();
                int counter = 0;
                while (fsEntry.hasChildWithName(newName)) {
                    newName = namePrefix + ++counter;
                }
                return this.createNewEntry(fsEntry, newName, DirectoryEntry.TYPE_FILE);
            }
            catch (TreeNodeException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public TreeNode create(TreeNode parent, String name, ObjectDefinition type) {
        block8: {
            Assertion.isNotNull((Object)parent, (String)"The TreeNode reference may not be null");
            Assertion.isNotNull((Object)name, (String)"The name may not be null");
            Assertion.isNotZeroLength((String)name, (String)"The name may not be zero-length");
            Assertion.isNotNull((Object)type, (String)"The ObjectDefinition reference may not be null");
            FileSystemEntry fsEntry = this.assertFileSystemEntry(this.getActualParent(parent));
            this.assertDescendentOfRoot(parent);
            if (type instanceof FolderDefinition) {
                try {
                    return this.createNewEntry(fsEntry, name, DirectoryEntry.TYPE_FOLDER);
                }
                catch (TreeNodeException e) {
                    break block8;
                }
                catch (IOException e) {
                    break block8;
                }
            }
            if (type instanceof FileDefinition) {
                try {
                    return this.createNewEntry(fsEntry, name, DirectoryEntry.TYPE_FILE);
                }
                catch (TreeNodeException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public boolean makeExist(DirectoryEntry entry) {
        Assertion.isNotNull((Object)entry, (String)"The DirectoryEntry reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        if (fsEntry.exists()) {
            return false;
        }
        boolean result = false;
        ObjectDefinition type = entry.getType();
        File entryFile = fsEntry.getFile();
        try {
            result = type == DirectoryEntry.TYPE_FOLDER ? entryFile.mkdirs() : entryFile.createNewFile();
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean delete(TreeNode node) {
        Assertion.isNotNull((Object)node, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        return fsEntry.getFile().delete();
    }

    @Override
    public TreeNode paste(TreeNode original, TreeNode newParent, boolean deepCopy) {
        Assertion.isNotNull((Object)original, (String)"The TreeNode reference for the orginal node may not be null");
        Assertion.isNotNull((Object)newParent, (String)"The TreeNode reference may not be null");
        this.assertFileSystemEntry(original);
        this.assertFileSystemEntry(this.getActualParent(newParent));
        this.assertDescendentOfRoot(newParent);
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    @Override
    public boolean move(TreeNode node, TreeNode newParent) {
        Assertion.isNotNull((Object)node, (String)"The TreeNode reference may not be null");
        Assertion.isNotNull((Object)newParent, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        FileSystemEntry parentEntry = this.assertFileSystemEntry(this.getActualParent(newParent));
        this.assertDescendentOfRoot(newParent);
        if (!parentEntry.getFile().isDirectory()) {
            return false;
        }
        File originalFile = fsEntry.getFile();
        boolean isValid = fsEntry.move(parentEntry);
        if (isValid) {
            this.view.entryMoved(originalFile, fsEntry);
        }
        return isValid;
    }

    @Override
    public boolean move(TreeNode node, TreeNode newParent, int indexInNewParent) {
        return this.move(node, newParent);
    }

    @Override
    public boolean moveChild(TreeNode child, int newIndex) {
        Assertion.isNotNull((Object)child, (String)"The TreeNode reference may not be null");
        this.assertFileSystemEntry(child);
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public TreeNode copy(TreeNode node, TreeNode newParent) {
        Assertion.isNotNull((Object)node, (String)"The TreeNode reference may not be null");
        Assertion.isNotNull((Object)newParent, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        FileSystemEntry parentEntry = this.assertFileSystemEntry(this.getActualParent(newParent));
        Assertion.assertTrue((boolean)fsEntry.exists(), (String)("The FileSystemEntry \"" + fsEntry.getFullName() + "\" must exist on the file system"));
        Assertion.assertTrue((boolean)parentEntry.exists(), (String)("The FileSystemEntry \"" + parentEntry.getFullName() + "\" must exist on the file system"));
        this.assertDescendentOfRoot(newParent);
        if (!parentEntry.getFile().isDirectory()) {
            return null;
        }
        FileSystemEntry theCopy = (FileSystemEntry)fsEntry.copy(parentEntry);
        if (theCopy != null) {
            theCopy = this.view.getFileSystemEntry(theCopy.getFile(), theCopy.getType());
        }
        return theCopy;
    }

    @Override
    public boolean rename(TreeNode node, String newName) {
        Assertion.isNotNull((Object)node, (String)"The TreeNode reference may not be null");
        Assertion.isNotNull((Object)newName, (String)"The name may not be null");
        Assertion.isNotZeroLength((String)newName, (String)"The name may not be zero-length");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        return fsEntry.renameTo(newName);
    }

    @Override
    public List getPropertyDefinitions(PropertiedObject obj) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getPropertyDefinitions();
    }

    @Override
    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull((Object)def, (String)"The PropertyDefinition reference may not be null");
        return def.getAllowedValues();
    }

    @Override
    public PropertyDefinition getNamePropertyDefinition(TreeNode obj) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getNamePropertyDefinition();
    }

    @Override
    public PropertyDefinition getDescriptionPropertyDefinition(TreeNode obj) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getDescriptionPropertyDefinition();
    }

    @Override
    public boolean isNameValid(String newName) {
        return FileUtils.isFilenameValid((String)newName);
    }

    @Override
    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        Assertion.isNotNull((Object)def, (String)"The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getValue(def);
    }

    @Override
    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        Assertion.isNotNull((Object)def, (String)"The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.isValidValue(def, value);
    }

    @Override
    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        Assertion.isNotNull((Object)def, (String)"The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        fsEntry.setValue(def, value);
    }

    @Override
    public void setPolicy(PropertyAccessPolicy policy) {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    @Override
    public PropertyAccessPolicy getPolicy() {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    @Override
    public boolean isReadOnly(PropertiedObject obj) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.isReadOnly();
    }

    @Override
    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        Assertion.isNotNull((Object)def, (String)"The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.isReadOnly();
    }

    @Override
    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        Assertion.isNotNull((Object)def, (String)"The PropertyDefinition reference may not be null");
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    @Override
    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    @Override
    public void reset(PropertiedObject obj) {
        Assertion.isNotNull((Object)obj, (String)"The PropertiedObject reference may not be null");
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    @Override
    public UserTransaction createReadTransaction() {
        return new EmptyUserTransaction(null);
    }

    @Override
    public UserTransaction createWriteTransaction() {
        return new EmptyUserTransaction(null);
    }

    @Override
    public UserTransaction createWriteTransaction(Object source) {
        return new EmptyUserTransaction(source);
    }

    protected FileSystemEntry assertFileSystemEntry(TreeNode obj) {
        Assertion.assertTrue((boolean)(obj instanceof FileSystemEntry), (String)"The type of TreeNode entry must be a FileSystemEntry");
        FileSystemEntry entry = (FileSystemEntry)obj;
        return entry;
    }

    protected FileSystemEntry assertFileSystemEntry(PropertiedObject obj) {
        Assertion.assertTrue((boolean)(obj instanceof FileSystemEntry), (String)"The type of PropertiedObject entry must be a FileSystemEntry");
        FileSystemEntry entry = (FileSystemEntry)obj;
        return entry;
    }

    protected void assertDescendentOfRoot(TreeNode descendent) {
        if (this.getView().isRoot(descendent)) {
            return;
        }
        for (TreeNode root : this.getView().getActualRoots()) {
            if (!this.isAncestorOf(root, descendent)) continue;
            return;
        }
        throw new AssertionError((Object)CommonPlugin.Util.getString("ERR.003.028.0053"));
    }

    private TreeNode createNewEntry(TreeNode parent, String name, ObjectDefinition type) throws IOException, TreeNodeException {
        Assertion.isNotNull((Object)parent, (String)"The TreeNode reference may not be null");
        Assertion.isNotNull((Object)name, (String)"The name may not be null");
        Assertion.isNotZeroLength((String)name, (String)"The name may not be zero-length");
        Assertion.isNotNull((Object)type, (String)"The ObjectDefinition reference may not be null");
        Assertion.assertTrue((type instanceof FileDefinition || type instanceof FolderDefinition ? 1 : 0) != 0, (String)"The ObjectDefinition must be of type FileDefinition or FolderDefinition");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(parent);
        File parentFile = fsEntry.getFile();
        File file = new File(parentFile, name);
        return this.view.getFileSystemEntry(file, type);
    }

    protected String getNewFolderName() {
        return "New Folder";
    }

    protected String getNewFileName() {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }
}

