/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.transaction.manager.SimpleUserTransaction;
import com.metamatrix.common.tree.PassThroughTreeNodeFilter;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeFilter;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryEditor;
import com.metamatrix.common.tree.directory.DirectoryEntryNameAndTypeComparator;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileDefinition;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemEntryEditor;
import com.metamatrix.common.tree.directory.FolderDefinition;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileSystemView
implements DirectoryEntryView {
    private static TreeNodeFilter DEFAULT_FILTER = new PassThroughTreeNodeFilter();
    private static Comparator DEFAULT_COMPARATOR = new DirectoryEntryNameAndTypeComparator();
    private File root = null;
    private boolean showRoot = false;
    private DirectoryEntry home = null;
    private TreeNodeFilter filter = DEFAULT_FILTER;
    private Comparator comparator = DEFAULT_COMPARATOR;
    private List propertyDefinitions = new ArrayList();
    private List unmodifiablePropertyDefinitions = Collections.unmodifiableList(this.propertyDefinitions);
    private Map dirEntries = new HashMap();

    public FileSystemView() {
    }

    public FileSystemView(File root, boolean showRoot) {
        Assertion.isNotNull((Object)root, (String)"The root File reference may not be null");
        Assertion.assertTrue((boolean)root.exists(), (String)"The root File reference must exist");
        Assertion.assertTrue((boolean)root.isDirectory(), (String)"The root File reference must be a folder");
        this.root = root;
        this.home = this.getFileSystemEntry(this.root, DirectoryEntry.TYPE_FOLDER);
        this.showRoot = showRoot;
    }

    @Override
    public boolean isMarked(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        return fsEntry.isMarked();
    }

    public void entryMoved(File originalFile, TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        this.assertFileSystemEntry(entry);
        this.dirEntries.remove(originalFile.getAbsolutePath());
        this.dirEntries.put(this.getAbsolutePath(entry), entry);
    }

    @Override
    public void setMarked(TreeNode entry, boolean markedState) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        fsEntry.setMarked(markedState);
    }

    @Override
    public Set getMarked() {
        HashSet<FileSystemEntry> result = new HashSet<FileSystemEntry>();
        Map.Entry entry2 = null;
        FileSystemEntry fsEntry = null;
        for (Map.Entry entry2 : this.dirEntries.entrySet()) {
            fsEntry = (FileSystemEntry)entry2.getValue();
            if (!fsEntry.isMarked()) continue;
            result.add(fsEntry);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public void setFilter(TreeNodeFilter filter) {
        this.filter = filter == null ? DEFAULT_FILTER : filter;
    }

    @Override
    public TreeNodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setComparator(Comparator comparator) {
        this.comparator = comparator == null ? DEFAULT_COMPARATOR : comparator;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public List getPropertyDefinitions() {
        if (this.propertyDefinitions.size() == 0) {
            this.propertyDefinitions.addAll(FileSystemEntry.getPropertyDefinitionList());
        }
        return this.unmodifiablePropertyDefinitions;
    }

    @Override
    public List getRoots() {
        FileSystemEntry fsEntry = null;
        ArrayList<FileSystemEntry> roots = new ArrayList<FileSystemEntry>();
        if (this.root != null) {
            if (this.showRoot) {
                fsEntry = this.getFileSystemEntry(this.root, DirectoryEntry.TYPE_FOLDER);
                if (fsEntry != null) {
                    roots.add(fsEntry);
                }
            } else {
                File[] rootFiles = this.root.listFiles();
                for (int i = 0; i != rootFiles.length; ++i) {
                    File aFile = rootFiles[i];
                    if (!aFile.isDirectory() || (fsEntry = this.getFileSystemEntry(rootFiles[i], DirectoryEntry.TYPE_FOLDER)) == null) continue;
                    roots.add(fsEntry);
                }
            }
        } else {
            File[] rootFiles = File.listRoots();
            for (int i = 0; i != rootFiles.length; ++i) {
                if (File.separatorChar == '\\' && rootFiles[i].getPath().startsWith("A:") || (fsEntry = this.getFileSystemEntry(rootFiles[i], DirectoryEntry.TYPE_FOLDER)) == null) continue;
                roots.add(fsEntry);
            }
        }
        Collections.sort(roots);
        this.filter(roots);
        return Collections.unmodifiableList(roots);
    }

    protected List getActualRoots() {
        FileSystemEntry fsEntry = null;
        ArrayList<FileSystemEntry> roots = new ArrayList<FileSystemEntry>();
        if (this.root != null) {
            fsEntry = this.getFileSystemEntry(this.root, DirectoryEntry.TYPE_FOLDER);
            if (fsEntry != null) {
                roots.add(fsEntry);
            }
        } else {
            File[] rootFiles = File.listRoots();
            for (int i = 0; i != rootFiles.length; ++i) {
                fsEntry = this.getFileSystemEntry(rootFiles[i], DirectoryEntry.TYPE_FOLDER);
                if (fsEntry == null) continue;
                roots.add(fsEntry);
            }
        }
        Collections.sort(roots);
        return Collections.unmodifiableList(roots);
    }

    protected void filter(List entries) {
        if (this.filter != DEFAULT_FILTER) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                if (this.filter.accept((DirectoryEntry)iter.next())) continue;
                iter.remove();
            }
        }
    }

    @Override
    public boolean isRoot(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        if (this.root != null) {
            return ((Object)entry).equals(this.root);
        }
        return this.getRoots().contains(fsEntry);
    }

    @Override
    public boolean isHidden(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        return fsEntry.getFile().isHidden();
    }

    protected void setRoot(File root, boolean showRoot) {
        Assertion.isNotNull((Object)root, (String)"The root File reference may not be null");
        Assertion.assertTrue((boolean)root.exists(), (String)"The root File reference must exist");
        Assertion.assertTrue((boolean)root.isDirectory(), (String)"The root File reference must be a folder");
        this.root = root;
        this.home = this.getFileSystemEntry(this.root, DirectoryEntry.TYPE_FOLDER);
        this.showRoot = showRoot;
    }

    public void setHome(TreeNode home) {
        Assertion.isNotNull((Object)home, (String)"The TreeNode reference may not be null");
        Assertion.assertTrue((boolean)home.exists(), (String)"The home TreeNode reference must represent an existing folder");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(home);
        Assertion.assertTrue((boolean)fsEntry.isFolder(), (String)"The home TreeNode reference must represent a folder, not a file");
        if (this.root != null) {
            FileSystemEntry rootEntry = this.getFileSystemEntry(this.root, DirectoryEntry.TYPE_FOLDER);
            Assertion.assertTrue((boolean)this.isAncestorOf(rootEntry, home), (String)"The specified TreeNode reference for the home is not contained within this view as specified by the root");
        }
        this.home = fsEntry;
    }

    @Override
    public TreeNode getHome() {
        if (this.home != null) {
            return this.home;
        }
        if (this.root != null) {
            return this.getFileSystemEntry(this.root, DirectoryEntry.TYPE_FOLDER);
        }
        return this.getFileSystemEntry(new File(System.getProperty("user.home")), DirectoryEntry.TYPE_FOLDER);
    }

    @Override
    public String getPath(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        String path = fsEntry.getFile().getPath();
        if (this.root != null) {
            String removePath = this.root.getPath();
            removePath = !this.showRoot ? this.root.getPath() : this.root.getParent();
            if (path.startsWith(removePath)) {
                path = path.substring(removePath.length());
            }
        }
        return path;
    }

    @Override
    public char getSeparatorChar() {
        return File.separatorChar;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    public String getAbsolutePath(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        return fsEntry.getFile().getPath();
    }

    @Override
    public TreeNode getParent(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        File parentFile = fsEntry.getFile().getParentFile();
        if (parentFile == null) {
            return null;
        }
        if (parentFile.isDirectory()) {
            return this.getFileSystemEntry(parentFile, DirectoryEntry.TYPE_FOLDER);
        }
        return this.getFileSystemEntry(parentFile, DirectoryEntry.TYPE_FILE);
    }

    @Override
    public boolean allowsChildren(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        return fsEntry.isFolder();
    }

    @Override
    public boolean allowsChild(TreeNode parent, TreeNode potentialChild) {
        Assertion.isNotNull((Object)parent, (String)"The parent TreeNode reference may not be null");
        Assertion.isNotNull((Object)potentialChild, (String)"The potential child TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(parent);
        this.assertFileSystemEntry(potentialChild);
        return fsEntry.isFolder();
    }

    @Override
    public List getChildren(TreeNode parent) {
        Assertion.isNotNull((Object)parent, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(parent);
        File[] childFiles = this.getChildFiles(parent);
        if (childFiles != null && childFiles.length > 0) {
            ArrayList<FileSystemEntry> children = new ArrayList<FileSystemEntry>(childFiles.length);
            for (int i = 0; i != childFiles.length; ++i) {
                if (childFiles[i].isDirectory()) {
                    fsEntry = this.getFileSystemEntry(childFiles[i], DirectoryEntry.TYPE_FOLDER);
                    if (fsEntry == null) continue;
                    children.add(fsEntry);
                    continue;
                }
                fsEntry = this.getFileSystemEntry(childFiles[i], DirectoryEntry.TYPE_FILE);
                if (fsEntry == null) continue;
                children.add(fsEntry);
            }
            Collections.sort(children);
            this.filter(children);
            return Collections.unmodifiableList(children);
        }
        return Collections.EMPTY_LIST;
    }

    protected File[] getChildFiles(TreeNode parent) {
        Assertion.isNotNull((Object)parent, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(parent);
        return fsEntry.getFile().listFiles();
    }

    @Override
    public Iterator iterator() {
        return new TreeNodeIterator(this.getRoots(), (TreeView)this);
    }

    @Override
    public Iterator iterator(TreeNode startingPoint) {
        Assertion.isNotNull((Object)startingPoint, (String)"The TreeNode reference may not be null");
        return new TreeNodeIterator(startingPoint, (TreeView)this);
    }

    @Override
    public boolean isParentOf(TreeNode parent, TreeNode child) {
        Assertion.isNotNull((Object)parent, (String)"The TreeNode reference may not be null");
        Assertion.isNotNull((Object)child, (String)"The TreeNode reference may not be null");
        FileSystemEntry parentEntry = this.assertFileSystemEntry(parent);
        FileSystemEntry childEntry = this.assertFileSystemEntry(child);
        File parentFile = childEntry.getFile().getParentFile();
        return parentEntry.getFile().equals(parentFile);
    }

    @Override
    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        Assertion.isNotNull((Object)ancestor, (String)"The TreeNode reference may not be null");
        Assertion.isNotNull((Object)descendent, (String)"The TreeNode reference may not be null");
        FileSystemEntry ancestorEntry = this.assertFileSystemEntry(ancestor);
        FileSystemEntry descendentEntry = this.assertFileSystemEntry(descendent);
        for (File ancestorFile = descendentEntry.getFile().getParentFile(); ancestorFile != null; ancestorFile = ancestorFile.getParentFile()) {
            if (!ancestorEntry.getFile().equals(ancestorFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PropertiedObjectEditor getPropertiedObjectEditor() {
        return this.getFileEntryEditor();
    }

    @Override
    public TreeNodeEditor getTreeNodeEditor() {
        return this.getFileEntryEditor();
    }

    @Override
    public DirectoryEntryEditor getDirectoryEntryEditor() {
        return this.getFileEntryEditor();
    }

    public FileSystemEntryEditor getFileEntryEditor() {
        return new FileSystemEntryEditor(this);
    }

    @Override
    public UserTransaction createReadTransaction() {
        return new SimpleUserTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction() {
        return new SimpleUserTransaction();
    }

    @Override
    public UserTransaction createWriteTransaction(Object source) {
        return new SimpleUserTransaction(source);
    }

    @Override
    public DirectoryEntry lookup(String path) {
        Assertion.isNotNull((Object)path, (String)"The path reference may not be null");
        Assertion.isNotZeroLength((String)path, (String)"The path reference may not be zero-length");
        return this.lookup(path, this.getSeparator());
    }

    @Override
    public DirectoryEntry lookup(String path, String separator) {
        FileSystemEntry fsEntry;
        Assertion.isNotNull((Object)path, (String)"The path reference may not be null");
        Assertion.isNotZeroLength((String)path, (String)"The path reference may not be zero-length");
        Assertion.isNotNull((Object)separator, (String)"The separator may not be null");
        Assertion.isNotZeroLength((String)separator, (String)"The separator may not be zero-length");
        String pathWithThisSeparator = path;
        if (!this.getSeparator().equals(separator)) {
            pathWithThisSeparator = StringUtil.replaceAll((String)path, (String)separator, (String)this.getSeparator());
        }
        if ((fsEntry = this.lookupByPath(pathWithThisSeparator)) == null && this.root != null) {
            String modPath = pathWithThisSeparator;
            String prefix = this.root.getName();
            if (pathWithThisSeparator.startsWith(prefix)) {
                modPath = pathWithThisSeparator.substring(prefix.length());
                fsEntry = this.lookupByPath(modPath);
            }
            if (pathWithThisSeparator.startsWith(prefix = this.getSeparator() + this.root.getName())) {
                modPath = pathWithThisSeparator.substring(prefix.length());
                fsEntry = this.lookupByPath(modPath);
            }
        }
        return fsEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystemEntry lookupByPath(String path) {
        String fullPath = path;
        if (this.root != null) {
            fullPath = path.startsWith(this.getSeparator()) ? this.root.getAbsolutePath() + path : this.root.getAbsolutePath() + this.getSeparatorChar() + path;
        }
        FileSystemEntry fsEntry = null;
        Map map = this.dirEntries;
        synchronized (map) {
            fsEntry = (FileSystemEntry)this.dirEntries.get(fullPath);
        }
        File entry = new File(fullPath);
        if (fsEntry == null && entry.exists()) {
            fsEntry = entry.isDirectory() ? this.getFileSystemEntry(entry, DirectoryEntry.TYPE_FOLDER) : this.getFileSystemEntry(entry, DirectoryEntry.TYPE_FILE);
        }
        return fsEntry;
    }

    protected File getFile(TreeNode entry) {
        Assertion.isNotNull((Object)entry, (String)"The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        return fsEntry.getFile();
    }

    private FileSystemEntry assertFileSystemEntry(TreeNode obj) {
        Assertion.assertTrue((boolean)(obj instanceof FileSystemEntry), (String)"The type of TreeNode entry must be a FileSystemEntry");
        FileSystemEntry entry = (FileSystemEntry)obj;
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystemEntry getFileSystemEntry(File f, ObjectDefinition type) {
        Assertion.isNotNull((Object)f, (String)"The File reference may not be null");
        Assertion.isNotNull((Object)type, (String)"The ObjectDefinition reference may not be null");
        Assertion.assertTrue((type instanceof FileDefinition || type instanceof FolderDefinition ? 1 : 0) != 0, (String)"The ObjectDefinition must be of type FileDefinition or FolderDefinition");
        FileSystemEntry result = null;
        Map map = this.dirEntries;
        synchronized (map) {
            result = (FileSystemEntry)this.dirEntries.get(f.getAbsolutePath());
            if (result == null) {
                try {
                    result = new FileSystemEntry(f, type);
                    this.dirEntries.put(f.getAbsolutePath(), result);
                }
                catch (IOException e) {
                    return null;
                }
            } else {
                result.loadPreview();
            }
        }
        return result;
    }
}

