/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.core.util.Assertion;
import java.io.File;
import java.io.PrintStream;
import java.util.Properties;

public class OSPlatformUtil {
    public static String OS_PROPERTY_NAME = "os.name";
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_DEC = 512;
    public static final int OS_OS2 = 1024;
    public static final int OS_MAC = 2048;
    public static final int OS_WIN2000 = 4096;
    public static final int OS_VMS = 8192;
    public static final int OS_WINXP = 16384;
    public static final int OS_WIN_OTHER = 16384;
    public static final int OS_OTHER = 65536;
    public static final int OS_WINDOWS_MASK = 20487;
    public static final int OS_UNIX_MASK = 3064;
    public static final int OS_LINUX_MASK = 16;
    private static int operatingSystem = -1;

    public static final int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty(OS_PROPERTY_NAME);
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 4096 : ("Windows XP".equals(osName) ? 16384 : (osName.startsWith("Windows ") ? 16384 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 1024 : ("OpenVMS".equals(osName) ? 8192 : (osName.equals("Mac OS X") ? 2048 : (osName.startsWith("Darwin") ? 2048 : 65536)))))))))))))))));
        }
        return operatingSystem;
    }

    public static final boolean isWindows() {
        return (OSPlatformUtil.getOperatingSystem() & 0x5007) != 0;
    }

    public static final boolean isUnix() {
        return (OSPlatformUtil.getOperatingSystem() & 0xBF8) != 0;
    }

    public static final boolean isLinux() {
        return (OSPlatformUtil.getOperatingSystem() & 0x10) != 0;
    }

    static void printSystemProperties(PrintStream stream) {
        Assertion.isNotNull((Object)stream, (String)"The PrintStream reference may not be null");
        Properties p = System.getProperties();
        p.list(stream);
    }

    static void printPermissions(File f, String action) {
        System.out.println("\nFile \"" + f + "\" action = " + action);
        System.out.println("exists  = " + f.exists() + " canRead = " + f.canRead() + " canWrite = " + f.canWrite());
    }

    static void printRuntimeCmd(String methodName, String cmd) {
        System.out.println("\n[" + methodName + "] Runtime.exec( " + cmd + " )");
    }
}

