/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.NetUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class VMNaming {
    private static final String HOSTNAME = "HOSTNAME";
    private static String CONFIG_NAME = "";
    private static InetAddress HOST_ADDRESS = null;
    private static String BIND_ADDRESS = "";
    private static String PROCESS_NAME = "";

    public static String getProcessName() {
        return PROCESS_NAME;
    }

    public static void setProcessName(String processName) {
        PROCESS_NAME = processName;
    }

    public static String getConfigName() {
        return CONFIG_NAME;
    }

    public static InetAddress getHostAddress() {
        return HOST_ADDRESS;
    }

    public static String getBindAddress() {
        return BIND_ADDRESS;
    }

    public static void setup(String configName, String hostName, String bindAddress) throws UnknownHostException {
        boolean hostNameDefined;
        CONFIG_NAME = configName;
        boolean bindAddressDefined = bindAddress != null && bindAddress.length() > 0;
        boolean bl = hostNameDefined = hostName != null && hostName.length() > 0;
        if (hostNameDefined) {
            HOST_ADDRESS = NetUtils.resolveHostByName((String)hostName);
        }
        if (bindAddressDefined) {
            BIND_ADDRESS = bindAddress;
            if (!hostNameDefined) {
                HOST_ADDRESS = InetAddress.getByName(bindAddress);
            }
        } else {
            if (!hostNameDefined) {
                HOST_ADDRESS = NetUtils.getInstance().getInetAddress();
            }
            BIND_ADDRESS = HOST_ADDRESS.getHostAddress();
        }
    }

    public static String getHostInfo() {
        StringBuffer sb = new StringBuffer("Host Information");
        sb.append('\n');
        sb.append(" VM Name:               " + PROCESS_NAME);
        sb.append('\n');
        sb.append(" Hostname:              " + HOST_ADDRESS.getCanonicalHostName());
        sb.append('\n');
        sb.append(" Version:               ").append(ApplicationInfo.getInstance().getReleaseNumber());
        sb.append('\n');
        sb.append(" Build Date:            ").append(ApplicationInfo.getInstance().getBuildDate());
        return sb.toString();
    }

    public static String getDefaultConfigName() {
        String nvalue = System.getenv(HOSTNAME);
        if (nvalue == null) {
            try {
                nvalue = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                nvalue = "teiid-system";
            }
        }
        return nvalue;
    }
}

