/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.vdb.api;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfig_42_HelperImpl;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import com.metamatrix.vdb.runtime.BasicVDBInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class DEFReaderWriter {
    private static final String TRUE = "true";
    private static final String UNKNOWN = "Unknown";
    static final String ROOT_ELEMENT = "VDB";

    public BasicVDBDefn read(InputStream defStream) throws IOException {
        BasicVDBDefn vdbDefn = null;
        try {
            XMLReaderWriterImpl reader = new XMLReaderWriterImpl();
            Document doc = reader.readDocument(defStream);
            Element root = doc.getRootElement();
            vdbDefn = new BasicVDBDefn(UNKNOWN);
            this.loadHeaderSection(vdbDefn, root);
            this.loadVDBInfoSection(vdbDefn, root);
            this.loadModelsSection(vdbDefn, root);
            this.loadConnectorTypes(vdbDefn, root);
            this.loadConnectorBindings(vdbDefn, root);
        }
        catch (JDOMException e) {
            throw new IOException(CommonPlugin.Util.getString("VDBDefnXMLHelper.Unable_to_read_defn_file"));
        }
        return vdbDefn;
    }

    private void loadHeaderSection(BasicVDBDefn vdbDefn, Element root) throws IOException {
        Element headElement = root.getChild("Header");
        if (headElement == null) {
            throw new IOException("VDBDefnXMLHelper.Invalid_xml_section");
        }
        Properties header = new Properties();
        String createdBy = headElement.getChildText("ApplicationCreatedBy");
        String applicationVersion = headElement.getChildText("ApplicationVersion");
        String systemVersion = headElement.getChildText("MetaMatrixSystemVersion");
        String userCreatedBy = headElement.getChildText("UserCreatedBy");
        String vdbExporterVersion = headElement.getChildText("VDBExporterVersion");
        String modificationTime = headElement.getChildText("Time");
        header.setProperty("ApplicationCreatedBy", createdBy != null ? createdBy : UNKNOWN);
        header.setProperty("ApplicationVersion", applicationVersion != null ? applicationVersion : UNKNOWN);
        header.setProperty("MetaMatrixSystemVersion", systemVersion != null ? systemVersion : UNKNOWN);
        header.setProperty("UserCreatedBy", userCreatedBy != null ? userCreatedBy : UNKNOWN);
        header.setProperty("VDBExporterVersion", vdbExporterVersion != null ? vdbExporterVersion : UNKNOWN);
        header.setProperty("Time", modificationTime != null ? modificationTime : UNKNOWN);
        vdbDefn.setHeaderProperties(header);
        vdbDefn.setCreatedBy(headElement.getChildText("UserCreatedBy"));
        try {
            vdbDefn.setDateCreated(new SimpleDateFormat().parse(headElement.getChildText("Time")));
        }
        catch (ParseException e) {
            vdbDefn.setDateCreated(Calendar.getInstance().getTime());
        }
    }

    private void loadVDBInfoSection(BasicVDBDefn vdbDefn, Element root) throws IOException {
        Element vdbInfoElement = root.getChild("VDBInfo");
        if (vdbInfoElement == null) {
            throw new IOException("VDBDefnXMLHelper.Invalid_xml_section");
        }
        Properties vdbProps = this.getElementProperties(vdbInfoElement);
        if (vdbProps == null || vdbProps.isEmpty()) {
            throw new IOException("VDBDefnXMLHelper.No_properties_defined_to_create_defn");
        }
        vdbDefn.setName(vdbProps.getProperty("Name"));
        vdbDefn.setVersion(vdbProps.getProperty("Version", "1"));
        vdbDefn.setFileName(vdbProps.getProperty("VDBArchiveName"));
        vdbDefn.setDescription(vdbProps.getProperty("Description"));
        vdbDefn.setUUID(vdbProps.getProperty("GUID"));
        if (TRUE.equals(vdbProps.getProperty("Active"))) {
            vdbDefn.setStatus((short)3);
        } else {
            vdbDefn.setStatus((short)2);
        }
    }

    private void loadModelsSection(BasicVDBDefn vdbDefn, Element root) throws IOException {
        List modelsElements = root.getChildren("Model");
        for (Element modelElement : modelsElements) {
            vdbDefn.addModelInfo(this.loadModel(modelElement));
        }
    }

    private BasicModelInfo loadModel(Element modelElement) throws IOException {
        Properties props = this.getElementProperties(modelElement);
        BasicModelInfo model = new BasicModelInfo(props.getProperty("Name"));
        String visibility = props.getProperty("Visibility", "Public");
        model.setVisibility(visibility.equalsIgnoreCase("Private") ? (short)2 : 0);
        model.enableMutliSourceBindings(Boolean.parseBoolean(props.getProperty("MultiSourceEnabled")));
        Element cbElement = modelElement.getChild("ConnectorBindings");
        if (cbElement != null) {
            List bindingElements = cbElement.getChildren("Connector");
            for (Element bindingElement : bindingElements) {
                model.addConnectorBindingByName(bindingElement.getAttributeValue("Name"));
            }
        }
        return model;
    }

    protected Properties getElementProperties(Element rootElement) {
        Properties properties = new Properties();
        if (rootElement == null) {
            return properties;
        }
        List propertyElements = rootElement.getChildren("Property");
        if (propertyElements != null) {
            Iterator iterator = propertyElements.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.getAttributeValue("Name");
                String value = element.getAttributeValue("Value");
                if (name != null && name.length() > 0) {
                    properties.setProperty(name, value);
                }
                ++i;
            }
        }
        return properties;
    }

    private void loadConnectorTypes(BasicVDBDefn vdbDefn, Element root) throws IOException {
        Element components = root.getChild("ComponentTypes");
        if (components == null) {
            return;
        }
        XMLConfig_42_HelperImpl helper = new XMLConfig_42_HelperImpl();
        try {
            List connectorTypes = components.getChildren("ComponentType");
            for (Element connectorTypeElement : connectorTypes) {
                vdbDefn.addConnectorType(helper.loadComponentType(connectorTypeElement));
            }
        }
        catch (InvalidConfigurationElementException e) {
            IOException ex = new IOException();
            ex.initCause((Throwable)((Object)e));
            throw ex;
        }
    }

    private void loadConnectorBindings(BasicVDBDefn vdbDefn, Element root) throws IOException {
        Element components = root.getChild("ConnectorBindings");
        if (components == null) {
            return;
        }
        XMLConfig_42_HelperImpl helper = new XMLConfig_42_HelperImpl();
        try {
            List connectorBindings = components.getChildren("Connector");
            for (Element bindingElement : connectorBindings) {
                vdbDefn.addConnectorBinding(helper.loadConnectorBinding(bindingElement));
            }
        }
        catch (InvalidConfigurationElementException e) {
            IOException ex = new IOException();
            ex.initCause((Throwable)((Object)e));
            throw ex;
        }
    }

    public void write(OutputStream outstream, BasicVDBDefn def, Properties headerProperties) throws IOException {
        Element rootElement = new Element(ROOT_ELEMENT);
        Document doc = new Document(rootElement);
        rootElement.addContent((Content)this.createHeaderElement(headerProperties));
        rootElement.addContent((Content)this.createVDBInfoElement(def, def.getStatus()));
        Collection models = def.getModels();
        for (ModelInfo model : models) {
            rootElement.addContent((Content)this.createModel(model));
        }
        Element componentTypesElement = new Element("ComponentTypes");
        Collection connectorTypes = def.getConnectorTypes().values();
        for (ComponentType connectorType : connectorTypes) {
            componentTypesElement.addContent((Content)this.createConnectorType(connectorType));
        }
        rootElement.addContent((Content)componentTypesElement);
        Element connectorBindingsElement = new Element("ConnectorBindings");
        Collection connectorBindings = def.getConnectorBindings().values();
        for (ConnectorBinding connectorBinding : connectorBindings) {
            connectorBindingsElement.addContent((Content)this.createConnectorBinding(connectorBinding));
        }
        rootElement.addContent((Content)connectorBindingsElement);
        new XMLReaderWriterImpl().writeDocument(doc, outstream);
    }

    private Element createHeaderElement(Properties props) throws IOException {
        Element headerElement = new Element("Header");
        headerElement.addContent((Content)new Element("VDBExporterVersion").addContent(props.getProperty("VDBExporterVersion", UNKNOWN)));
        headerElement.addContent((Content)new Element("ApplicationCreatedBy").addContent(props.getProperty("ApplicationCreatedBy", UNKNOWN)));
        headerElement.addContent((Content)new Element("ApplicationVersion").addContent(props.getProperty("ApplicationVersion", UNKNOWN)));
        headerElement.addContent((Content)new Element("UserCreatedBy").addContent(props.getProperty("UserCreatedBy", UNKNOWN)));
        headerElement.addContent((Content)new Element("MetaMatrixSystemVersion").addContent(props.getProperty("MetaMatrixSystemVersion", UNKNOWN)));
        headerElement.addContent((Content)new Element("Time").addContent(props.getProperty("Time", UNKNOWN)));
        return headerElement;
    }

    private Element createVDBInfoElement(BasicVDBInfo info, int status) throws IOException {
        Element vdbInfoElement = new Element("VDBInfo");
        boolean valid = this.addPropertyElement(vdbInfoElement, "Name", info.getName());
        if (valid) {
            this.addPropertyElement(vdbInfoElement, "GUID", info.getUUID());
            this.addPropertyElement(vdbInfoElement, "Version", info.getVersion());
            this.addPropertyElement(vdbInfoElement, "VDBArchiveName", info.getFileName());
            this.addPropertyElement(vdbInfoElement, "Description", info.getDescription());
            if (status == 3) {
                this.addPropertyElement(vdbInfoElement, "Active", TRUE);
            }
        } else {
            throw new IOException("Invalid DEF, No name supplied");
        }
        return vdbInfoElement;
    }

    private Element createModel(ModelInfo model) throws IOException {
        Element modelElement = new Element("Model");
        boolean valid = this.addPropertyElement(modelElement, "Name", model.getName());
        if (valid) {
            this.addPropertyElement(modelElement, "Visibility", model.getVisibility() == 2 ? "Private" : "Public");
            this.addPropertyElement(modelElement, "MultiSourceEnabled", Boolean.toString(model.isMultiSourceBindingEnabled()));
            List bindings = model.getConnectorBindingNames();
            if (bindings != null && !bindings.isEmpty()) {
                Element cbsElement = new Element("ConnectorBindings");
                for (String cbName : bindings) {
                    Element connector = new Element("Connector");
                    connector.setAttribute("Name", cbName);
                    cbsElement.addContent((Content)connector);
                }
                modelElement.addContent((Content)cbsElement);
            }
        }
        return modelElement;
    }

    private Element createConnectorType(ComponentType connectorType) {
        XMLConfig_42_HelperImpl helper = new XMLConfig_42_HelperImpl();
        return helper.createComponentTypeElement(connectorType);
    }

    private Element createConnectorBinding(ConnectorBinding binding) {
        XMLConfig_42_HelperImpl helper = new XMLConfig_42_HelperImpl();
        return helper.createConnectorBindingElement(binding, false);
    }

    private boolean addPropertyElement(Element element, String name, String value) {
        if (element == null || name == null || value == null) {
            return false;
        }
        Element propElement = new Element("Property");
        propElement.setAttribute("Name", name);
        propElement.setAttribute("Value", value);
        element.addContent((Content)propElement);
        return true;
    }

    public static class Model {
        public static final String ELEMENT = "Model";
        public static final String NAME = "Name";
        public static final String VISIBILITY = "Visibility";
        public static final String MULTI_SOURCE_ENABLED = "MultiSourceEnabled";
        public static final String CONNECTOR_BINDINGS_ELEMENT = "ConnectorBindings";
        public static final String CONNECTOR = "Connector";
        public static final String CONNECTOR_ATTRIBUTE_NAME = "Name";
    }

    public static interface Header {
        public static final String ELEMENT = "Header";
        public static final String VDB_EXPORTER_VERSION = "VDBExporterVersion";
        public static final String APPLICATION_CREATED_BY = "ApplicationCreatedBy";
        public static final String APPLICATION_VERSION = "ApplicationVersion";
        public static final String USER_CREATED_BY = "UserCreatedBy";
        public static final String SYSTEM_VERSION = "MetaMatrixSystemVersion";
        public static final String MODIFICATION_TIME = "Time";
    }

    public static class Property {
        public static final String ELEMENT = "Property";
        public static final String ATTRIBUTE_NAME = "Name";
        public static final String ATTRIBUTE_VALUE = "Value";
    }

    public static class VDBInfo {
        public static final String ELEMENT = "VDBInfo";
        public static final String NAME = "Name";
        public static final String ARCHIVE_NAME = "VDBArchiveName";
        public static final String VERSION = "Version";
        public static final String DESCRIPTION = "Description";
        public static final String GUID = "GUID";
        public static final String ACTIVE = "Active";
    }
}

