/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.vdb.api;

import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.vdb.ModelType;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

class Manifest {
    private static final String MODELS = "models";
    private static final String ACCESSIBILITY = "accessibility";
    private static final String PRIMARY_METAMODEL_URI = "primaryMetamodelUri";
    private static final String UUID = "uuid";
    private static final String NS = "vdb";
    private static final String MESSAGE = "message";
    private static final String ERROR = "ERROR";
    private static final String SEVERITY = "severity";
    private static String NAME = "name";
    private static String MODEL_PATH = "path";
    private static String MODEL_TYPE = "modelType";
    private static String VDB_ELEMENT = "VirtualDatabase";
    private static String DESCRIPTION = "description";
    private static String MARKERS = "markers";
    List<String> validityErrors = new ArrayList<String>();
    BasicVDBDefn vdb;

    Manifest() {
    }

    public void load(InputStream in) throws IOException {
        try {
            XMLReaderWriterImpl reader = new XMLReaderWriterImpl();
            Document doc = reader.readDocument(in);
            Element root = doc.getRootElement();
            Namespace ns = root.getNamespace(NS);
            Element vdbElement = root.getChild(VDB_ELEMENT, ns);
            if (vdbElement != null) {
                this.vdb = new BasicVDBDefn(vdbElement.getAttributeValue(NAME));
                this.vdb.setDescription(vdbElement.getAttributeValue(DESCRIPTION));
                this.vdb.setVersion("1");
                List modelElements = vdbElement.getChildren(MODELS);
                for (Element modelElement : modelElements) {
                    BasicModelInfo model = new BasicModelInfo(StringUtil.getFirstToken((String)modelElement.getAttributeValue(NAME), (String)"."));
                    model.setModelType(ModelType.parseString((String)modelElement.getAttributeValue(MODEL_TYPE)));
                    model.setPath(modelElement.getAttributeValue(MODEL_PATH));
                    model.setUuid(modelElement.getAttributeValue(UUID));
                    model.setModelURI(modelElement.getAttributeValue(PRIMARY_METAMODEL_URI));
                    String visibility = modelElement.getAttributeValue(ACCESSIBILITY);
                    if (visibility != null) {
                        model.setVisibility("Public".equals(visibility) ? (short)0 : 2);
                    }
                    List markers = modelElement.getChildren(MARKERS);
                    for (Element marker : markers) {
                        String severity = marker.getAttributeValue(SEVERITY);
                        if (!severity.equals(ERROR)) continue;
                        this.validityErrors.add(marker.getAttributeValue(MESSAGE));
                    }
                    this.vdb.addModelInfo(model);
                }
            }
        }
        catch (JDOMException e) {
            throw new IOException("Failed to read the VDB-Manifest file");
        }
    }

    public String[] getValidityErrors() {
        if (!this.validityErrors.isEmpty()) {
            return this.validityErrors.toArray(new String[this.validityErrors.size()]);
        }
        return null;
    }

    public BasicVDBDefn getVDB() {
        return this.vdb;
    }
}

