/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.vdb.api;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.vdb.api.DEFReaderWriter;
import com.metamatrix.common.vdb.api.Manifest;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.core.util.ZipFileUtil;
import com.metamatrix.vdb.materialization.ScriptType;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class VDBArchive {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private TempDirectory tempDirectory;
    boolean open = false;
    BasicVDBDefn def;
    char[] dataRoles;
    Manifest manifest;
    boolean wsdlAvailable = false;
    File vdbFile;
    HashSet<String> pathsInArchive = new HashSet();

    public VDBArchive(File vdbFile) throws IOException {
        this.load(vdbFile);
    }

    public VDBArchive(InputStream vdbStream) throws IOException {
        if (vdbStream == null) {
            throw new IllegalArgumentException();
        }
        this.open();
        File dummyName = new File(this.tempDirectory.getPath(), Math.abs(RANDOM.nextLong()) + ".vdb");
        FileUtils.write((InputStream)vdbStream, (File)dummyName);
        this.load(dummyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File vdbFile) throws IOException {
        if (vdbFile == null || !vdbFile.exists()) {
            throw new IllegalArgumentException();
        }
        this.open();
        ZipFile archive = new ZipFile(vdbFile);
        try {
            InputStream wsdlStream;
            InputStream rolesStream;
            InputStream defStream;
            this.pathsInArchive = this.getListOfEntries(archive);
            InputStream manifestStream = this.getStream("MetaMatrix-VdbManifestModel.xmi", archive);
            if (manifestStream != null) {
                this.manifest = new Manifest();
                this.manifest.load(manifestStream);
            }
            if ((defStream = this.getStream("ConfigurationInfo.def", archive)) != null) {
                this.def = VDBArchive.readFromDef(defStream);
                defStream.close();
            }
            if ((rolesStream = this.getStream("dataroles.xml", archive)) != null) {
                File rolesFile = new File(this.tempDirectory.getPath(), Math.abs(RANDOM.nextLong()) + "_roles.xml");
                FileUtils.write((InputStream)rolesStream, (File)rolesFile);
                rolesStream.close();
                this.dataRoles = FileUtil.read((Reader)new FileReader(rolesFile)).toCharArray();
            }
            if ((wsdlStream = this.getStream("MetaMatrixDataServices.wsdl", archive)) != null) {
                this.wsdlAvailable = true;
                wsdlStream.close();
            }
            this.vdbFile = vdbFile;
            if (this.def == null) {
                this.def = this.manifest.getVDB();
            } else {
                this.appendManifest(this.def, this.manifest);
            }
        }
        finally {
            archive.close();
        }
    }

    private void appendManifest(BasicVDBDefn mydef, Manifest manifest) {
        if (mydef == null || manifest == null) {
            return;
        }
        Collection models = mydef.getModels();
        BasicVDBDefn manifestVdb = manifest.getVDB();
        if (models == null || models.isEmpty()) {
            mydef.setModelInfos(manifestVdb.getModels());
        }
        for (BasicModelInfo defModel : models) {
            ModelInfo manifestModel = manifestVdb.getModel(defModel.getName());
            if (manifestModel == null) continue;
            defModel.setModelType(manifestModel.getModelType());
            defModel.setPath(manifestModel.getPath());
            defModel.setUuid(manifestModel.getUUID());
            defModel.setModelURI(manifestModel.getModelURI());
        }
    }

    private InputStream getStream(String wantedFile, ZipFile archive) throws IOException {
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry == null || !entry.getName().equalsIgnoreCase(wantedFile)) continue;
            return archive.getInputStream(entry);
        }
        return null;
    }

    private HashSet<String> getListOfEntries(ZipFile archive) throws IOException {
        HashSet<String> files = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            files.add(entry.getName());
        }
        return files;
    }

    private File getTempName(String ext) {
        File parent = new File(this.tempDirectory.getPath() + File.separator + "workspace");
        parent.mkdirs();
        return new File(parent, Math.abs(RANDOM.nextLong()) + "." + ext);
    }

    private void open() {
        if (!this.open) {
            this.tempDirectory = new TempDirectory(FileUtils.TEMP_DIRECTORY + File.separator + "teiid", System.currentTimeMillis(), RANDOM.nextLong());
            this.tempDirectory.create();
            this.open = true;
        }
    }

    private void checkOpen() {
        if (!this.open) {
            throw new IllegalStateException("Archive already closed");
        }
    }

    public static BasicVDBDefn readFromDef(InputStream defStream) throws IOException {
        DEFReaderWriter reader = new DEFReaderWriter();
        BasicVDBDefn vdbDefn = reader.read(defStream);
        return vdbDefn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigurationDef(BasicVDBDefn vdbDef) throws IOException {
        if (vdbDef == null) {
            return;
        }
        File f = this.getTempName("xml");
        DEFReaderWriter writer = new DEFReaderWriter();
        FileOutputStream fos = new FileOutputStream(f);
        writer.write(fos, vdbDef, new Properties());
        fos.close();
        InputStream in = null;
        try {
            in = new FileInputStream(f);
            ZipFileUtil.replace((File)this.vdbFile, (String)"ConfigurationInfo.def", (InputStream)in);
        }
        finally {
            in.close();
            f.delete();
        }
        this.def = vdbDef;
        this.appendManifest(this.def, this.manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRoles(char[] roles) throws IOException {
        if (roles != null && roles.length > 0) {
            this.checkOpen();
            File f = this.getTempName("bin");
            FileWriter fw = new FileWriter(f);
            fw.write(roles);
            fw.close();
            InputStream in = null;
            try {
                in = new FileInputStream(f);
                ZipFileUtil.replace((File)this.vdbFile, (String)"dataroles.xml", (InputStream)in);
            }
            finally {
                in.close();
                f.delete();
            }
        }
    }

    public void close() {
        if (this.open) {
            File dir = new File(this.tempDirectory.getPath());
            FileUtils.removeChildrenRecursively((File)dir);
            dir.delete();
            this.open = false;
        }
    }

    public BasicVDBDefn getConfigurationDef() {
        this.checkOpen();
        return this.def;
    }

    public char[] getDataRoles() {
        this.checkOpen();
        return this.dataRoles;
    }

    public InputStream getInputStream() throws IOException {
        this.checkOpen();
        return new FileInputStream(this.vdbFile);
    }

    public String[] getVDBValidityErrors() {
        return this.manifest.getValidityErrors();
    }

    public void write(OutputStream out) throws IOException {
        this.checkOpen();
        FileUtils.write((File)this.vdbFile, (OutputStream)out);
    }

    public String getName() {
        this.checkOpen();
        return this.def.getName();
    }

    public void setName(String name) {
        this.checkOpen();
        if (this.def != null) {
            this.def.setName(name);
        }
    }

    public String getVersion() {
        this.checkOpen();
        return this.def.getVersion();
    }

    public short getStatus() {
        this.checkOpen();
        if (this.getVDBValidityErrors() != null && this.getVDBValidityErrors().length > 0) {
            return 1;
        }
        return this.def.getStatus();
    }

    public void setStatus(short status) {
        this.checkOpen();
        this.def.setStatus(status);
    }

    public Set<String> getEntries() {
        return new HashSet<String>(this.pathsInArchive);
    }

    public boolean isVisible(String pathInVdb) {
        if (this.pathsInArchive.contains(pathInVdb)) {
            String entry = StringUtil.getLastToken((String)pathInVdb, (String)"/");
            if (entry.endsWith(".INDEX") || entry.endsWith(".SEARCH_INDEX")) {
                return true;
            }
            if (entry.equalsIgnoreCase("MetaMatrix-VdbManifestModel.xmi")) {
                return false;
            }
            if (entry.startsWith("MaterializationModel") && entry.endsWith(".xmi")) {
                return false;
            }
            if (ScriptType.isDDLScript(entry)) {
                return false;
            }
            if (entry.equalsIgnoreCase("MetaMatrixDataServices.wsdl")) {
                return true;
            }
            return true;
        }
        return false;
    }

    public static byte[] writeToByteArray(VDBArchive vdb) throws MetaMatrixComponentException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            vdb.write(bos);
            byte[] contents = bos.toByteArray();
            bos.close();
            return contents;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public String toString() {
        return this.getName() + "_" + this.getVersion();
    }
}

