/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.vdb.api;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.vdb.api.VDBStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class VDBStreamImpl
implements VDBStream {
    File file;
    byte[] contents;

    public VDBStreamImpl(File file) {
        this.file = file;
    }

    public VDBStreamImpl(byte[] contents) {
        this.contents = contents;
    }

    @Override
    public File getFile() {
        if (this.file != null && this.file.exists()) {
            return this.file;
        }
        throw new UnsupportedOperationException(CommonPlugin.Util.getString("VDBArchiveSotRef.File_doesnt_exist", new Object[]{this.file}));
    }

    @Override
    public InputStream getInputStream() {
        if (this.file != null && this.file.exists()) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (this.contents != null && this.contents.length > 0) {
            return new ByteArrayInputStream(this.contents);
        }
        return null;
    }

    @Override
    public byte[] toByteArray() {
        if (this.contents != null && this.contents.length > 0) {
            return this.contents;
        }
        throw new UnsupportedOperationException("Contents not found");
    }
}

