/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xml.xmi;

import com.metamatrix.api.core.xmi.XMIHeader;
import com.metamatrix.common.CommonPlugin;
import java.io.IOException;
import java.util.Collection;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMIHeaderContentHandler
implements ContentHandler {
    private XMIHeader header = new XMIHeader();
    private String currentTagName = null;
    private boolean foundXMIStartElement = false;
    private boolean foundHeaderStartElement = false;
    private boolean foundHeaderEndElement = false;

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.currentTagName = localName;
        if (localName.equals("XMI")) {
            this.foundXMIStartElement = true;
        } else if (localName.equals("XMI.header")) {
            this.foundHeaderStartElement = true;
        }
        this.checkHeader();
        this.processStartElement(localName, atts);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.checkHeader();
        String data = new String(ch, start, length);
        this.processElementContent(data.trim());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.checkHeader();
        String data = new String(ch, start, length);
        this.processElementContent(data.trim());
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkHeader();
        if (localName.equals("XMI.header")) {
            this.foundHeaderEndElement = true;
        }
        this.currentTagName = null;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public XMIHeader getHeader() {
        return this.header;
    }

    public void complete() throws SAXException {
    }

    protected void checkHeader() throws SAXException {
        if (!this.foundXMIStartElement) {
            throw new XMINotFoundException();
        }
        if (this.foundHeaderStartElement && this.foundHeaderEndElement) {
            this.complete();
        }
    }

    private void processStartElement(String tagName, Attributes atts) {
        if (tagName.equals("XMI.model")) {
            HeaderEntryInfo info = new HeaderEntryInfo(atts);
            this.header.addModel(info.getName(), info.getVersion(), info.getHref());
        } else if (tagName.equals("XMI.metamodel")) {
            HeaderEntryInfo info = new HeaderEntryInfo(atts);
            this.header.addMetaModel(info.getName(), info.getVersion(), info.getHref());
        } else if (tagName.equals("XMI.metametamodel")) {
            HeaderEntryInfo info = new HeaderEntryInfo(atts);
            this.header.addMetaMetaModel(info.getName(), info.getVersion(), info.getHref());
        } else if (tagName.equals("XMI.import")) {
            HeaderEntryInfo info = new HeaderEntryInfo(atts);
            this.header.addImport(info.getName(), info.getVersion(), info.getHref());
        }
    }

    private void processElementContent(String content) {
        if (this.currentTagName == null || content == null) {
            return;
        }
        if (this.currentTagName.equals("XMI.owner")) {
            this.header.getDocumentation().setOwner(content);
        } else if (this.currentTagName.equals("XMI.contact")) {
            this.header.getDocumentation().setContact(content);
        } else if (this.currentTagName.equals("XMI.longDescription")) {
            this.header.getDocumentation().setLongDescription(content);
        } else if (this.currentTagName.equals("XMI.shortDescription")) {
            this.header.getDocumentation().setShortDescription(content);
        } else if (this.currentTagName.equals("XMI.exporter")) {
            this.header.getDocumentation().setExporter(content);
        } else if (this.currentTagName.equals("XMI.exporterVersion")) {
            this.header.getDocumentation().setExporterVersion(content);
        } else if (this.currentTagName.equals("XMI.exporterID")) {
            this.header.getDocumentation().setExporterID(content);
        } else if (this.currentTagName.equals("XMI.notice")) {
            this.header.getDocumentation().setNotice(content);
        } else if (this.currentTagName.equals("XMI.model")) {
            XMIHeader.Model model = (XMIHeader.Model)this.getLastElement(this.header.getModels());
            model.addContent(content);
        } else if (this.currentTagName.equals("XMI.metamodel")) {
            XMIHeader.Model model = (XMIHeader.Model)this.getLastElement(this.header.getMetaModels());
            model.addContent(content);
        } else if (this.currentTagName.equals("XMI.metametamodel")) {
            XMIHeader.Model model = (XMIHeader.Model)this.getLastElement(this.header.getMetaMetaModels());
            model.addContent(content);
        } else if (this.currentTagName.equals("XMI.import")) {
            XMIHeader.Import imp = (XMIHeader.Import)this.getLastElement(this.header.getImports());
            imp.addContent(content);
        }
    }

    private Object getLastElement(Collection elements) {
        Object lastElement2 = null;
        for (Object lastElement2 : elements) {
        }
        return lastElement2;
    }

    private static class HeaderEntryInfo {
        private String href;
        private String name;
        private String version;

        public HeaderEntryInfo(Attributes atts) {
            String attName = null;
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                attName = atts.getLocalName(i);
                if (attName.equals("xmi.name")) {
                    this.name = atts.getValue(i);
                    continue;
                }
                if (attName.equals("xmi.version")) {
                    this.version = atts.getValue(i);
                    continue;
                }
                if (!attName.equals("href")) continue;
                this.href = atts.getValue(i);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }
    }

    private static class XMINotFoundException
    extends SAXException {
        XMINotFoundException() {
            super(CommonPlugin.Util.getString("ERR.003.032.0008"));
        }
    }
}

