/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.event;

import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.event.AbstractEventBroker;
import java.util.EventObject;
import java.util.concurrent.TimeUnit;

public class AsynchEventBroker
extends AbstractEventBroker {
    private WorkerPool workerPool = WorkerPoolFactory.newWorkerPool("AsyncEventBroker", 1, 120000L);
    private static final String DEFAULT_NAME = CorePlugin.Util.getString("AsynchEventBroker.DefaultName");
    private static final long SHUTDOWN_TIMEOUT_MILLIS = 10000L;

    public AsynchEventBroker() {
        this(null);
    }

    public AsynchEventBroker(String name) {
        if (name == null) {
            name = DEFAULT_NAME;
        }
        super.setName(name);
    }

    @Override
    public boolean hasUnprocessedEvents() {
        return this.workerPool.hasWork();
    }

    @Override
    protected final void process(final EventObject obj) {
        this.workerPool.execute(new Runnable(){

            @Override
            public void run() {
                AsynchEventBroker.this.notifyListeners(obj);
            }
        });
    }

    @Override
    protected void waitToCompleteShutdown() {
        this.workerPool.shutdown();
        try {
            this.workerPool.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }
}

