/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.TempDirectoryMonitor;
import java.io.File;
import java.util.Random;

public class TempDirectory {
    private static TempDirectoryMonitor monitor;
    private String path;

    public static void setMonitor(TempDirectoryMonitor tempDirectoryMonitor) {
        monitor = tempDirectoryMonitor;
    }

    public TempDirectory(String tempDirPath, long time, long randomNumber) {
        randomNumber = Math.abs(randomNumber);
        if (tempDirPath == null || tempDirPath.length() == 0) {
            this.path = FileUtils.TEMP_DIRECTORY + time + "_" + randomNumber;
        } else {
            String basePath = tempDirPath.endsWith(File.separator) ? tempDirPath : tempDirPath + File.separator;
            this.path = basePath + time + "_" + randomNumber;
        }
    }

    public TempDirectory(long time, long randomNumber) {
        this(FileUtils.TEMP_DIRECTORY, time, randomNumber);
    }

    public String getPath() {
        return this.path;
    }

    public void create() {
        new File(this.path).mkdirs();
        if (monitor != null) {
            monitor.createdTempDirectory(this);
        }
    }

    public void remove() {
        File directory = new File(this.path);
        if (directory.exists()) {
            FileUtils.removeDirectoryAndChildren((File)directory);
        }
    }

    public void finalize() {
        this.remove();
    }

    public static synchronized TempDirectory getTempDirectory(String parentDirectoryPath) {
        Random RANDOM = new Random(System.currentTimeMillis());
        File parentDirectory = null;
        parentDirectory = parentDirectoryPath != null ? new File(parentDirectoryPath) : new File(FileUtils.TEMP_DIRECTORY);
        String absolutePath = parentDirectory.getAbsolutePath();
        TempDirectory tempDirectory = new TempDirectory(absolutePath, System.currentTimeMillis(), RANDOM.nextLong());
        while (new File(tempDirectory.getPath()).exists()) {
            LogManager.logWarning("CONFIG", "Temporary Folder " + tempDirectory.getPath() + " already exists; Creating new folder...");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            tempDirectory = new TempDirectory(absolutePath, System.currentTimeMillis(), RANDOM.nextLong());
        }
        tempDirectory.create();
        return tempDirectory;
    }
}

