/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.vdb;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.xml.CoreXmlPlugin;
import com.metamatrix.internal.core.xml.vdb.TerminatingVdbHeaderContentHandler;
import com.metamatrix.internal.core.xml.vdb.VdbHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class VdbHeaderReader {
    private static final String XML_DECLARATION_PREFIX_STRING = "<?xml version=";
    private static final String VDB_FILE_EXTENSION = ".vdb";
    private static final String MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi";
    private static final String LOWER_CASE_MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi".toLowerCase();

    public static VdbHeader readHeader(File file) throws MetaMatrixCoreException {
        if (file != null && file.isFile() && file.exists() && file.length() > 0L) {
            String lowerCaseFileName = file.getName().toLowerCase();
            if (lowerCaseFileName.endsWith(VDB_FILE_EXTENSION)) {
                ZipFile zipFile = null;
                InputStream iStream = null;
                VdbHeader header = null;
                try {
                    zipFile = new ZipFile(file);
                    iStream = VdbHeaderReader.getManifestStreamFromVdbArchive(zipFile);
                    if (iStream == null) {
                        VdbHeader vdbHeader = null;
                        return vdbHeader;
                    }
                    VdbHeaderReader reader = new VdbHeaderReader();
                    header = reader.read(iStream);
                }
                catch (IOException e) {
                    throw new MetaMatrixRuntimeException((Throwable)e);
                }
                finally {
                    if (iStream != null) {
                        try {
                            iStream.close();
                        }
                        catch (IOException err) {}
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {}
                    }
                }
                return header;
            }
            if (LOWER_CASE_MANIFEST_MODEL_NAME.equals(lowerCaseFileName)) {
                VdbHeaderReader reader = new VdbHeaderReader();
                return reader.read(file);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VdbHeader read(InputStream istream) throws MetaMatrixCoreException {
        if (istream == null) {
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_InputStream_reference_may_not_be_null._1");
            throw new IllegalArgumentException(msg);
        }
        TerminatingVdbHeaderContentHandler handler = new TerminatingVdbHeaderContentHandler();
        try {
            Thread.currentThread().setContextClassLoader(VdbHeaderReader.class.getClassLoader());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(new InputSource(istream), (DefaultHandler)handler);
            return handler.getVdbHeader();
        }
        catch (SAXException e) {
            if (!"HeaderFoundException".equals(e.getMessage()) && !"XMINotFoundException".equals(e.getMessage()) && !(e instanceof SAXParseException)) return handler.getVdbHeader();
        }
        catch (IOException e) {
            return handler.getVdbHeader();
        }
        catch (Throwable e) {
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.Error_in_parsing_file_1");
            throw new MetaMatrixCoreException(e, msg);
        }
        return handler.getVdbHeader();
    }

    public VdbHeader read(File file) throws MetaMatrixCoreException {
        if (file == null) {
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_file_reference_may_not_be_null_2");
            throw new IllegalArgumentException(msg);
        }
        if (!file.exists()) {
            Object[] params = new Object[]{file};
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_file_0_does_not_exist_and_therefore_cannot_be_read._3", params);
            throw new IllegalArgumentException(msg);
        }
        if (!file.canRead()) {
            Object[] params = new Object[]{file};
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_file_0_does_not_have_read_privileges._4", params);
            throw new IllegalArgumentException(msg);
        }
        if (!VdbHeaderReader.isXmlFile(file)) {
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            VdbHeader vdbHeader = this.read(bis);
            return vdbHeader;
        }
        catch (FileNotFoundException e) {
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.Error_in_parsing_file_1");
            throw new MetaMatrixCoreException((Throwable)e, msg);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXmlFile(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buf = new byte[32];
            fis.read(buf);
            if (new String(buf).startsWith(XML_DECLARATION_PREFIX_STRING)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private static InputStream getManifestStreamFromVdbArchive(ZipFile zipFile) {
        return VdbHeaderReader.getEntryStreamFromArchive(zipFile, MANIFEST_MODEL_NAME);
    }

    private static InputStream getEntryStreamFromArchive(ZipFile zipFile, String zipEntryName) {
        ArgCheck.isNotNull((Object)zipFile);
        ArgCheck.isNotEmpty((String)zipEntryName);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry == null || !entry.getName().equalsIgnoreCase(zipEntryName)) continue;
                return zipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return null;
    }
}

