/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xmi;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.xml.CoreXmlPlugin;
import com.metamatrix.internal.core.xml.xmi.TerminatingXMIHeaderContentHandler;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMIHeaderReader {
    private static final String XML_DECLARATION_PREFIX_STRING = "<?xml version=";

    public static XMIHeader readHeader(InputStream istream) throws MetaMatrixCoreException {
        XMIHeaderReader reader = new XMIHeaderReader();
        return reader.read(istream);
    }

    public static XMIHeader readHeader(File file) throws MetaMatrixCoreException {
        XMIHeaderReader reader = new XMIHeaderReader();
        return reader.read(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMIHeader read(InputStream istream) throws MetaMatrixCoreException {
        if (istream == null) {
            String msg = CoreXmlPlugin.Util.getString("XMIHeaderReader.The_InputStream_reference_may_not_be_null._1");
            throw new IllegalArgumentException(msg);
        }
        TerminatingXMIHeaderContentHandler handler = new TerminatingXMIHeaderContentHandler();
        try {
            Thread.currentThread().setContextClassLoader(XMIHeaderReader.class.getClassLoader());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(new InputSource(istream), (DefaultHandler)handler);
            return handler.getXmiHeader();
        }
        catch (SAXException e) {
            if (!"HeaderFoundException".equals(e.getMessage()) && !"XMINotFoundException".equals(e.getMessage()) && !(e instanceof SAXParseException)) return handler.getXmiHeader();
        }
        catch (IOException e) {
            return handler.getXmiHeader();
        }
        catch (Throwable e) {
            String msg = CoreXmlPlugin.Util.getString("XMIHeaderReader.Error_in_parsing_file_1");
            throw new MetaMatrixCoreException(e, msg);
        }
        return handler.getXmiHeader();
    }

    public XMIHeader read(File file) throws MetaMatrixCoreException {
        if (file == null) {
            String msg = CoreXmlPlugin.Util.getString("XMIHeaderReader.The_file_reference_may_not_be_null_2");
            throw new IllegalArgumentException(msg);
        }
        if (!file.exists()) {
            Object[] params = new Object[]{file};
            String msg = CoreXmlPlugin.Util.getString("XMIHeaderReader.The_file_0_does_not_exist_and_therefore_cannot_be_read._3", params);
            throw new IllegalArgumentException(msg);
        }
        if (!file.canRead()) {
            Object[] params = new Object[]{file};
            String msg = CoreXmlPlugin.Util.getString("XMIHeaderReader.The_file_0_does_not_have_read_privileges._4", params);
            throw new IllegalArgumentException(msg);
        }
        if (!XMIHeaderReader.isXmlFile(file)) {
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            XMIHeader xMIHeader = this.read(bis);
            return xMIHeader;
        }
        catch (FileNotFoundException e) {
            String msg = CoreXmlPlugin.Util.getString("XMIHeaderReader.Error_in_parsing_file_1");
            throw new MetaMatrixCoreException((Throwable)e, msg);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXmlFile(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buf = new byte[32];
            fis.read(buf);
            if (new String(buf).startsWith(XML_DECLARATION_PREFIX_STRING)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }
}

