/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.api;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.platform.admin.api.SubSystemAdminAPI;
import com.metamatrix.platform.admin.api.runtime.PscID;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface RuntimeStateAdminAPI
extends SubSystemAdminAPI {
    public boolean isSystemStarted() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public List getServices() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public List getHosts() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void stopService(ServiceID var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void stopServiceNow(ServiceID var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void stopProcess(String var1, String var2, boolean var3) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void shutdownServer() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void bounceServer() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public SystemState getSystemState() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void restartService(ServiceID var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void startHost(String var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void startProcess(String var1, String var2) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void stopHost(String var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException;

    public void stopHostNow(String var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException;

    public void startPSC(PscID var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException;

    public void stopPSC(PscID var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException;

    public void stopPSCNow(PscID var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException;

    public void synchronizeServer() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException;

    public Date getServerStartTime() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void setLoggingConfiguration(Configuration var1, LogConfiguration var2, List var3) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public void setLoggingConfiguration(LogConfiguration var1, String var2, String var3) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public Collection getServiceQueueStatistics(ServiceID var1) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public WorkerPoolStats getServiceQueueStatistics(ServiceID var1, String var2) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public ProcessStatistics getProcessStatistics(String var1, String var2) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public PscID getPscIDByName(String var1, String var2, String var3) throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException;

    public ServiceID getServiceIDByName(String var1, String var2, String var3) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;

    public List getVMControllerBindings() throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException;

    public List getLogEntries(Date var1, Date var2, List var3, List var4, int var5) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException;
}

