/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.api.runtime;

import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.platform.admin.api.runtime.ComponentData;
import com.metamatrix.platform.admin.api.runtime.PscID;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import java.util.Collection;

public class PSCData
extends ComponentData {
    private Collection services;
    private PscID pscID;

    public PSCData(ProductServiceConfigID pscConfigID, Collection services, String processName) {
        super(pscConfigID.getName(), false, false);
        this.pscID = new PscID(pscConfigID, processName);
        this.services = services;
        boolean deployed = false;
        boolean registered = false;
        for (ServiceData sd : services) {
            if (sd.isDeployed()) {
                deployed = true;
            }
            if (sd.isRegistered()) {
                registered = true;
            }
            if (!(deployed & registered)) continue;
            break;
        }
        this.deployed = deployed;
        this.registered = registered;
    }

    public Collection getServices() {
        return this.services;
    }

    public PscID getPscID() {
        return this.pscID;
    }

    public String getProcessName() {
        return this.pscID.getProcessName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PSCData) {
            PSCData that = (PSCData)obj;
            return this.pscID.equals(that.getPscID());
        }
        return false;
    }
}

