/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.api.runtime;

import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.model.BasicServiceComponentDefn;
import com.metamatrix.platform.admin.api.runtime.ComponentData;
import com.metamatrix.platform.service.api.ServiceID;
import java.util.Collection;
import java.util.Date;

public class ServiceData
extends ComponentData {
    private ServiceID serviceID;
    private int currentState;
    private Date stateChangeTime;
    private boolean essential;
    private DeployedComponent deployedComponent;
    private ComponentDefnID defnID;
    private Collection queueNames;
    private Throwable initError;

    public ServiceData(ServiceID serviceID, String serviceName, String instanceName, ComponentDefnID defnID, DeployedComponent deployedComponent, Collection queueNames, int state, Date time, boolean essential, boolean deployed, boolean registered, Throwable initError) {
        super(BasicServiceComponentDefn.getDisplayableName(deployedComponent.getName()), deployed, registered);
        this.serviceID = serviceID;
        this.defnID = defnID;
        this.deployedComponent = deployedComponent;
        this.queueNames = queueNames;
        this.currentState = state;
        this.stateChangeTime = time;
        this.essential = essential;
        this.initError = initError;
        this.computeHashCode();
    }

    public Collection getQueueNames() {
        return this.queueNames;
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public Date getStateChangeTime() {
        return this.stateChangeTime;
    }

    public ComponentDefnID getComponentDefnID() {
        return this.defnID;
    }

    public DeployedComponent getDeployedComponent() {
        return this.deployedComponent;
    }

    public Throwable getInitError() {
        return this.initError;
    }

    public boolean isEssential() {
        return this.essential;
    }

    private void computeHashCode() {
        this.hashCode = this.defnID.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceData) {
            ServiceData that = (ServiceData)obj;
            return this.deployedComponent.equals(that.getDeployedComponent());
        }
        return false;
    }
}

