/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.api.PermissionDataNodeDefinition;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.exception.PermissionNodeNotActionableException;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeTreeViewImpl;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.SecurityPlugin;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PermissionDataNodeImpl
extends BasicTreeNode
implements PermissionDataNode,
Serializable,
Comparable {
    private int actionsCreatedWith;
    private int descendantActions;
    private AuthorizationActions actions;
    private AuthorizationActions allowedActions;
    private boolean isHidden;
    private boolean isPhysical;
    private int hashCode;

    public PermissionDataNodeImpl(BasicTreeNode parent, AuthorizationActions allowedActions, PermissionDataNodeDefinition nodeDefinition, boolean nodeIsPhysical, ObjectID guid) {
        super(parent, nodeDefinition.getDisplayName(), nodeDefinition, guid);
        this.allowedActions = allowedActions;
        this.descendantActions = 0;
        this.actions = StandardAuthorizationActions.NONE;
        this.actionsCreatedWith = this.actions.getValue();
        this.isHidden = false;
        this.isPhysical = nodeIsPhysical;
        this.hashCode = nodeDefinition.getName().hashCode();
        this.setModified(false, false);
    }

    @Override
    public int getDataNodeType() {
        return ((PermissionDataNodeDefinition)this.getType()).getType();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getResourceName() {
        return this.getType().getName();
    }

    @Override
    public boolean isPhysical() {
        return this.isPhysical;
    }

    @Override
    public boolean hasPermission() {
        return !this.actions.equals(StandardAuthorizationActions.NONE);
    }

    @Override
    public ObjectID getUUID() {
        return this.getGlobalUID();
    }

    @Override
    public String[] getActionLabels() {
        return this.actions.getLabels();
    }

    @Override
    public AuthorizationActions getActions() {
        return this.actions;
    }

    @Override
    public AuthorizationActions getAllowedActions() {
        return this.allowedActions;
    }

    @Override
    public void setActions(AuthorizationActions actions) throws PermissionNodeNotActionableException {
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "setActions(AuthoriztionActions): setting <" + actions + "> on <" + this.getType().getName() + ">: Allowed actions: <" + this.allowedActions + ">");
        if (!this.allowedActions.implies(actions)) {
            throw new PermissionNodeNotActionableException("ERR.014.001.0040", SecurityPlugin.Util.getString("ERR.014.001.0040", new Object[]{this.getType().getName(), actions.toString()}));
        }
        this.actions = actions;
        this.setModified(true, false);
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "setActions(AuthorizationActions): set <" + this.actions + "> on <" + this.getType().getName() + ">");
    }

    @Override
    public void setActions(int actions) throws PermissionNodeNotActionableException {
        AuthorizationActions newActions = StandardAuthorizationActions.getAuthorizationActions(actions);
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "setActions(int): setting <" + newActions + "> on <" + this.getType().getName() + ">: Allowed actions: <" + this.allowedActions + ">");
        if (!this.allowedActions.implies(newActions)) {
            throw new PermissionNodeNotActionableException("ERR.014.001.0040", SecurityPlugin.Util.getString("ERR.014.001.0040", new Object[]{this.getType().getName(), newActions.toString()}));
        }
        this.actions = newActions;
        this.setModified(true, false);
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "setActions(int): set <" + this.actions + "> on <" + this.getType().getName() + ">");
    }

    private void privlegedSetActions(AuthorizationActions actions) {
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "privlegedSetActions(AuthoriztionActions): setting <" + actions + "> on <" + this.getType().getName() + ">: Allowed actions: <" + this.allowedActions + ">");
        this.actions = StandardAuthorizationActions.getAuthorizationActions(actions.getValue() & this.allowedActions.getValue());
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "privlegedSetActions(AuthoriztionActions): Actions now: <" + this.actions + "> on <" + this.getType().getName() + ">");
    }

    void setInitialActions(AuthorizationActions initialActions) {
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "setInitialActions(AuthoriztionActions): setting <" + initialActions + "> on <" + this.getType().getName() + ">: Allowed actions: <" + this.allowedActions + ">");
        this.actionsCreatedWith = initialActions.getValue();
        this.actions = initialActions;
    }

    public AuthorizationActions getOriginalActions() {
        return StandardAuthorizationActions.getAuthorizationActions(this.actionsCreatedWith);
    }

    public void setAllowedActions(AuthorizationActions actions) {
        this.allowedActions = actions;
    }

    void resetNode() {
        this.actions = StandardAuthorizationActions.getAuthorizationActions(this.actionsCreatedWith);
        this.setModified(false, false);
    }

    @Override
    public boolean actionsAreEqual(AuthorizationActions actions) {
        return this.actions.equals(actions);
    }

    @Override
    public boolean actionsAreEqual(String[] actions) {
        AuthorizationActions thoseActions = StandardAuthorizationActions.getAuthorizationActions(actions);
        return this.actions.equals(thoseActions);
    }

    @Override
    public boolean actionsAreEqual(PermissionNode node) {
        AuthorizationActions thoseActions = node.getActions();
        return this.actions.equals(thoseActions);
    }

    @Override
    public boolean isDescendantEnabled() {
        return this.descendantActions != 0;
    }

    @Override
    public boolean isDescendantEnabledFor(AuthorizationActions actions) {
        return (this.descendantActions & actions.getValue()) != 0;
    }

    public boolean allChildrenEnabledFor(AuthorizationActions actions) {
        int actionsInQuestion = actions.getValue();
        List children = this.getChildren();
        for (PermissionDataNodeImpl child : children) {
            if ((actionsInQuestion & child.getActions().getValue()) == actionsInQuestion) continue;
            return false;
        }
        return true;
    }

    public boolean isRecursive() {
        return !this.isLeafNode() && this.actions.equals(StandardAuthorizationActions.getCommonActions(this.actions.getValue(), PermissionDataNodeImpl.getActionsCommonToChildren(this)));
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    @Override
    public boolean isLeafNode() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean isGroupNode() {
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(this, true, false, nodes);
        if (nodes.size() == 0) {
            return false;
        }
        for (PermissionDataNodeImpl aChild : nodes) {
            if (aChild.getChildCount() <= 0) continue;
            return false;
        }
        return true;
    }

    public AuthorizationActions getDescendantActions() {
        return StandardAuthorizationActions.getAuthorizationActions(this.descendantActions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean areEqual = false;
        if (obj instanceof PermissionDataNodeImpl) {
            PermissionDataNodeImpl that = (PermissionDataNodeImpl)obj;
            areEqual = this.getType().getName().equals(that.getResourceName());
        }
        return areEqual;
    }

    @Override
    public int compareTo(Object obj) {
        PermissionDataNodeImpl that = (PermissionDataNodeImpl)obj;
        if (obj == null) {
            Assertion.isNotNull((Object)obj, (String)SecurityPlugin.Util.getString("ERR.014.001.0039"));
        }
        if (obj == this) {
            return 0;
        }
        return PermissionDataNodeImpl.compare(this, that);
    }

    public static final int compare(PermissionDataNodeImpl obj1, PermissionDataNodeImpl obj2) {
        int resourceDiff = obj1.getResourceName().compareTo(obj2.getResourceName());
        if (resourceDiff != 0) {
            return resourceDiff;
        }
        return obj1.getUUID().compareTo((Object)obj2.getUUID());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.getType().getName() + " " + this.actions;
    }

    @Override
    public String printDebug() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nResource: " + this.getType().getName());
        buf.append("\n    Actions: " + this.actions);
        buf.append("\n    Has Permission: " + (this.hasPermission() ? "YES" : "NO"));
        buf.append("\n    Descendant Enabled: " + (this.isDescendantEnabled() ? "ENABLED-" + StandardAuthorizationActions.getAuthorizationActions(this.descendantActions) : "DISABLED"));
        buf.append("\n    Is Leaf Node: " + (this.isLeafNode() ? "YES" : "NO"));
        buf.append("\n    Is Hidden: " + (this.isHidden() ? "YES" : "NO"));
        buf.append("\n    Modified: " + (this.isModified() ? "YES" : "NO"));
        return buf.toString();
    }

    void setPermissionStateAndPropagate(AuthorizationActions actions, boolean modified) {
        this.privlegedSetActions(actions);
        this.setModified(modified, false);
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "setPermissionStateAndPropagate: Propagating effected node: <" + this.toString() + "> Modified: <" + this.isModified() + ">");
        this.propagateActionsToChildren(actions, modified);
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "setPermissionStateAndPropagate: Done propagating node: <" + this.toString() + ">\n");
    }

    private void propagateActionsToChildren(AuthorizationActions actions, boolean modified) {
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(this, true, false, nodes);
        Iterator nodeItr = nodes.iterator();
        PermissionDataNodeImpl node = this;
        while (nodeItr.hasNext()) {
            node = (PermissionDataNodeImpl)nodeItr.next();
            LogManager.logDetail("AUTHORIZATION_ADMIN_API", "propActsToChildren: Setting <" + actions + "> on node: <" + node + ">");
            AuthorizationActions theActions = StandardAuthorizationActions.getAuthorizationActions(node.getActions().getValue() | actions.getValue());
            node.privlegedSetActions(theActions);
            node.setModified(modified, false);
            LogManager.logDetail("AUTHORIZATION_ADMIN_API", "propActsToChildren: Set <" + node.getActions() + "> on node: <" + node + "> Modified: <" + node.isModified() + ">");
        }
        LogManager.logDetail("AUTHORIZATION_ADMIN_API", "propActsToChildren: Now setting descendant enabled with node: <" + node + ">");
        PermissionDataNodeImpl.propagateDescendantEnabled(node);
    }

    private static void propagateDescendantEnabled(PermissionDataNodeImpl child) {
        for (PermissionDataNodeImpl parent = (PermissionDataNodeImpl)child.getParent(); parent != null; parent = (PermissionDataNodeImpl)parent.getParent()) {
            int otherChildrensCompleteActionValues = PermissionDataNodeImpl.getAllOtherChildrensActionValues(parent, child);
            parent.descendantActions = otherChildrensCompleteActionValues | child.getActions().getValue();
            LogManager.logDetail("AUTHORIZATION_ADMIN_API", "propagateDescendantEnabled: Descendant actions for node: <" + parent + ">: <" + parent.getDescendantActions() + ">");
            int actionsCommonToChildren = PermissionDataNodeImpl.getActionsCommonToChildren(parent);
            if (actionsCommonToChildren != 0) {
                AuthorizationActions thisNodesActions = StandardAuthorizationActions.getAuthorizationActions(parent.getActions().getValue() | actionsCommonToChildren);
                parent.privlegedSetActions(thisNodesActions);
                LogManager.logDetail("AUTHORIZATION_ADMIN_API", "Set actions for node: <" + parent + ">: <" + parent.getActions() + ">");
            }
            child = parent;
        }
    }

    private static int getAllOtherChildrensActionValues(PermissionDataNodeImpl parent, PermissionDataNodeImpl childToExclude) {
        int siblingActions = 0;
        ArrayList children = new ArrayList(parent.getChildren());
        children.remove(childToExclude);
        for (PermissionDataNodeImpl child : children) {
            siblingActions |= child.getActions().getValue();
        }
        return siblingActions;
    }

    private static int getActionsCommonToChildren(PermissionDataNodeImpl parent) {
        int commonChildrenActions = -1;
        List children = parent.getChildren();
        for (PermissionDataNodeImpl child : children) {
            if (commonChildrenActions == -1) {
                commonChildrenActions = child.getActions().getValue();
            }
            commonChildrenActions &= child.getActions().getValue();
        }
        return commonChildrenActions == -1 ? 0 : commonChildrenActions;
    }

    static boolean shareActions(int a, int b) {
        return (a & b) != 0;
    }
}

