/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.platform.admin.api.PermissionDataNodeTreeView;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.exception.PermissionNodeNotFoundException;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.BasicAuthorizationPermission;
import com.metamatrix.platform.security.api.SecurityPlugin;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionDataNodeTreeViewImpl
implements PermissionDataNodeTreeView {
    Map resourceLookUp;
    private PermissionDataNodeImpl fakeRoot;
    private boolean showHidden;

    public PermissionDataNodeTreeViewImpl(PermissionNode root) {
        this.fakeRoot = this.assertPermissionDataNode(root);
        this.fakeRoot.setHidden(true);
        this.fakeRoot.setAllowedActions(StandardAuthorizationActions.NONE);
        this.showHidden = false;
    }

    protected PermissionDataNodeImpl assertPermissionDataNode(PermissionNode node) {
        if (node == null) {
            Assertion.isNotNull((Object)node, (String)SecurityPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PermissionDataNode"}));
        }
        if (!(node instanceof PermissionDataNodeImpl)) {
            Assertion.assertTrue((boolean)(node instanceof PermissionDataNodeImpl), (String)SecurityPlugin.Util.getString("ERR.014.001.0041", new Object[]{"PermissionDataNode"}));
        }
        PermissionDataNodeImpl dataNode = (PermissionDataNodeImpl)node;
        return dataNode;
    }

    @Override
    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    @Override
    public void hideAllSystemNodes() {
        List children = this.fakeRoot.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            PermissionDataNodeImpl aNode = (PermissionDataNodeImpl)children.get(i);
            if (!aNode.getResourceName().startsWith("System")) continue;
            this.setBranchHidden(aNode);
        }
    }

    @Override
    public void setMarked(PermissionNode entry, boolean markedState) {
        PermissionDataNodeImpl theEntry = this.assertPermissionDataNode(entry);
        theEntry.setMarked(markedState, false);
    }

    @Override
    public Iterator iterator(PermissionNode startingPoint) {
        PermissionDataNodeImpl theRoot = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(theRoot, this.showHidden, true, nodes);
        return nodes.iterator();
    }

    @Override
    public Iterator iterator() {
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(this.fakeRoot, this.showHidden, true, nodes);
        return nodes.iterator();
    }

    @Override
    public Iterator breadthFirstIterator(PermissionNode startingPoint) {
        PermissionDataNodeImpl theRoot = this.assertPermissionDataNode(startingPoint);
        List nodes = PermissionDataNodeTreeViewImpl.fillNodeListBreadthFirst(theRoot, this.showHidden, true);
        return nodes.iterator();
    }

    @Override
    public Iterator breadthFirstIterator() {
        List nodes = PermissionDataNodeTreeViewImpl.fillNodeListBreadthFirst(this.fakeRoot, this.showHidden, true);
        return nodes.iterator();
    }

    @Override
    public PermissionNode getRoot() {
        return this.fakeRoot;
    }

    @Override
    public List getRoots() {
        return this.fakeRoot.getChildren();
    }

    @Override
    public PermissionNode getParent(PermissionNode node) {
        PermissionDataNodeImpl theNode = this.assertPermissionDataNode(node);
        return (PermissionNode)((Object)theNode.getParent());
    }

    @Override
    public List getChildren(PermissionNode parent) {
        PermissionDataNodeImpl theParent = this.assertPermissionDataNode(parent);
        return theParent.getChildren();
    }

    public boolean isAncestorOf(PermissionNode ancestor, PermissionNode descendant) {
        PermissionDataNodeImpl theAncestor = this.assertPermissionDataNode(ancestor);
        PermissionDataNodeImpl theDescendant = this.assertPermissionDataNode(descendant);
        for (PermissionDataNodeImpl parent = (PermissionDataNodeImpl)theDescendant.getParent(); parent != null; parent = (PermissionDataNodeImpl)parent.getParent()) {
            if (!parent.equals(theAncestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDescendantOf(PermissionNode ancestor, PermissionNode descendant) {
        PermissionDataNodeImpl theAncester = this.assertPermissionDataNode(ancestor);
        PermissionDataNodeImpl theDescendant = this.assertPermissionDataNode(descendant);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(theAncester, true, false, nodes);
        for (PermissionDataNodeImpl node : nodes) {
            if (!node.equals(theDescendant)) continue;
            return true;
        }
        return false;
    }

    public void setBranchAllowedActions(PermissionNode startingPoint, AuthorizationActions actions) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, true, true, nodes);
        for (PermissionDataNodeImpl node : nodes) {
            node.setAllowedActions(actions);
        }
    }

    @Override
    public void setBranchHidden(PermissionNode startingPoint) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, true, true, nodes);
        for (PermissionDataNodeImpl node : nodes) {
            node.setHidden(true);
        }
    }

    @Override
    public void resetTree() {
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(this.fakeRoot, true, true, nodes);
        for (PermissionDataNodeImpl node : nodes) {
            node.resetNode();
        }
    }

    @Override
    public Set getMarked() {
        Iterator nodeItr = this.iterator();
        return PermissionDataNodeTreeViewImpl.getMarkedNodes(nodeItr);
    }

    @Override
    public Set getMarkedDescendants(PermissionNode startingPoint) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, this.showHidden, false, nodes);
        return PermissionDataNodeTreeViewImpl.getMarkedNodes(nodes.iterator());
    }

    @Override
    public List getDescendants(PermissionNode startingPoint) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, this.showHidden, false, nodes);
        ArrayList descendants = new ArrayList();
        Iterator nodeItr = nodes.iterator();
        while (nodeItr.hasNext()) {
            descendants.add(nodeItr.next());
        }
        return descendants;
    }

    public List getDescendantsWithActions(PermissionNode startingPoint, AuthorizationActions actions, boolean strict) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        int commonActionValue = actions.getValue();
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, this.showHidden, false, nodes);
        ArrayList<PermissionDataNodeImpl> descendants = new ArrayList<PermissionDataNodeImpl>();
        for (PermissionDataNodeImpl aNode : nodes) {
            if (strict) {
                if (!aNode.getActions().equals(actions)) continue;
                descendants.add(aNode);
                continue;
            }
            if (!PermissionDataNodeImpl.shareActions(aNode.getActions().getValue(), commonActionValue)) continue;
            descendants.add(aNode);
        }
        return descendants;
    }

    @Override
    public List getModified() {
        Iterator nodeItr = this.iterator();
        return PermissionDataNodeTreeViewImpl.getModifiedNodes(nodeItr);
    }

    @Override
    public List getModifiedBreadthFirst() {
        Iterator nodeItr = this.breadthFirstIterator();
        return PermissionDataNodeTreeViewImpl.getModifiedNodes(nodeItr);
    }

    @Override
    public List getModifiedDescendants(PermissionNode startingPoint) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, this.showHidden, false, nodes);
        return PermissionDataNodeTreeViewImpl.getModifiedNodes(nodes.iterator());
    }

    @Override
    public List getUnModifiedDescendants(PermissionNode startingPoint) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, this.showHidden, false, nodes);
        return PermissionDataNodeTreeViewImpl.getModifiedNodes(nodes.iterator());
    }

    @Override
    public boolean allDescendantsShareActions(PermissionNode startingPoint) {
        PermissionDataNodeImpl root = this.assertPermissionDataNode(startingPoint);
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(root, true, false, nodes);
        for (PermissionDataNodeImpl descendant : nodes) {
            if (descendant.actionsAreEqual(root)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection setPermissions(Collection permissions) {
        ArrayList<PermissionNodeNotFoundException> nodeExceptions = new ArrayList<PermissionNodeNotFoundException>();
        if (permissions.size() > 0) {
            this.initResourceMap();
        }
        for (AuthorizationPermission aPerm : permissions) {
            PermissionDataNodeImpl aNode;
            boolean nodeFound = false;
            String resource = aPerm.getResourceName();
            if (BasicAuthorizationPermission.isRecursiveResource(resource)) {
                resource = BasicAuthorizationPermission.removeRecursion(resource);
            }
            if ((aNode = (PermissionDataNodeImpl)this.resourceLookUp.get(resource)) != null && aNode.getResourceName().equals(resource)) {
                nodeFound = true;
                AuthorizationActions actions = aPerm.getActions();
                aNode.setInitialActions(actions);
            }
            if (!nodeFound) {
                nodeExceptions.add(new PermissionNodeNotFoundException("ERR.014.001.0042", SecurityPlugin.Util.getString("ERR.014.001.0042", new Object[]{resource})));
            }
            nodeFound = false;
        }
        return nodeExceptions;
    }

    static final synchronized void fillNodeList(PermissionDataNodeImpl root, boolean showHidden, boolean includeRoot, List nodes) {
        if (includeRoot && (!root.isHidden() || showHidden)) {
            nodes.add(root);
        }
        Iterator children = root.getChildren().iterator();
        while (children.hasNext()) {
            PermissionDataNodeTreeViewImpl.fillNodeList((PermissionDataNodeImpl)children.next(), showHidden, true, nodes);
        }
    }

    static final synchronized List fillNodeListBreadthFirst(PermissionDataNodeImpl root, boolean showHidden, boolean includeRoot) {
        ArrayList<PermissionDataNodeImpl> nodes = new ArrayList<PermissionDataNodeImpl>();
        if (includeRoot && (!root.isHidden() || showHidden)) {
            nodes.add(root);
        }
        if (nodes.size() == 0) {
            List children = root.getChildren();
            for (PermissionDataNodeImpl child : children) {
                if (child.isHidden() && !showHidden) continue;
                nodes.add(child);
            }
        }
        for (int index = 0; index < nodes.size(); ++index) {
            nodes.addAll(((PermissionDataNodeImpl)nodes.get(index)).getChildren());
        }
        return nodes;
    }

    private static final synchronized Set getMarkedNodes(Iterator nodeItr) {
        HashSet<PermissionDataNodeImpl> markedNodes = new HashSet<PermissionDataNodeImpl>();
        while (nodeItr.hasNext()) {
            PermissionDataNodeImpl node = (PermissionDataNodeImpl)nodeItr.next();
            if (!node.isMarked()) continue;
            markedNodes.add(node);
        }
        return markedNodes;
    }

    private static final synchronized List getModifiedNodes(Iterator nodeItr) {
        ArrayList<PermissionDataNodeImpl> modifiedNodes = new ArrayList<PermissionDataNodeImpl>();
        while (nodeItr.hasNext()) {
            PermissionDataNodeImpl node = (PermissionDataNodeImpl)nodeItr.next();
            if (!node.isModified()) continue;
            modifiedNodes.add(node);
        }
        return modifiedNodes;
    }

    private void initResourceMap() {
        this.resourceLookUp = new HashMap();
        ArrayList nodes = new ArrayList();
        PermissionDataNodeTreeViewImpl.fillNodeList(this.fakeRoot, true, false, nodes);
        for (PermissionDataNodeImpl aNode : nodes) {
            this.resourceLookUp.put(aNode.getResourceName(), aNode);
        }
    }
}

