/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.actions.AbstractObjectEditor;
import com.metamatrix.common.actions.BasicModificationActionQueue;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.security.api.AuthorizationModel;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import com.metamatrix.platform.security.api.AuthorizationPermissionsImpl;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.SecurityPlugin;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractAuthorizationObjectEditor
extends AbstractObjectEditor {
    public static final long serialVersionUID = -3690038844414207808L;

    public AbstractAuthorizationObjectEditor(boolean createActions) {
        super(createActions);
        if (this.doCreateActions()) {
            this.setDestination(new BasicModificationActionQueue());
        }
    }

    public AbstractAuthorizationObjectEditor() {
        this(true);
    }

    public AuthorizationPolicy createAuthorizationPolicy(AuthorizationPolicyID policyID) {
        if (policyID == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0001"));
        }
        AuthorizationPolicyID targetID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, AuthorizationPolicyID.class);
        AuthorizationPolicy policy = new AuthorizationPolicy(targetID);
        this.createCreationAction(targetID, policy);
        return policy;
    }

    public void remove(AuthorizationPolicyID policyID) {
        if (policyID == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0001"));
        }
        AuthorizationPolicyID targetID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, AuthorizationPolicyID.class);
        this.createDestroyAction(targetID, targetID);
    }

    public AuthorizationPolicy clonePermission(AuthorizationPolicy targetPolicy, AuthorizationPermission sourcePerm, AuthorizationRealm targetRealm) {
        if (targetPolicy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (sourcePerm == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0003"));
        }
        if (targetRealm == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0004"));
        }
        AuthorizationPolicy theTargetPolicy = (AuthorizationPolicy)this.verifyTargetClass(targetPolicy, AuthorizationPolicy.class);
        AuthorizationRealm newRealm = (AuthorizationRealm)this.verifyTargetClass(targetRealm, AuthorizationRealm.class);
        AuthorizationPermission newPerm = null;
        try {
            newPerm = (AuthorizationPermission)sourcePerm.clone();
        }
        catch (CloneNotSupportedException e) {
            Object[] params = new Object[]{sourcePerm};
            String msg = SecurityPlugin.Util.getString("ERR.014.107.0005", params);
            LogManager.logError("AUTHORIZATION", e, msg);
        }
        newPerm.setRealm(newRealm);
        theTargetPolicy = this.addPermission(theTargetPolicy, newPerm);
        return theTargetPolicy;
    }

    public AuthorizationPolicy clonePolicyPrincipals(AuthorizationPolicy sourcePolicy, AuthorizationPolicy targetPolicy) {
        return this.clonePolicyPrincipals(sourcePolicy, targetPolicy, null, null);
    }

    public AuthorizationPolicy clonePolicyPrincipals(AuthorizationPolicy sourcePolicy, AuthorizationPolicy targetPolicy, Set allPrincipals, EntitlementMigrationReport rpt) {
        if (targetPolicy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (sourcePolicy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0006"));
        }
        AuthorizationPolicy theSourcePolicy = (AuthorizationPolicy)this.verifyTargetClass(sourcePolicy, AuthorizationPolicy.class);
        AuthorizationPolicy theTargetPolicy = (AuthorizationPolicy)this.verifyTargetClass(targetPolicy, AuthorizationPolicy.class);
        Set oldPrincipals = theTargetPolicy.getPrincipals();
        if (oldPrincipals.size() > 0) {
            theTargetPolicy = this.removeAllPrincipals(theTargetPolicy);
        }
        HashSet principals = new HashSet(theSourcePolicy.getPrincipals());
        if (allPrincipals != null) {
            Iterator i = principals.iterator();
            while (i.hasNext()) {
                MetaMatrixPrincipalName principal = (MetaMatrixPrincipalName)i.next();
                if (allPrincipals.contains(principal.getName())) continue;
                i.remove();
                LogManager.logWarning("AUTHORIZATION", SecurityPlugin.Util.getString("AbstractAuthorizationObjectEditor.missing_principal", new Object[]{sourcePolicy.getAuthorizationPolicyID().getDisplayName(), principal.getName()}));
            }
        }
        theTargetPolicy = this.addAllPrincipals(theTargetPolicy, principals);
        return theTargetPolicy;
    }

    public AuthorizationPolicy setDescription(AuthorizationPolicy policy, String description) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        AuthorizationPolicyID policyID = thePolicy.getAuthorizationPolicyID();
        String oldDescription = policyID.getDescription();
        this.createExchangeAction(policyID, AuthorizationModel.Attribute.DESCRIPTION, oldDescription, description);
        policyID.setDescription(description);
        return thePolicy;
    }

    public AuthorizationPolicyID setDescription(AuthorizationPolicyID policyID, String description) {
        if (policyID == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0001"));
        }
        AuthorizationPolicyID thePolicyID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, AuthorizationPolicyID.class);
        String oldDescription = thePolicyID.getDescription();
        this.createExchangeAction(thePolicyID, AuthorizationModel.Attribute.DESCRIPTION, oldDescription, description);
        thePolicyID.setDescription(description);
        return thePolicyID;
    }

    public AuthorizationPolicy addPrincipal(AuthorizationPolicy policy, MetaMatrixPrincipalName principal) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principal == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_NAME, principal);
        thePolicy.addPrincipal(principal);
        return thePolicy;
    }

    public AuthorizationPolicy addAllPrincipals(AuthorizationPolicy policy, Set principals) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principals == null || principals.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_SET, principals);
        thePolicy.addAllPrincipals(principals);
        return thePolicy;
    }

    public AuthorizationPolicy removePrincipal(AuthorizationPolicy policy, MetaMatrixPrincipalName principal) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principal == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        Set principals = thePolicy.getPrincipals();
        if (!principals.contains(principal)) {
            return policy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_NAME, principal);
        thePolicy.removePrincipal(principal);
        return thePolicy;
    }

    public AuthorizationPolicy removePrincipals(AuthorizationPolicy policy, Set principals) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principals == null || principals.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        Set oldPrincipals = thePolicy.getPrincipals();
        oldPrincipals.removeAll(principals);
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_SET, principals);
        thePolicy.setPrincipals(oldPrincipals);
        return thePolicy;
    }

    public AuthorizationPolicy removeAllPrincipals(AuthorizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        Set oldPrincipals = thePolicy.getPrincipals();
        if (oldPrincipals.size() == 0) {
            return policy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_SET, oldPrincipals);
        thePolicy.setPrincipals(Collections.EMPTY_SET);
        return thePolicy;
    }

    public abstract Collection modifyPermissions(PermissionTreeView var1, AuthorizationPolicy var2);

    public AuthorizationPolicy addPermission(AuthorizationPolicy policy, AuthorizationPermission permission) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permission == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        AuthorizationRealm realm = permission.getRealm();
        if (realm.getRealmName().equals(RolePermissionFactory.getRealmName())) {
            return thePolicy;
        }
        String resourceToRemove = null;
        if (permission.getActions().equals(StandardAuthorizationActions.NONE)) {
            resourceToRemove = permission.getResourceName();
        }
        Iterator itr = thePolicy.iterator();
        while (itr.hasNext()) {
            AuthorizationPermission tmpPerm = (AuthorizationPermission)itr.next();
            if (resourceToRemove != null && tmpPerm.getResourceName().equals(resourceToRemove)) {
                thePolicy = this.removePermission(thePolicy, tmpPerm);
                break;
            }
            if (!permission.equals(tmpPerm)) continue;
            return thePolicy;
        }
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSION, permission);
        thePolicy.addPermission(permission);
        return thePolicy;
    }

    protected AuthorizationPolicy addAllPermissions(AuthorizationPolicy policy, Set permissions) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permissions == null || permissions.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        HashSet<AuthorizationPermission> permsToRemove = new HashSet<AuthorizationPermission>();
        for (AuthorizationPermission perm : permissions) {
            AuthorizationRealm realm;
            if (perm.getActions().equals(StandardAuthorizationActions.NONE)) {
                permsToRemove.add(perm);
            }
            if (!(realm = perm.getRealm()).getRealmName().equals(RolePermissionFactory.getRealmName())) continue;
            return thePolicy;
        }
        if (permsToRemove.size() > 0) {
            thePolicy = this.removePermissions(thePolicy, permsToRemove);
        }
        AuthorizationPermissions oldPermissions = thePolicy.getAuthorizationPermissions();
        AuthorizationPermissionsImpl newPermissions = new AuthorizationPermissionsImpl();
        newPermissions.add(permissions);
        if (oldPermissions != null && oldPermissions.size() > 0) {
            newPermissions.removeAll(oldPermissions);
        }
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSIONS, newPermissions);
        thePolicy.addAllPermissions(newPermissions);
        return thePolicy;
    }

    public AuthorizationPolicy removePermission(AuthorizationPolicy policy, AuthorizationPermission permission) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permission == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        AuthorizationPermission oldPermission = null;
        AuthorizationPermissions oldPermissions = thePolicy.getAuthorizationPermissions();
        Iterator permissionItr = oldPermissions.iterator();
        while (permissionItr.hasNext()) {
            AuthorizationPermission tmpPermission = (AuthorizationPermission)permissionItr.next();
            if (!permission.equals(tmpPermission)) continue;
            oldPermission = tmpPermission;
            break;
        }
        if (oldPermission == null) {
            return policy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSION, oldPermission);
        thePolicy.removePermission(permission);
        return thePolicy;
    }

    public AuthorizationPolicy removePermissions(AuthorizationPolicy policy, Set permissions) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permissions == null || permissions.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        AuthorizationPermissions oldPermissions = thePolicy.getAuthorizationPermissions();
        oldPermissions.removeAll(permissions);
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSION_SET, permissions);
        thePolicy.setPermissions(oldPermissions);
        return thePolicy;
    }

    public AuthorizationPolicy removePermissions(AuthorizationPolicy policy, String resource, AuthorizationRealm realm) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (resource == null || resource.trim().length() == 0) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0007"));
        }
        if (realm == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0008"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        AuthorizationRealm theRealm = (AuthorizationRealm)this.verifyTargetClass(realm, AuthorizationRealm.class);
        HashSet<AuthorizationPermission> removePerms = new HashSet<AuthorizationPermission>();
        Iterator permItr = thePolicy.iterator();
        while (permItr.hasNext()) {
            AuthorizationPermission perm = (AuthorizationPermission)permItr.next();
            if (!perm.getResourceName().equals(resource) || !perm.getRealm().equals(theRealm)) continue;
            removePerms.add(perm);
        }
        if (removePerms.size() > 0) {
            thePolicy = this.removePermissions(thePolicy, removePerms);
        }
        return thePolicy;
    }

    public AuthorizationPolicy removeAllPermissions(AuthorizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, AuthorizationPolicy.class);
        AuthorizationPermissionsImpl oldPermissions = new AuthorizationPermissionsImpl(thePolicy.getAuthorizationPermissions());
        if (oldPermissions.size() == 0) {
            return thePolicy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSIONS, oldPermissions);
        thePolicy.removePermissions();
        return thePolicy;
    }
}

