/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.admin.api.AuthorizationEditor;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.security.api.AbstractAuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.BasicAuthorizationPermission;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.DataAccessResource;
import com.metamatrix.platform.security.api.SecurityPlugin;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AuthorizationObjectEditor
extends AbstractAuthorizationObjectEditor
implements AuthorizationEditor {
    public static final long serialVersionUID = 5799168432068176908L;

    public AuthorizationObjectEditor(boolean createActions) {
        super(createActions);
    }

    public AuthorizationObjectEditor() {
        super(true);
    }

    @Override
    public AuthorizationPolicy clonePolicyPermissions(AuthorizationPolicy sourcePolicy, AuthorizationPolicy targetPolicy, AuthorizationRealm targetRealm, Set allPaths, EntitlementMigrationReport rpt) {
        if (targetPolicy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (sourcePolicy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0006"));
        }
        if (targetRealm == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0004"));
        }
        HashSet<AuthorizationPermission> permissions = new HashSet<AuthorizationPermission>();
        Iterator permItr = sourcePolicy.iterator();
        while (permItr.hasNext()) {
            AuthorizationPermission originalPerm = (AuthorizationPermission)permItr.next();
            String resourcePath = originalPerm.getResourceName();
            if (BasicAuthorizationPermission.isRecursiveResource(resourcePath)) {
                resourcePath = BasicAuthorizationPermission.removeRecursion(resourcePath);
            }
            if (allPaths.contains(resourcePath)) {
                if (rpt != null) {
                    rpt.addResourceEntry(SecurityPlugin.Util.getString("AuthorizationServiceImpl.Succeeded_migration"), resourcePath, sourcePolicy.getAuthorizationPolicyID().getDisplayName(), targetPolicy.getAuthorizationPolicyID().getDisplayName(), StandardAuthorizationActions.getActionsString(originalPerm.getActions().getValue()), SecurityPlugin.Util.getString("AuthorizationServiceImpl.Migrated"));
                }
                try {
                    AuthorizationPermission newPerm = (AuthorizationPermission)originalPerm.clone();
                    newPerm.setRealm(targetRealm);
                    permissions.add(newPerm);
                }
                catch (CloneNotSupportedException e) {
                    Object[] params = new Object[]{originalPerm};
                    String msg = SecurityPlugin.Util.getString("ERR.014.107.0005", params);
                    LogManager.logError("AUTHORIZATION", e, msg);
                }
                continue;
            }
            if (rpt != null) {
                rpt.addResourceEntry(SecurityPlugin.Util.getString("AuthorizationServiceImpl.Failed_migration"), resourcePath, sourcePolicy.getAuthorizationPolicyID().getDisplayName(), "", StandardAuthorizationActions.getActionsString(originalPerm.getActions().getValue()), SecurityPlugin.Util.getString("AuthorizationServiceImpl.The_resource_for_this_permission_does_not_exist_in_the_target_VDB."));
            }
            Object[] params = new Object[]{originalPerm};
            String msg = SecurityPlugin.Util.getString("ERR.014.107.0011", params);
            LogManager.logWarning("AUTHORIZATION", msg);
        }
        return this.addAllPermissions(targetPolicy, permissions);
    }

    @Override
    public Collection modifyPermissions(PermissionTreeView treeView, AuthorizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0012"));
        }
        AuthorizationPolicyID thePolicyID = policy.getAuthorizationPolicyID();
        AuthorizationRealm realm = new AuthorizationRealm(thePolicyID.getVDBName(), thePolicyID.getVDBVersionString());
        HashSet<AuthorizationPermission> permissionsToAdd = new HashSet<AuthorizationPermission>();
        HashSet<AuthorizationPermission> permissionsToRemove = new HashSet<AuthorizationPermission>();
        List modifiedNodes = treeView.getModified();
        HashSet<AuthorizationPermission> effectedNodes = new HashSet<AuthorizationPermission>();
        AuthorizationPermissions currentPerms = policy.getAuthorizationPermissions();
        BasicAuthorizationPermissionFactory permFactory = new BasicAuthorizationPermissionFactory();
        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Starting...");
        for (PermissionDataNodeImpl aNode : modifiedNodes) {
            LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Effected node: " + aNode);
            AuthorizationActions theActions = aNode.getActions();
            String resourceName = aNode.getResourceName();
            AuthorizationPermission newPerm = null;
            AuthorizationPermission oldPerm = null;
            boolean isGroupNode = aNode.isGroupNode();
            if (aNode.isLeafNode() || isGroupNode) {
                LogManager.logTrace("AUTHORIZATION", "modifyPermissions: LEAF or GROUP - actions <" + theActions + ">");
                oldPerm = this.getExistingPermission(aNode, policy);
                if (oldPerm != null) {
                    LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Removing permission: " + oldPerm);
                    currentPerms.remove(oldPerm);
                    permissionsToRemove.add(oldPerm);
                    effectedNodes.add(oldPerm);
                }
                if (!theActions.equals(StandardAuthorizationActions.NONE)) {
                    if (aNode.isLeafNode()) {
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Creating LEAF permission.");
                        newPerm = permFactory.create(resourceName, realm, theActions);
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Adding new ELEMENT perm: <" + newPerm.getResourceName() + " - " + newPerm.getActions() + ">");
                        permissionsToAdd.add(newPerm);
                    } else if (isGroupNode) {
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Creating GROUP " + theActions + " permission.");
                        newPerm = permFactory.create(resourceName, realm, theActions);
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Adding new GROUP perm: <" + newPerm.getResourceName() + " - " + newPerm.getActions() + ">");
                        permissionsToAdd.add(newPerm);
                    }
                }
            }
            aNode.setModified(false, false);
        }
        this.removePermissions(policy, permissionsToRemove);
        this.addAllPermissions(policy, permissionsToAdd);
        return effectedNodes;
    }

    private AuthorizationPermission getExistingPermission(PermissionDataNode aNode, AuthorizationPolicy policy) {
        AuthorizationPermission permToRemove = null;
        String resourceName = aNode.getResourceName();
        DataAccessResource resource = new DataAccessResource(resourceName);
        permToRemove = policy.findPermissionWithResource(resource);
        return permToRemove;
    }
}

