/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.SecurityPlugin;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.io.Serializable;

public abstract class AuthorizationPermission
implements Comparable,
Serializable {
    public static final AuthorizationActions DEFAULT_ACTIONS = StandardAuthorizationActions.NONE;
    protected AuthorizationResource resource;
    private AuthorizationRealm realm;
    private String factoryClassName;
    private String contentModifier;
    protected int hashCode;
    protected int PRIME = 1000003;
    private AuthorizationActions actions;

    protected AuthorizationPermission(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String contentModifier, String factoryClassName) {
        if (factoryClassName == null || factoryClassName.trim().length() == 0) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0013"));
        }
        if (resource == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0014"));
        }
        this.resource = resource;
        this.realm = realm;
        this.contentModifier = contentModifier;
        this.actions = actions != null ? actions : DEFAULT_ACTIONS;
        this.factoryClassName = factoryClassName;
        this.hashCode = this.computeHashCode();
    }

    protected AuthorizationPermission(AuthorizationResource resource, AuthorizationRealm realm, String factoryClassName) {
        this(resource, realm, DEFAULT_ACTIONS, null, factoryClassName);
    }

    protected AuthorizationPermission(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String factoryClassName) {
        this(resource, realm, actions, null, factoryClassName);
    }

    protected abstract Object clone() throws CloneNotSupportedException;

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public boolean resourceIsRecursive() {
        return this.resource.isRecursive();
    }

    public String getResourceName() {
        return this.resource.getID();
    }

    public AuthorizationResource getResource() {
        return this.resource;
    }

    public boolean hasContentModifier() {
        return this.contentModifier != null;
    }

    public String getContentModifier() {
        return this.contentModifier;
    }

    public String getRealmName() {
        return this.realm.getRealmName();
    }

    public AuthorizationRealm getRealm() {
        return this.realm;
    }

    void setRealm(AuthorizationRealm realm) {
        this.realm = realm;
    }

    public AuthorizationActions getActions() {
        return this.actions;
    }

    public abstract boolean implies(AuthorizationPermission var1);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Realm=<");
        sb.append(this.realm);
        sb.append("> Resource=<");
        sb.append(this.resource.getID());
        sb.append("> Actions=<");
        sb.append(this.actions);
        sb.append("> Factory=<");
        sb.append(this.factoryClassName);
        sb.append(">]");
        return sb.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuthorizationPermission) {
            return AuthorizationPermission.compare(this, (AuthorizationPermission)obj) == 0;
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0015"));
        }
        if (!(o instanceof AuthorizationPermission)) {
            throw new ClassCastException(SecurityPlugin.Util.getString("ERR.014.107.0016"));
        }
        return AuthorizationPermission.compare(this, (AuthorizationPermission)o);
    }

    public static final int compare(AuthorizationPermission obj1, AuthorizationPermission obj2) {
        if (obj1.hashCode != obj2.hashCode) {
            return obj1.hashCode - obj2.hashCode;
        }
        int resourceDiff = obj1.resource.compareTo(obj2.resource);
        if (resourceDiff != 0) {
            return resourceDiff;
        }
        int actionDiff = obj1.actions.compareTo(obj2.actions);
        if (actionDiff != 0) {
            return actionDiff;
        }
        int realmDiff = obj1.realm.compareTo(obj2.realm);
        if (realmDiff != 0) {
            return realmDiff;
        }
        if (obj1.contentModifier == null && obj2.contentModifier == null) {
            return 0;
        }
        if (obj1.contentModifier != null) {
            return obj1.contentModifier.compareTo(obj2.contentModifier);
        }
        return obj2.contentModifier.compareTo(obj1.contentModifier);
    }

    private int computeHashCode() {
        int result = 0;
        result = this.PRIME * result + this.actions.hashCode();
        result = this.PRIME * result + this.resource.hashCode();
        result = this.PRIME * result + this.realm.hashCode();
        if (this.contentModifier != null) {
            result = this.PRIME * result + this.contentModifier.hashCode();
        }
        return result;
    }
}

