/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import com.metamatrix.platform.security.api.SecurityPlugin;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class AuthorizationPermissionsImpl
implements AuthorizationPermissions {
    private Set thePermissions;
    private Object lockObj = new Object();
    private boolean readOnly = false;

    public AuthorizationPermissionsImpl() {
        this.thePermissions = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationPermissionsImpl(AuthorizationPermissions orig) {
        this();
        Object object = this.lockObj;
        synchronized (object) {
            Iterator permItr = orig.iterator();
            while (permItr.hasNext()) {
                AuthorizationPermission aPerm = (AuthorizationPermission)permItr.next();
                if (aPerm == null) continue;
                try {
                    this.thePermissions.add(aPerm.clone());
                }
                catch (CloneNotSupportedException e) {
                    Object[] params = new Object[]{aPerm};
                    String msg = SecurityPlugin.Util.getString("ERR.014.107.0005", params);
                    LogManager.logError("AUTHORIZATION", e, msg);
                }
            }
        }
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(AuthorizationPermission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException(SecurityPlugin.Util.getString("ERR.014.107.0017"));
        }
        boolean result = false;
        if (permission != null) {
            Object object = this.lockObj;
            synchronized (object) {
                result = this.thePermissions.add(permission);
            }
        }
        return result;
    }

    @Override
    public boolean add(AuthorizationPermissions permissions) {
        if (this.isReadOnly()) {
            throw new SecurityException(SecurityPlugin.Util.getString("ERR.014.107.0017"));
        }
        boolean result = false;
        if (permissions != null) {
            result = this.addPermissions(permissions.iterator());
        }
        return result;
    }

    @Override
    public boolean add(Set permissions) {
        if (this.isReadOnly()) {
            throw new SecurityException(SecurityPlugin.Util.getString("ERR.014.107.0017"));
        }
        boolean result = false;
        if (permissions != null) {
            result = this.addPermissions(permissions.iterator());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(AuthorizationPermission permission) {
        boolean result = false;
        Object object = this.lockObj;
        synchronized (object) {
            result = this.thePermissions.remove(permission);
        }
        return result;
    }

    @Override
    public boolean removeAll(Set permissions) {
        boolean result = false;
        if (permissions != null) {
            result = this.removePermissions(permissions.iterator());
        }
        return result;
    }

    @Override
    public boolean removeAll(AuthorizationPermissions permissions) {
        boolean result = false;
        if (permissions != null) {
            result = this.removePermissions(permissions.iterator());
        }
        return result;
    }

    @Override
    public void clear() {
        this.thePermissions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        Iterator permItr = Collections.EMPTY_SET.iterator();
        Object object = this.lockObj;
        synchronized (object) {
            permItr = this.thePermissions.iterator();
        }
        return permItr;
    }

    @Override
    public boolean implies(AuthorizationPermission permission) {
        if (permission == null) {
            return false;
        }
        for (AuthorizationPermission aPerm : this.thePermissions) {
            if (!aPerm.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.thePermissions.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            try {
                sb.append(iter.next().toString() + ',');
            }
            catch (NoSuchElementException e) {}
        }
        int sbLen = sb.length();
        if (sbLen > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPermissions(Iterator permIter) {
        boolean result = false;
        Object object = this.lockObj;
        synchronized (object) {
            while (permIter.hasNext()) {
                AuthorizationPermission aPerm = (AuthorizationPermission)permIter.next();
                if (aPerm == null || !this.thePermissions.add(aPerm) || result) continue;
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePermissions(Iterator permIter) {
        boolean result = false;
        Object object = this.lockObj;
        synchronized (object) {
            while (permIter.hasNext()) {
                AuthorizationPermission aPerm = (AuthorizationPermission)permIter.next();
                if (aPerm == null || !this.thePermissions.remove(aPerm) || result) continue;
                result = true;
            }
        }
        return result;
    }
}

