/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.security.api.SecurityPlugin;
import java.io.Serializable;
import java.util.List;

public class AuthorizationRealm
implements Comparable,
Serializable {
    private static final String REALM_DELIMITER = ".";
    private static final int NUMBER_OF_REALM_COMPONENTS = 2;
    private String superRealmName;
    private String subRealmName;
    private String description;
    public static final int MAX_DESCRIPTION_LEN = 550;
    private int hashCode;

    public AuthorizationRealm(String realmName) {
        if (realmName == null || realmName.trim().length() == 0) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0031"));
        }
        if (realmName.indexOf(REALM_DELIMITER) >= 0) {
            List realms = StringUtil.split((String)realmName, (String)REALM_DELIMITER);
            if (realms.size() > 2) {
                throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0032", new Object[]{realmName}));
            }
            this.init((String)realms.get(0), (String)realms.get(1), null);
        } else {
            this.init(realmName, null, null);
        }
    }

    public AuthorizationRealm(String superRealmName, String subRealmName) {
        this(superRealmName, subRealmName, null);
    }

    public AuthorizationRealm(String superRealmName, String subRealmName, String description) {
        if (superRealmName == null || superRealmName.trim().length() == 0) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0031"));
        }
        if (superRealmName.indexOf(REALM_DELIMITER) >= 0 || subRealmName != null && subRealmName.indexOf(REALM_DELIMITER) >= 0) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0033", new Object[]{superRealmName, subRealmName}));
        }
        this.init(superRealmName, subRealmName, description);
    }

    private void init(String superRealmName, String subRealmName, String description) {
        this.superRealmName = superRealmName;
        if (subRealmName != null && subRealmName.trim().length() > 0) {
            int nonZeroIndex;
            char[] chars = subRealmName.toCharArray();
            for (nonZeroIndex = 0; chars[nonZeroIndex] == '0' && nonZeroIndex < chars.length; ++nonZeroIndex) {
            }
            if (nonZeroIndex >= chars.length) {
                throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0034"));
            }
            this.subRealmName = subRealmName.substring(nonZeroIndex);
        }
        this.setDescription(description);
        this.hashCode = this.getRealmName().hashCode();
    }

    public String getRealmName() {
        StringBuffer realm = new StringBuffer(this.superRealmName);
        if (this.subRealmName != null) {
            realm.append(REALM_DELIMITER);
            realm.append(this.subRealmName);
        }
        return realm.toString();
    }

    public String getSuperRealmName() {
        return this.superRealmName;
    }

    public String getSubRealmName() {
        return this.subRealmName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description != null && description.trim().length() > 0) {
            this.description = StringUtil.truncString((String)description, (int)550);
        }
    }

    public String toString() {
        return this.getRealmName();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuthorizationRealm) {
            return AuthorizationRealm.compare(this, (AuthorizationRealm)obj) == 0;
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0035"));
        }
        if (!(o instanceof AuthorizationRealm)) {
            throw new ClassCastException(SecurityPlugin.Util.getString("ERR.014.107.0036", new Object[]{o.getClass()}));
        }
        return AuthorizationRealm.compare(this, (AuthorizationRealm)o);
    }

    public static final int compare(AuthorizationRealm obj1, AuthorizationRealm obj2) {
        return obj1.getRealmName().compareTo(obj2.getRealmName());
    }
}

