/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.BasicAuthorizationPermission;
import com.metamatrix.platform.security.api.DataAccessResource;
import java.io.Serializable;

public class BasicAuthorizationPermissionFactory
implements AuthorizationPermissionFactory,
Serializable {
    @Override
    public Class getPermissionClass() {
        return BasicAuthorizationPermission.class;
    }

    @Override
    public AuthorizationResource createResource(String name) {
        return new DataAccessResource(name);
    }

    @Override
    public AuthorizationPermission create(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String contentModifier) {
        String factoryClassName = this.getClass().getName();
        return new BasicAuthorizationPermission(resource, realm, actions, contentModifier, factoryClassName);
    }

    @Override
    public AuthorizationPermission create(String resource, AuthorizationRealm realm) {
        return new BasicAuthorizationPermission(new DataAccessResource(resource), realm, this.getClass().getName());
    }

    @Override
    public AuthorizationPermission create(String resource, AuthorizationRealm realm, AuthorizationActions actions) {
        return new BasicAuthorizationPermission(new DataAccessResource(resource), realm, actions, this.getClass().getName());
    }
}

