/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.SecurityPlugin;
import java.io.Serializable;

public class DataAccessResource
implements AuthorizationResource,
Serializable {
    private static final String SEPARATOR = ".";
    public static final String RECURSIVE = "*";
    private static final String ALL_NODES = "*";
    public static final String SEPARATOR_WITH_RECURSIVE = ".*";
    private String name;
    private String canonicalName;
    private boolean isRecursive;

    public DataAccessResource(String name) {
        this.name = name;
        this.init(name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataAccessResource) {
            return this.name.equals(((DataAccessResource)obj).name);
        }
        return false;
    }

    @Override
    public boolean isCannonicallyEquivalent(AuthorizationResource resource) {
        if (resource instanceof DataAccessResource) {
            return this.canonicalName.equals(((DataAccessResource)resource).canonicalName);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public String getUUID() {
        return null;
    }

    @Override
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public boolean isRecursive() {
        return this.isRecursive;
    }

    void setRecursive(boolean recursive) {
        this.isRecursive = recursive;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.107.0043"));
        }
        if (!(o instanceof DataAccessResource)) {
            throw new ClassCastException(SecurityPlugin.Util.getString("ERR.014.107.0044", new Object[]{o.getClass()}));
        }
        return this.name.compareTo(((DataAccessResource)o).name);
    }

    @Override
    public boolean implies(AuthorizationResource thatResource) {
        int lastSepIndex;
        if (!(thatResource instanceof DataAccessResource)) {
            return false;
        }
        DataAccessResource that = (DataAccessResource)thatResource;
        if (this.isRecursive ? that.canonicalName.startsWith(this.canonicalName) : !that.isRecursive && (lastSepIndex = this.canonicalName.lastIndexOf(SEPARATOR)) > 0 && this.canonicalName.substring(0, lastSepIndex).equals(that.canonicalName)) {
            return true;
        }
        return this.canonicalName.equals(that.canonicalName);
    }

    private void init(String resourceName) {
        if (resourceName.equals("*")) {
            this.isRecursive = true;
            this.canonicalName = "";
        }
        if (resourceName.endsWith(SEPARATOR_WITH_RECURSIVE)) {
            this.isRecursive = true;
            this.canonicalName = resourceName.substring(0, resourceName.length() - 2);
        } else if (resourceName.endsWith("*")) {
            this.isRecursive = true;
            this.canonicalName = resourceName.substring(0, resourceName.length() - 1);
        } else {
            this.canonicalName = resourceName;
        }
        this.canonicalName = this.canonicalName.toLowerCase();
    }

    public String toString() {
        return this.name;
    }
}

