/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.util;

import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.SecurityPlugin;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;

public class RolePermission
extends AuthorizationPermission
implements Cloneable {
    private static final AuthorizationActions ALL = StandardAuthorizationActions.ALL;

    RolePermission(AuthorizationResource resource, AuthorizationRealm realm, String factoryClassName) {
        super(resource, realm, ALL, factoryClassName);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new RolePermission(this.getResource(), this.getRealm(), this.getFactoryClassName());
    }

    @Override
    public boolean resourceIsRecursive() {
        return false;
    }

    @Override
    public boolean implies(AuthorizationPermission request) {
        if (!(request instanceof RolePermission)) {
            return false;
        }
        RolePermission that = (RolePermission)request;
        return this.getResourceName().equals(that.getResourceName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RolePermission) {
            return RolePermission.compare(this, (RolePermission)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(SecurityPlugin.Util.getString("ERR.014.607.0001"));
        }
        if (!(o instanceof RolePermission)) {
            throw new ClassCastException(SecurityPlugin.Util.getString("ERR.014.607.0002", new Object[]{o.getClass()}));
        }
        return RolePermission.compare(this, (RolePermission)o);
    }
}

