/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.admin.apiimpl;

import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.platform.security.api.SecurityPlugin;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import java.io.InputStream;
import java.io.Serializable;

public class MaterializationLoadScriptsImpl
implements MaterializationLoadScripts,
Serializable {
    private String truncateFileName;
    private byte[] truncateFileContents;
    private String loadFileName;
    private byte[] loadFileContents;
    private String swapFileName;
    private byte[] swapFileContents;
    private String conPropsFileName;
    private byte[] conPropsFileContents;
    private String createFileName;
    private byte[] createFileContents;

    MaterializationLoadScriptsImpl() {
    }

    public void setLoadScript(String fileName, byte[] fileContents) {
        if (fileName == null) {
            throw new MetaMatrixRuntimeException(SecurityPlugin.Util.getString("MaterializationLoadScriptsImpl.null_load_script_file_name"));
        }
        if (fileContents == null || fileContents.length == 0) {
            throw new MetaMatrixRuntimeException(SecurityPlugin.Util.getString("MaterializationLoadScriptsImpl.null_load_script_file_contents"));
        }
        this.loadFileName = fileName;
        this.loadFileContents = fileContents;
    }

    @Override
    public InputStream getLoadScriptFile() {
        try {
            return ByteArrayHelper.toInputStream((byte[])this.loadFileContents);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public String getLoadScriptFileName() {
        return this.loadFileName;
    }

    public void setSwapScript(String fileName, byte[] fileContents) {
        this.swapFileName = fileName;
        this.swapFileContents = fileContents;
    }

    @Override
    public InputStream getSwapScriptFile() {
        try {
            return ByteArrayHelper.toInputStream((byte[])this.swapFileContents);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public String getSwapScriptFileName() {
        return this.swapFileName;
    }

    public void setTruncateScript(String fileName, byte[] fileContents) {
        this.truncateFileName = fileName;
        this.truncateFileContents = fileContents;
    }

    @Override
    public InputStream getTruncateScriptFile() {
        try {
            return ByteArrayHelper.toInputStream((byte[])this.truncateFileContents);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public String getTruncateScriptFileName() {
        return this.truncateFileName;
    }

    public void setCreateScript(String fileName, byte[] fileContents) {
        this.createFileName = fileName;
        this.createFileContents = fileContents;
    }

    @Override
    public InputStream getCreateScriptFile() {
        try {
            return ByteArrayHelper.toInputStream((byte[])this.createFileContents);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public String getCreateScriptFileName() {
        return this.createFileName;
    }

    @Override
    public InputStream getConnectionPropsFileContents() {
        try {
            return ByteArrayHelper.toInputStream((byte[])this.conPropsFileContents);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public String getConnectionPropsFileName() {
        return this.conPropsFileName;
    }

    public void setConnectionPropsFile(String conPropsFileName, byte[] conPropsFileContents) {
        this.conPropsFileName = conPropsFileName;
        this.conPropsFileContents = conPropsFileContents;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.createFileName);
        buf.append('\n');
        buf.append(this.createFileContents);
        buf.append("\n\n");
        buf.append(this.loadFileName);
        buf.append('\n');
        buf.append(this.loadFileContents);
        buf.append("\n\n");
        buf.append(this.truncateFileName);
        buf.append('\n');
        buf.append(this.truncateFileContents);
        buf.append("\n\n");
        buf.append(this.swapFileName);
        buf.append('\n');
        buf.append(this.swapFileContents);
        buf.append("\n\n");
        buf.append(this.conPropsFileName);
        buf.append('\n');
        buf.append(this.conPropsFileContents);
        buf.append("\n\n");
        return buf.toString();
    }

    public byte[] getConPropsFileContents() {
        return this.conPropsFileContents;
    }

    public byte[] getCreateFileContents() {
        return this.createFileContents;
    }

    public byte[] getLoadFileContents() {
        return this.loadFileContents;
    }

    public byte[] getSwapFileContents() {
        return this.swapFileContents;
    }

    public byte[] getTruncateFileContents() {
        return this.truncateFileContents;
    }
}

